/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import org.jetbrains.annotations.NotNull;

public class ModulePointerImpl
implements ModulePointer {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.module.impl.ModulePointerImpl");
    private Module myModule;
    private String myModuleName;

    ModulePointerImpl(Module module) {
        this.myModule = module;
        this.myModuleName = null;
    }

    ModulePointerImpl(String name) {
        this.myModule = null;
        this.myModuleName = name;
    }

    @Override
    public Module getModule() {
        return this.myModule;
    }

    @Override
    @NotNull
    public String getModuleName() {
        if (this.myModule != null) {
            String string = this.myModule.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModulePointerImpl", "getModuleName"));
            }
            return string;
        }
        String string = this.myModuleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModulePointerImpl", "getModuleName"));
        }
        return string;
    }

    void moduleAdded(Module module) {
        LOG.assertTrue(this.myModule == null);
        LOG.assertTrue(this.myModuleName.equals(module.getName()));
        this.myModuleName = null;
        this.myModule = module;
    }

    void moduleRemoved(Module module) {
        LOG.assertTrue(this.myModule == module);
        this.myModuleName = this.myModule.getName();
        this.myModule = null;
    }
}

