/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.canBeFinal.CanBeFinalHandler;
import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeFieldFinalFix;
import com.siyeh.ig.psiutils.FinalUtils;
import org.jetbrains.annotations.NotNull;

public class FieldMayBeFinalInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("field.may.be.final.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/FieldMayBeFinalInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("field.may.be.final.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/FieldMayBeFinalInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public boolean runForWholeFile() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return MakeFieldFinalFix.buildFixUnconditional((PsiField)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FieldMayBeFinalVisitor();
    }

    private static class FieldMayBeFinalVisitor
    extends BaseInspectionVisitor {
        private FieldMayBeFinalVisitor() {
        }

        @Override
        public void visitField(PsiField field) {
            super.visitField(field);
            if (field.hasModifierProperty("final") || !field.hasModifierProperty("private")) {
                return;
            }
            if (!CanBeFinalHandler.allowToBeFinal(field)) {
                return;
            }
            if (!FinalUtils.canBeFinal(field)) {
                return;
            }
            this.registerVariableError(field, field);
        }
    }
}

