/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import gnu.trove.THashSet;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class StringTokenizerDelimiterInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final String NEXT_TOKEN = "nextToken";
    private static final String STRING_TOKENIZER = "java.util.StringTokenizer";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/StringTokenizerDelimiterInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitCallExpression(PsiCallExpression callExpression) {
                PsiClass stringTokenizer;
                PsiExpressionList argumentList = callExpression.getArgumentList();
                PsiMethod method = callExpression.resolveMethod();
                if (method != null && argumentList != null && (method.isConstructor() || StringTokenizerDelimiterInspection.NEXT_TOKEN.equals(method.getName())) && (stringTokenizer = method.getContainingClass()) != null && StringTokenizerDelimiterInspection.STRING_TOKENIZER.equals(stringTokenizer.getQualifiedName())) {
                    PsiExpression[] arguments = argumentList.getExpressions();
                    int argCount = arguments.length;
                    if (method.isConstructor()) {
                        if (argCount == 2 || argCount == 3) {
                            StringTokenizerDelimiterInspection.hasArgumentDuplicates(arguments[1], holder);
                        }
                    } else if (argCount == 1) {
                        StringTokenizerDelimiterInspection.hasArgumentDuplicates(arguments[0], holder);
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StringTokenizerDelimiterInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static void hasArgumentDuplicates(PsiExpression delimiterArgument, ProblemsHolder holder) {
        Object value;
        if (delimiterArgument instanceof PsiLiteralExpression && (value = ((PsiLiteralExpression)delimiterArgument).getValue()) instanceof String) {
            String delimiters = (String)value;
            THashSet chars = new THashSet();
            for (char c : delimiters.toCharArray()) {
                if (chars.add(Character.valueOf(c))) continue;
                holder.registerProblem((PsiElement)delimiterArgument, "Delimiters argument contains duplicated characters", new ReplaceDelimitersWithUnique(delimiterArgument));
                return;
            }
        }
    }

    private static final class ReplaceDelimitersWithUnique
    extends LocalQuickFixOnPsiElement {
        public ReplaceDelimitersWithUnique(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/StringTokenizerDelimiterInspection$ReplaceDelimitersWithUnique", "<init>"));
            }
            super(element);
        }

        @Override
        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StringTokenizerDelimiterInspection$ReplaceDelimitersWithUnique", "getText"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Replace StringTokenizer delimiters parameter with unique symbols" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StringTokenizerDelimiterInspection$ReplaceDelimitersWithUnique", "getFamilyName"));
            }
            return "Replace StringTokenizer delimiters parameter with unique symbols";
        }

        @Override
        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/StringTokenizerDelimiterInspection$ReplaceDelimitersWithUnique", "invoke"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/StringTokenizerDelimiterInspection$ReplaceDelimitersWithUnique", "invoke"));
            }
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInspection/StringTokenizerDelimiterInspection$ReplaceDelimitersWithUnique", "invoke"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInspection/StringTokenizerDelimiterInspection$ReplaceDelimitersWithUnique", "invoke"));
            }
            LinkedHashSet<Character> uniqueChars = new LinkedHashSet<Character>();
            PsiLiteralExpression delimiterArgument = (PsiLiteralExpression)startElement;
            Object literal = delimiterArgument.getValue();
            if (!(literal instanceof String)) {
                return;
            }
            for (char c : ((String)literal).toCharArray()) {
                uniqueChars.add(Character.valueOf(c));
            }
            String newDelimiters = StringUtil.join(uniqueChars, "");
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(project);
            delimiterArgument.replace(elementFactory.createExpressionFromText(StringUtil.wrapWithDoubleQuote(StringUtil.escaper(true, "\"").fun(newDelimiters)), null));
        }
    }
}

