/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.html.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.lang.html.structureView.Html5SectionTreeElement;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.SortedList;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class Html5SectionsProcessor {
    private static final String[] SECTIONING_ROOT_ELEMENTS = new String[]{"blockquote", "body", "details", "dialog", "fieldset", "figure", "td"};
    private static final String[] SECTIONING_CONTENT_ELEMENTS = new String[]{"article", "aside", "nav", "section"};
    private static final String[] HEADER_ELEMENTS = new String[]{"h1", "h2", "h3", "h4", "h5", "h6"};
    private static final String HGROUP_ELEMENT = "hgroup";
    private final Collection<SectionHolder> myRootSectionHolders = new SortedList<SectionHolder>((first, second) -> first.getTag().getTextRange().getStartOffset() - second.getTag().getTextRange().getStartOffset());
    private SectionHolder myCurrentOutlinee = null;
    private Section myCurrentSection = null;
    private final Stack<SectionHolder> myStack = new Stack();

    Html5SectionsProcessor() {
    }

    public static Collection<Html5SectionTreeElement> processAndGetRootSections(XmlTag rootTag) {
        Html5SectionsProcessor processor = new Html5SectionsProcessor();
        Html5SectionsProcessor.processRecursively(rootTag, processor);
        return processor.getRootSections();
    }

    private static void processRecursively(XmlTag tag, Html5SectionsProcessor processor) {
        if (tag.getAttribute("hidden") != null) {
            return;
        }
        processor.tagEntered(tag);
        if (!Html5SectionsProcessor.isHeader(tag)) {
            for (XmlTag subTag : tag.getSubTags()) {
                Html5SectionsProcessor.processRecursively(subTag, processor);
            }
        }
        processor.tagExited(tag);
    }

    private void tagEntered(XmlTag tag) {
        if (Html5SectionsProcessor.isSectioningContentElement(tag) || Html5SectionsProcessor.isSectioningRootElement(tag)) {
            if (this.myCurrentOutlinee != null) {
                this.myStack.push(this.myCurrentOutlinee);
            }
            this.myCurrentOutlinee = new SectionHolder(tag);
            this.myCurrentSection = new Section(tag);
            this.myCurrentOutlinee.addChildSection(this.myCurrentSection);
        } else if (this.myCurrentOutlinee != null && Html5SectionsProcessor.isHeader(tag)) {
            if (this.myCurrentSection.getHeader() == null) {
                this.myCurrentSection.setHeader(tag);
            } else if (this.myCurrentOutlinee.getChildren().getLast().getHeader() == null || Html5SectionsProcessor.compareHeaderRanks(tag, this.myCurrentOutlinee.getChildren().getLast().getHeader()) >= 0) {
                this.myCurrentSection = new Section(tag);
                this.myCurrentSection.setHeader(tag);
                this.myCurrentOutlinee.addChildSection(this.myCurrentSection);
            } else {
                Section candidateSection = this.myCurrentSection;
                while (true) {
                    if (Html5SectionsProcessor.compareHeaderRanks(tag, candidateSection.getHeader()) < 0) {
                        this.myCurrentSection = new Section(tag);
                        this.myCurrentSection.setHeader(tag);
                        candidateSection.addChildSection(this.myCurrentSection);
                        break;
                    }
                    candidateSection = candidateSection.getParent();
                }
            }
        }
    }

    private void tagExited(XmlTag tag) {
        if (!this.myStack.isEmpty() && this.myStack.peek().getTag() == tag) {
            assert (false);
        } else if (this.myStack.isEmpty() || !Html5SectionsProcessor.isHeader(tag)) {
            if (!this.myStack.isEmpty() && Html5SectionsProcessor.isSectioningContentElement(tag)) {
                SectionHolder exitedSectioningContent = this.myCurrentOutlinee;
                assert (exitedSectioningContent.getTag() == tag);
                this.myCurrentOutlinee = this.myStack.pop();
                this.myCurrentSection = this.myCurrentOutlinee.getChildren().getLast();
                for (Section section : exitedSectioningContent.getChildren()) {
                    this.myCurrentSection.addChildSection(section);
                }
            } else if (!this.myStack.isEmpty() && Html5SectionsProcessor.isSectioningRootElement(tag)) {
                SectionHolder exitedSectioningRoot = this.myCurrentOutlinee;
                assert (exitedSectioningRoot.getTag() == tag);
                this.myRootSectionHolders.add(exitedSectioningRoot);
                this.myCurrentOutlinee = this.myStack.pop();
                this.myCurrentSection = this.myCurrentOutlinee.getChildren().getLast();
                while (!this.myCurrentSection.getChildren().isEmpty()) {
                    this.myCurrentSection = this.myCurrentSection.getChildren().getLast();
                }
            } else if (Html5SectionsProcessor.isSectioningContentElement(tag) || Html5SectionsProcessor.isSectioningRootElement(tag)) {
                assert (this.myStack.isEmpty());
                assert (this.myCurrentOutlinee.getTag() == tag);
                this.myRootSectionHolders.add(this.myCurrentOutlinee);
                this.myCurrentOutlinee = null;
                this.myCurrentSection = null;
            }
        }
    }

    private Collection<Html5SectionTreeElement> getRootSections() {
        ArrayList<Html5SectionTreeElement> result = new ArrayList<Html5SectionTreeElement>();
        for (SectionHolder sectionHolder : this.myRootSectionHolders) {
            for (Section section : sectionHolder.getChildren()) {
                result.add(Html5SectionsProcessor.createHtml5SectionTreeElement(section));
            }
        }
        return result;
    }

    private static Html5SectionTreeElement createHtml5SectionTreeElement(Section section) {
        return new Html5SectionTreeElement(section.getTag(), Html5SectionsProcessor.createChildrenComputable(section.getChildren()), Html5SectionsProcessor.getHeaderText(section.getHeader()));
    }

    private static Computable<Collection<StructureViewTreeElement>> createChildrenComputable(Collection<Section> children) {
        return () -> {
            ArrayList<Html5SectionTreeElement> result = new ArrayList<Html5SectionTreeElement>();
            for (Section section : children) {
                result.add(Html5SectionsProcessor.createHtml5SectionTreeElement(section));
            }
            return result;
        };
    }

    private static String getHeaderText(@Nullable XmlTag header) {
        if (header == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        if (HGROUP_ELEMENT.equalsIgnoreCase(header.getLocalName())) {
            for (XmlTag subTag : header.getSubTags()) {
                if (!ArrayUtil.contains(subTag.getLocalName().toLowerCase(), HEADER_ELEMENTS)) continue;
                if (buf.length() > 0) {
                    buf.append(" ");
                }
                Html5SectionsProcessor.appendTextRecursively(subTag, buf, 100);
            }
        } else {
            Html5SectionsProcessor.appendTextRecursively(header, buf, 100);
        }
        return buf.toString();
    }

    private static void appendTextRecursively(XmlTag tag, StringBuilder buf, int maximumTextLength) {
        if (buf.length() >= maximumTextLength) {
            return;
        }
        String text = tag.getValue().getTrimmedText();
        if (!text.isEmpty()) {
            buf.append(text);
        } else {
            for (XmlTag subTag : tag.getSubTags()) {
                Html5SectionsProcessor.appendTextRecursively(subTag, buf, maximumTextLength);
            }
        }
    }

    private static boolean isSectioningRootElement(XmlTag tag) {
        return ArrayUtil.contains(tag.getLocalName().toLowerCase(), SECTIONING_ROOT_ELEMENTS);
    }

    private static boolean isSectioningContentElement(XmlTag tag) {
        return ArrayUtil.contains(tag.getLocalName().toLowerCase(), SECTIONING_CONTENT_ELEMENTS);
    }

    private static boolean isHeader(XmlTag tag) {
        return ArrayUtil.contains(tag.getLocalName().toLowerCase(), HEADER_ELEMENTS) || HGROUP_ELEMENT.equalsIgnoreCase(tag.getLocalName());
    }

    private static int compareHeaderRanks(@NotNull XmlTag header1, @NotNull XmlTag header2) {
        if (header1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header1", "com/intellij/lang/html/structureView/Html5SectionsProcessor", "compareHeaderRanks"));
        }
        if (header2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header2", "com/intellij/lang/html/structureView/Html5SectionsProcessor", "compareHeaderRanks"));
        }
        return Html5SectionsProcessor.getHeaderRank(header2) - Html5SectionsProcessor.getHeaderRank(header1);
    }

    private static int getHeaderRank(XmlTag header) {
        if (HGROUP_ELEMENT.equalsIgnoreCase(header.getLocalName())) {
            XmlTag subTag;
            int index;
            int minIndex = HEADER_ELEMENTS.length;
            XmlTag[] xmlTagArray = header.getSubTags();
            int n = xmlTagArray.length;
            for (int j = 0; j < n && ((index = ArrayUtil.indexOf(HEADER_ELEMENTS, (subTag = xmlTagArray[j]).getLocalName().toLowerCase())) >= minIndex || (minIndex = index) != 0); ++j) {
            }
            if (minIndex == HEADER_ELEMENTS.length) {
                minIndex = 0;
            }
            return minIndex + 1;
        }
        int index = ArrayUtil.indexOf(HEADER_ELEMENTS, header.getLocalName().toLowerCase());
        if (index < 0) {
            throw new IllegalArgumentException(header.getName());
        }
        return index + 1;
    }

    private static class Section
    extends SectionHolder {
        private Section myParent = null;
        private XmlTag myHeader = null;

        public Section(XmlTag tag) {
            super(tag);
        }

        @Override
        public void addChildSection(Section section) {
            section.myParent = this;
            super.addChildSection(section);
        }

        public XmlTag getHeader() {
            return this.myHeader;
        }

        public void setHeader(XmlTag header) {
            this.myHeader = header;
        }

        public Section getParent() {
            return this.myParent;
        }
    }

    private static class SectionHolder {
        private final XmlTag myTag;
        private final LinkedList<Section> myChildren = new LinkedList();

        private SectionHolder(XmlTag tag) {
            this.myTag = tag;
        }

        public void addChildSection(Section section) {
            this.myChildren.add(section);
        }

        public LinkedList<Section> getChildren() {
            return this.myChildren;
        }

        public XmlTag getTag() {
            return this.myTag;
        }
    }
}

