/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.mock.MockComponentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class MockProject
extends MockComponentManager
implements Project {
    private static final Logger LOG = Logger.getInstance("#com.intellij.mock.MockProject");
    private VirtualFile myBaseDir;

    public MockProject(PicoContainer parent, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/mock/MockProject", "<init>"));
        }
        super(parent, parentDisposable);
        Extensions.instantiateArea("IDEA_PROJECT", this, null);
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                Extensions.disposeArea(MockProject.this);
            }
        });
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    @NotNull
    public Condition<?> getDisposed() {
        Condition<Object> condition = o -> this.isDisposed();
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockProject", "getDisposed"));
        }
        return condition;
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public VirtualFile getProjectFile() {
        return null;
    }

    @Override
    @NotNull
    public String getName() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockProject", "getName"));
        }
        return "";
    }

    @Override
    @Nullable
    @NonNls
    public String getPresentableUrl() {
        return null;
    }

    @Override
    @NotNull
    @NonNls
    public String getLocationHash() {
        if ("mock" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockProject", "getLocationHash"));
        }
        return "mock";
    }

    @Override
    @Nullable
    public String getProjectFilePath() {
        return null;
    }

    @Override
    public VirtualFile getWorkspaceFile() {
        return null;
    }

    public void setBaseDir(VirtualFile baseDir) {
        this.myBaseDir = baseDir;
    }

    @Override
    @Nullable
    public VirtualFile getBaseDir() {
        return this.myBaseDir;
    }

    @Override
    @Nullable
    public String getBasePath() {
        return null;
    }

    @Override
    public void save() {
    }

    @Override
    @NotNull
    public <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "com/intellij/mock/MockProject", "getExtensions"));
        }
        T[] TArray = Extensions.getArea(this).getExtensionPoint(extensionPointName).getExtensions();
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockProject", "getExtensions"));
        }
        return TArray;
    }

    public void projectOpened() {
        ProjectComponent[] components;
        for (ProjectComponent component : components = this.getComponents(ProjectComponent.class)) {
            try {
                component.projectOpened();
            }
            catch (Throwable e) {
                LOG.error(component.toString(), e);
            }
        }
    }
}

