/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Condition;
import com.intellij.util.Consumer;
import com.intellij.util.containers.Convertor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectUtils {
    public static final Object NULL = new Object();

    private ObjectUtils() {
    }

    @NotNull
    public static <T> T assertNotNull(@Nullable T t) {
        T t2 = ObjectUtils.notNull(t);
        if (t2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ObjectUtils", "assertNotNull"));
        }
        return t2;
    }

    public static <T> void assertAllElementsNotNull(@NotNull T[] array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ObjectUtils", "assertAllElementsNotNull"));
        }
        for (int i2 = 0; i2 < array.length; ++i2) {
            T t = array[i2];
            if (t != null) continue;
            throw new NullPointerException("Element [" + i2 + "] is null");
        }
    }

    @Contract(value="null, null -> null")
    public static <T> T chooseNotNull(@Nullable T t1, @Nullable T t2) {
        return t1 == null ? t2 : t1;
    }

    @Contract(value="null,null->null")
    public static <T> T coalesce(@Nullable T t1, @Nullable T t2) {
        return t1 != null ? t1 : t2;
    }

    @Contract(value="null,null,null->null")
    public static <T> T coalesce(@Nullable T t1, @Nullable T t2, @Nullable T t3) {
        return t1 != null ? t1 : (t2 != null ? t2 : t3);
    }

    @Nullable
    public static <T> T coalesce(@Nullable Iterable<T> o) {
        if (o == null) {
            return null;
        }
        for (T t : o) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @NotNull
    public static <T> T notNull(@Nullable T value) {
        T t = ObjectUtils.notNull(value, value);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ObjectUtils", "notNull"));
        }
        return t;
    }

    @NotNull
    public static <T> T notNull(@Nullable T value, @NotNull T defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/intellij/util/ObjectUtils", "notNull"));
        }
        T t = value == null ? defaultValue : value;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ObjectUtils", "notNull"));
        }
        return t;
    }

    @Nullable
    public static <T> T tryCast(@Nullable Object obj, @NotNull Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/util/ObjectUtils", "tryCast"));
        }
        if (clazz.isInstance(obj)) {
            return clazz.cast(obj);
        }
        return null;
    }

    @Nullable
    public static <T, S> S doIfCast(@Nullable Object obj, @NotNull Class<T> clazz, Convertor<T, S> convertor) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/util/ObjectUtils", "doIfCast"));
        }
        if (clazz.isInstance(obj)) {
            return convertor.convert(obj);
        }
        return null;
    }

    public static <T> void consumeIfCast(@Nullable Object obj, @NotNull Class<T> clazz, Consumer<T> consumer) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/util/ObjectUtils", "consumeIfCast"));
        }
        if (clazz.isInstance(obj)) {
            consumer.consume(obj);
        }
    }

    @Nullable
    public static <T> T nullizeByCondition(@Nullable T obj, @NotNull Condition<T> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/ObjectUtils", "nullizeByCondition"));
        }
        if (condition.value(obj)) {
            return null;
        }
        return obj;
    }
}

