/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ModifiableModelCommitter {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.module.impl.ModifiableModelCommitter");

    public static void multiCommit(@NotNull ModifiableRootModel[] rootModels, @NotNull ModifiableModuleModel moduleModel) {
        if (rootModels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModels", "com/intellij/openapi/roots/impl/ModifiableModelCommitter", "multiCommit"));
        }
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/intellij/openapi/roots/impl/ModifiableModelCommitter", "multiCommit"));
        }
        ModifiableModelCommitter.multiCommit(Arrays.asList(rootModels), moduleModel);
    }

    public static void multiCommit(@NotNull Collection<ModifiableRootModel> rootModels, @NotNull ModifiableModuleModel moduleModel) {
        if (rootModels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModels", "com/intellij/openapi/roots/impl/ModifiableModelCommitter", "multiCommit"));
        }
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/intellij/openapi/roots/impl/ModifiableModelCommitter", "multiCommit"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        List<RootModelImpl> modelsToCommit = ModifiableModelCommitter.getSortedChangedModels(rootModels, moduleModel);
        SmartList<ModifiableRootModel> modelsToDispose = new SmartList<ModifiableRootModel>(rootModels);
        modelsToDispose.removeAll(modelsToCommit);
        ModuleManagerImpl.commitModelWithRunnable(moduleModel, () -> {
            for (ModifiableRootModel model : modelsToCommit) {
                ModuleRootManagerImpl.doCommit((RootModelImpl)model);
            }
            for (ModifiableRootModel model : modelsToDispose) {
                if (model instanceof RootModelImpl) {
                    ((RootModelImpl)model).checkModuleExtensionModification();
                }
                model.dispose();
            }
        });
    }

    @NotNull
    private static List<RootModelImpl> getSortedChangedModels(Collection<ModifiableRootModel> rootModels, ModifiableModuleModel moduleModel) {
        SmartList<RootModelImpl> result = null;
        for (ModifiableRootModel model : rootModels) {
            RootModelImpl rootModel = (RootModelImpl)model;
            if (!rootModel.isChanged()) continue;
            if (result == null) {
                result = new SmartList<RootModelImpl>();
            }
            result.add(rootModel);
        }
        if (result == null) {
            List<RootModelImpl> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModifiableModelCommitter", "getSortedChangedModels"));
            }
            return list;
        }
        if (result.size() > 1) {
            result.sort(ModifiableModelCommitter.createDFSTBuilder((List<RootModelImpl>)result, moduleModel).comparator());
        }
        SmartList<RootModelImpl> smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModifiableModelCommitter", "getSortedChangedModels"));
        }
        return smartList;
    }

    private static DFSTBuilder<RootModelImpl> createDFSTBuilder(List<RootModelImpl> rootModels, final ModifiableModuleModel moduleModel) {
        Module[] modules;
        final HashMap<String, RootModelImpl> nameToModel = ContainerUtil.newHashMap();
        for (RootModelImpl rootModelImpl : rootModels) {
            String name = rootModelImpl.getModule().getName();
            LOG.assertTrue(!nameToModel.containsKey(name), name);
            nameToModel.put(name, rootModelImpl);
        }
        for (Module module : modules = moduleModel.getModules()) {
            String name = module.getName();
            if (nameToModel.containsKey(name)) continue;
            RootModelImpl rootModel = ((ModuleRootManagerImpl)ModuleRootManager.getInstance(module)).getRootModel();
            nameToModel.put(name, rootModel);
        }
        final Collection collection = nameToModel.values();
        InboundSemiGraph<RootModelImpl> graph = new InboundSemiGraph<RootModelImpl>(){

            @Override
            public Collection<RootModelImpl> getNodes() {
                return collection;
            }

            @Override
            public Iterator<RootModelImpl> getIn(RootModelImpl rootModel) {
                OrderEnumerator entries = rootModel.orderEntries().withoutSdk().withoutLibraries().withoutModuleSourceEntries();
                List namesList = entries.process(new RootPolicy<List<String>>(){

                    @Override
                    public List<String> visitModuleOrderEntry(ModuleOrderEntry moduleOrderEntry, List<String> strings) {
                        Module module = moduleOrderEntry.getModule();
                        if (module != null && !module.isDisposed()) {
                            strings.add(module.getName());
                        } else {
                            Module moduleToBeRenamed = moduleModel.getModuleToBeRenamed(moduleOrderEntry.getModuleName());
                            if (moduleToBeRenamed != null && !moduleToBeRenamed.isDisposed()) {
                                strings.add(moduleToBeRenamed.getName());
                            }
                        }
                        return strings;
                    }
                }, new ArrayList());
                String[] names = ArrayUtil.toStringArray(namesList);
                ArrayList<RootModelImpl> result = new ArrayList<RootModelImpl>();
                for (String name : names) {
                    RootModelImpl depRootModel = (RootModelImpl)nameToModel.get(name);
                    if (depRootModel == null) continue;
                    result.add(depRootModel);
                }
                return result.iterator();
            }
        };
        return new DFSTBuilder<RootModelImpl>(GraphGenerator.generate(CachingSemiGraph.cache(graph)));
    }
}

