/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.compiler.CompilerDirectHierarchyInfo;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.java.FunExprOccurrence;
import com.intellij.psi.impl.java.JavaFunctionalExpressionIndex;
import com.intellij.psi.impl.java.stubs.FunctionalExpressionKey;
import com.intellij.psi.impl.java.stubs.index.JavaMethodParameterTypesIndex;
import com.intellij.psi.impl.search.ApproximateResolver;
import com.intellij.psi.impl.search.JavaSourceFilterScope;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFunctionalExpressionSearcher
extends QueryExecutorBase<PsiFunctionalExpression, FunctionalExpressionSearch.SearchParameters> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.search.JavaFunctionalExpressionSearcher");
    public static final int SMART_SEARCH_THRESHOLD = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processQuery(@NotNull FunctionalExpressionSearch.SearchParameters p, @NotNull Processor<PsiFunctionalExpression> consumer) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "processQuery"));
        }
        List<SamDescriptor> descriptors = JavaFunctionalExpressionSearcher.calcDescriptors(p);
        Project project = PsiUtilCore.getProjectInReadAction(p.getElementToSearch());
        if (project == null) {
            return;
        }
        SearchScope searchScope = ReadAction.compute(() -> {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "lambda$processQuery$0"));
            }
            return p.getEffectiveSearchScope();
        });
        if (searchScope instanceof GlobalSearchScope && !JavaFunctionalExpressionSearcher.performSearchUsingCompilerIndices(descriptors, (GlobalSearchScope)searchScope, project, consumer)) {
            return;
        }
        AtomicInteger exprCount = new AtomicInteger();
        AtomicInteger fileCount = new AtomicInteger();
        PsiManager manager = ReadAction.compute(() -> {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "lambda$processQuery$1"));
            }
            return p.getElementToSearch().getManager();
        });
        manager.startBatchFilesProcessingMode();
        try {
            JavaFunctionalExpressionSearcher.processOffsets(descriptors, project, (file, offsets) -> {
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "lambda$processQuery$2"));
                }
                fileCount.incrementAndGet();
                exprCount.addAndGet(offsets.size());
                return JavaFunctionalExpressionSearcher.processFile(consumer, descriptors, file, offsets);
            });
        }
        finally {
            manager.finishBatchFilesProcessingMode();
        }
        if (exprCount.get() > 0) {
            LOG.debug("Loaded " + exprCount.get() + " fun-expressions in " + fileCount.get() + " files");
        }
    }

    public static Set<VirtualFile> getFilesToSearchInPsi(PsiClass samClass) {
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        JavaFunctionalExpressionSearcher.processOffsets(JavaFunctionalExpressionSearcher.calcDescriptors(new FunctionalExpressionSearch.SearchParameters(samClass, samClass.getUseScope())), samClass.getProject(), (file, offsets) -> result.add((VirtualFile)file));
        return result;
    }

    @NotNull
    private static List<SamDescriptor> calcDescriptors(@NotNull FunctionalExpressionSearch.SearchParameters queryParameters) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "calcDescriptors"));
        }
        ArrayList<SamDescriptor> descriptors = new ArrayList<SamDescriptor>();
        ReadAction.run(() -> {
            if (queryParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "lambda$calcDescriptors$4"));
            }
            PsiClass aClass = queryParameters.getElementToSearch();
            if (!aClass.isValid() || !aClass.isInterface()) {
                return;
            }
            Project project = aClass.getProject();
            if (InjectedLanguageManager.getInstance(project).isInjectedFragment(aClass.getContainingFile()) || !JavaFunctionalExpressionSearcher.hasJava8Modules(project)) {
                return;
            }
            for (PsiClass samClass : JavaFunctionalExpressionSearcher.processSubInterfaces(aClass)) {
                PsiMethod saMethod;
                PsiType samType;
                if (!LambdaUtil.isFunctionalClass(samClass) || (samType = (saMethod = ObjectUtils.assertNotNull(LambdaUtil.getFunctionalInterfaceMethod(samClass))).getReturnType()) == null) continue;
                SearchScope scope = samClass.getUseScope().intersectWith(queryParameters.getEffectiveSearchScope());
                descriptors.add(new SamDescriptor(samClass, saMethod, samType, GlobalSearchScopeUtil.toGlobalSearchScope(scope, project)));
            }
        });
        ArrayList<SamDescriptor> arrayList = descriptors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "calcDescriptors"));
        }
        return arrayList;
    }

    @NotNull
    private static Set<VirtualFile> getLikelyFiles(List<SamDescriptor> descriptors, Collection<VirtualFile> candidateFiles, Project project) {
        GlobalSearchScope candidateFilesScope = GlobalSearchScope.filesScope(project, candidateFiles);
        Set<VirtualFile> set = JBIterable.from(descriptors).flatMap(descriptor -> ((SamDescriptor)descriptor).getMostLikelyFiles(candidateFilesScope)).toSet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "getLikelyFiles"));
        }
        return set;
    }

    @NotNull
    private static MultiMap<VirtualFile, FunExprOccurrence> getAllOccurrences(List<SamDescriptor> descriptors) {
        MultiMap<VirtualFile, FunExprOccurrence> result = MultiMap.createLinkedSet();
        for (SamDescriptor descriptor : descriptors) {
            ReadAction.run(() -> {
                for (FunctionalExpressionKey key : descriptor.generateKeys()) {
                    FileBasedIndex.getInstance().processValues(JavaFunctionalExpressionIndex.INDEX_ID, key, null, (file, infos) -> {
                        ProgressManager.checkCanceled();
                        result.putValues(file, (Collection<FunExprOccurrence>)infos);
                        return true;
                    }, new JavaSourceFilterScope(descriptor.effectiveUseScope));
                }
            });
        }
        LOG.debug("Found " + result.values().size() + " fun-expressions in " + result.keySet().size() + " files");
        MultiMap<VirtualFile, FunExprOccurrence> multiMap = result;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "getAllOccurrences"));
        }
        return multiMap;
    }

    private static void processOffsets(List<SamDescriptor> descriptors, Project project, PairProcessor<VirtualFile, List<Integer>> processor) {
        if (descriptors.isEmpty()) {
            return;
        }
        List<PsiClass> samClasses = ContainerUtil.map(descriptors, d -> d.samClass);
        MultiMap<VirtualFile, FunExprOccurrence> allCandidates = JavaFunctionalExpressionSearcher.getAllOccurrences(descriptors);
        if (allCandidates.isEmpty()) {
            return;
        }
        for (VirtualFile vFile : JavaFunctionalExpressionSearcher.putLikelyFilesFirst(descriptors, allCandidates.keySet(), project)) {
            List<FunExprOccurrence> toLoad = JavaFunctionalExpressionSearcher.filterInapplicable(samClasses, vFile, allCandidates.get(vFile), project);
            if (toLoad.isEmpty()) continue;
            LOG.trace("To load " + vFile.getPath() + " with values: " + toLoad);
            if (processor.process(vFile, ContainerUtil.map(toLoad, it -> it.funExprOffset))) continue;
            return;
        }
    }

    @NotNull
    private static Set<VirtualFile> putLikelyFilesFirst(List<SamDescriptor> descriptors, Set<VirtualFile> allFiles, Project project) {
        LinkedHashSet<VirtualFile> orderedFiles = new LinkedHashSet<VirtualFile>(allFiles.size());
        orderedFiles.addAll(JavaFunctionalExpressionSearcher.getLikelyFiles(descriptors, allFiles, project));
        orderedFiles.addAll(allFiles);
        LinkedHashSet<VirtualFile> linkedHashSet = orderedFiles;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "putLikelyFilesFirst"));
        }
        return linkedHashSet;
    }

    @NotNull
    private static List<FunExprOccurrence> filterInapplicable(List<PsiClass> samClasses, VirtualFile vFile, Collection<FunExprOccurrence> occurrences, Project project) {
        List list = DumbService.getInstance(project).runReadActionInSmartMode(() -> project.isDisposed() ? Collections.emptyList() : ContainerUtil.filter(occurrences, it -> it.canHaveType(samClasses, vFile)));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "filterInapplicable"));
        }
        return list;
    }

    private static boolean processFile(@NotNull Processor<PsiFunctionalExpression> consumer, List<SamDescriptor> descriptors, VirtualFile vFile, Collection<Integer> offsets) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "processFile"));
        }
        return ReadAction.compute(() -> {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "lambda$processFile$12"));
            }
            PsiFile file = ((SamDescriptor)descriptors.get((int)0)).samClass.getManager().findFile(vFile);
            if (!(file instanceof PsiJavaFile)) {
                LOG.error("Non-java file " + file + "; " + vFile);
                return true;
            }
            for (Integer offset : offsets) {
                PsiFunctionalExpression expression = PsiTreeUtil.findElementOfClassAtOffset(file, offset, PsiFunctionalExpression.class, false);
                if (expression == null || expression.getTextRange().getStartOffset() != offset.intValue()) {
                    LOG.error("Fun expression not found in " + file + " at " + offset);
                    continue;
                }
                if (!JavaFunctionalExpressionSearcher.hasType(descriptors, expression) || consumer.process(expression)) continue;
                return false;
            }
            return true;
        });
    }

    private static boolean hasType(List<SamDescriptor> descriptors, PsiFunctionalExpression expression) {
        if (!JavaFunctionalExpressionSearcher.canHaveType(expression, ContainerUtil.map(descriptors, d -> d.samClass))) {
            return false;
        }
        PsiClass actualClass = PsiUtil.resolveClassInType(expression.getFunctionalInterfaceType());
        return ContainerUtil.exists(descriptors, d -> InheritanceUtil.isInheritorOrSelf(actualClass, d.samClass, true));
    }

    private static boolean canHaveType(PsiFunctionalExpression expression, List<PsiClass> samClasses) {
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiExpressionList && parent.getParent() instanceof PsiMethodCallExpression) {
            PsiExpression[] args = ((PsiExpressionList)parent).getExpressions();
            int argIndex = Arrays.asList(args).indexOf(expression);
            PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)parent.getParent()).getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            String methodName = methodExpression.getReferenceName();
            if (qualifier != null && methodName != null && argIndex >= 0) {
                Set<PsiClass> approximateTypes = ApproximateResolver.getPossibleTypes(qualifier, 10);
                List<PsiMethod> methods = approximateTypes == null ? null : ApproximateResolver.getPossibleMethods(approximateTypes, methodName, args.length);
                return methods == null || ContainerUtil.exists(methods, m -> FunExprOccurrence.hasCompatibleParameter(m, argIndex, samClasses));
            }
        }
        return true;
    }

    private static boolean hasJava8Modules(Project project) {
        boolean projectLevelIsHigh = PsiUtil.getLanguageLevel(project).isAtLeast(LanguageLevel.JDK_1_8);
        for (Module module : ModuleManager.getInstance(project).getModules()) {
            LanguageLevel level;
            LanguageLevelModuleExtension extension = ModuleRootManager.getInstance(module).getModuleExtension(LanguageLevelModuleExtension.class);
            if (extension == null || ((level = extension.getLanguageLevel()) != null || !projectLevelIsHigh) && (level == null || !level.isAtLeast(LanguageLevel.JDK_1_8))) continue;
            return true;
        }
        return false;
    }

    private static Set<PsiClass> processSubInterfaces(PsiClass base) {
        final HashSet<PsiClass> result = new HashSet<PsiClass>();
        new Object(){

            void visit(PsiClass c) {
                if (!result.add(c)) {
                    return;
                }
                DirectClassInheritorsSearch.search(c).forEach(candidate -> {
                    if (candidate.isInterface()) {
                        this.visit((PsiClass)candidate);
                    }
                    return true;
                });
            }
        }.visit(base);
        return result;
    }

    private static boolean performSearchUsingCompilerIndices(@NotNull List<SamDescriptor> descriptors, @NotNull GlobalSearchScope searchScope, @NotNull Project project, @NotNull Processor<PsiFunctionalExpression> consumer) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "performSearchUsingCompilerIndices"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "performSearchUsingCompilerIndices"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "performSearchUsingCompilerIndices"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "performSearchUsingCompilerIndices"));
        }
        CompilerReferenceService compilerReferenceService = CompilerReferenceService.getInstance(project);
        for (SamDescriptor descriptor : descriptors) {
            if (JavaFunctionalExpressionSearcher.processFunctionalExpressions(JavaFunctionalExpressionSearcher.performSearchUsingCompilerIndices(descriptor, searchScope, compilerReferenceService), descriptor, consumer)) continue;
            return false;
        }
        return true;
    }

    private static CompilerDirectHierarchyInfo performSearchUsingCompilerIndices(@NotNull SamDescriptor descriptor, @NotNull GlobalSearchScope searchScope, @NotNull CompilerReferenceService service) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "performSearchUsingCompilerIndices"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "performSearchUsingCompilerIndices"));
        }
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "performSearchUsingCompilerIndices"));
        }
        return service.getFunExpressions(descriptor.samClass, descriptor.effectiveUseScope, searchScope, JavaFileType.INSTANCE);
    }

    private static boolean processFunctionalExpressions(@Nullable CompilerDirectHierarchyInfo funExprInfo, @NotNull SamDescriptor descriptor, @NotNull Processor<PsiFunctionalExpression> consumer) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "processFunctionalExpressions"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "processFunctionalExpressions"));
        }
        if (funExprInfo != null) {
            if (!ContainerUtil.process(funExprInfo.getHierarchyChildren().iterator(), fe -> {
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "lambda$processFunctionalExpressions$16"));
                }
                return consumer.process((PsiFunctionalExpression)fe);
            })) {
                return false;
            }
            GlobalSearchScope dirtyScope = funExprInfo.getDirtyScope();
            descriptor.effectiveUseScope = descriptor.effectiveUseScope.intersectWith(dirtyScope);
        }
        return true;
    }

    private static class SamDescriptor {
        final PsiClass samClass;
        final int samParamCount;
        final boolean booleanCompatible;
        final boolean isVoid;
        GlobalSearchScope effectiveUseScope;

        SamDescriptor(PsiClass samClass, PsiMethod samMethod, PsiType samType, GlobalSearchScope useScope) {
            this.samClass = samClass;
            this.effectiveUseScope = useScope;
            this.samParamCount = samMethod.getParameterList().getParametersCount();
            this.booleanCompatible = FunctionalExpressionKey.isBooleanCompatible(samType);
            this.isVoid = PsiType.VOID.equals(samType);
        }

        List<FunctionalExpressionKey> generateKeys() {
            ArrayList<FunctionalExpressionKey> result = new ArrayList<FunctionalExpressionKey>();
            for (String lambdaType : new String[]{ObjectUtils.assertNotNull(this.samClass.getName()), ""}) {
                for (int lambdaParamCount : new int[]{-1, this.samParamCount}) {
                    result.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.UNKNOWN, lambdaType));
                    if (this.isVoid) {
                        result.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.VOID, lambdaType));
                        continue;
                    }
                    if (this.booleanCompatible) {
                        result.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.BOOLEAN, lambdaType));
                    }
                    result.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.NON_VOID, lambdaType));
                }
            }
            return result;
        }

        @NotNull
        private Set<VirtualFile> getMostLikelyFiles(GlobalSearchScope searchScope) {
            LinkedHashSet<VirtualFile> files = ContainerUtil.newLinkedHashSet();
            ReadAction.run(() -> {
                if (!this.samClass.isValid()) {
                    return;
                }
                String className = this.samClass.getName();
                Project project = this.samClass.getProject();
                if (className == null) {
                    return;
                }
                LinkedHashSet<String> likelyNames = ContainerUtil.newLinkedHashSet(className);
                StubIndex.getInstance().processElements(JavaMethodParameterTypesIndex.getInstance().getKey(), className, project, this.effectiveUseScope, PsiMethod.class, method -> {
                    ProgressManager.checkCanceled();
                    likelyNames.add(method.getName());
                    return true;
                });
                PsiSearchHelperImpl helper = (PsiSearchHelperImpl)PsiSearchHelper.SERVICE.getInstance(project);
                Processor<VirtualFile> processor = Processors.cancelableCollectProcessor(files);
                for (String word : likelyNames) {
                    helper.processFilesWithText(searchScope, (short)1, true, word, processor);
                }
            });
            LinkedHashSet<VirtualFile> linkedHashSet = files;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher$SamDescriptor", "getMostLikelyFiles"));
            }
            return linkedHashSet;
        }
    }
}

