/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class AbstractMethodOverridesAbstractMethodInspection
extends BaseInspection {
    public boolean ignoreJavaDoc = false;
    public boolean ignoreAnnotations = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("abstract.method.overrides.abstract.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/AbstractMethodOverridesAbstractMethodInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new AbstractMethodOverridesAbstractMethodFix();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("abstract.method.overrides.abstract.method.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/AbstractMethodOverridesAbstractMethodInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel(this);
        panel.addCheckbox(InspectionGadgetsBundle.message("abstract.method.overrides.abstract.method.ignore.different.javadoc.option", new Object[0]), "ignoreJavaDoc");
        panel.addCheckbox(InspectionGadgetsBundle.message("abstract.method.overrides.abstract.method.ignore.different.annotations.option", new Object[0]), "ignoreAnnotations");
        return panel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AbstractMethodOverridesAbstractMethodVisitor();
    }

    private class AbstractMethodOverridesAbstractMethodVisitor
    extends BaseInspectionVisitor {
        private AbstractMethodOverridesAbstractMethodVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            PsiMethod[] superMethods;
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/inheritance/AbstractMethodOverridesAbstractMethodInspection$AbstractMethodOverridesAbstractMethodVisitor", "visitMethod"));
            }
            if (method.isConstructor()) {
                return;
            }
            if (!this.isAbstract(method)) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (!method.hasModifierProperty("abstract") && !containingClass.isInterface()) {
                return;
            }
            boolean overrideDefault = false;
            boolean accept = false;
            for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
                overrideDefault |= superMethod.hasModifierProperty("default");
                if (!this.isAbstract(superMethod)) continue;
                if (overrideDefault) {
                    return;
                }
                accept |= this.methodsHaveSameReturnTypes(method, superMethod) && this.haveSameExceptionSignatures(method, superMethod);
                if (AbstractMethodOverridesAbstractMethodInspection.this.ignoreJavaDoc && !this.haveSameJavaDoc(method, superMethod)) {
                    return;
                }
                if (!AbstractMethodOverridesAbstractMethodInspection.this.ignoreAnnotations || this.methodsHaveSameAnnotations(method, superMethod)) continue;
                return;
            }
            if (accept && !overrideDefault) {
                this.registerMethodError(method, new Object[0]);
            }
        }

        private boolean methodsHaveSameAnnotations(PsiMethod method, PsiMethod superMethod) {
            if (!this.haveSameAnnotations(method, superMethod)) {
                return false;
            }
            PsiParameterList superParameterList = superMethod.getParameterList();
            PsiParameter[] superParameters = superParameterList.getParameters();
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            if (parameters.length != superParameters.length) {
                return false;
            }
            int length = superParameters.length;
            for (int i2 = 0; i2 < length; ++i2) {
                PsiParameter parameter = parameters[i2];
                PsiParameter superParameter = superParameters[i2];
                if (this.haveSameAnnotations(parameter, superParameter)) continue;
                return false;
            }
            return true;
        }

        private boolean haveSameAnnotations(PsiModifierListOwner owner1, PsiModifierListOwner owner2) {
            PsiModifierList modifierList = owner1.getModifierList();
            PsiModifierList superModifierList = owner2.getModifierList();
            if (superModifierList == null) {
                return modifierList == null;
            }
            if (modifierList == null) {
                return false;
            }
            PsiAnnotation[] superAnnotations = superModifierList.getAnnotations();
            PsiAnnotation[] annotations = modifierList.getAnnotations();
            HashSet<PsiAnnotation> annotationsSet = new HashSet<PsiAnnotation>(Arrays.asList(superAnnotations));
            for (PsiAnnotation annotation : annotations) {
                String qualifiedName = annotation.getQualifiedName();
                if ("java.lang.Override".equals(qualifiedName) || annotationsSet.contains(annotation)) continue;
                return false;
            }
            return true;
        }

        private boolean haveSameJavaDoc(PsiMethod method, PsiMethod superMethod) {
            PsiDocComment superDocComment = superMethod.getDocComment();
            PsiDocComment docComment = method.getDocComment();
            return !(superDocComment == null ? docComment != null : docComment != null && !superDocComment.getText().equals(docComment.getText()));
        }

        private boolean haveSameExceptionSignatures(PsiMethod method1, PsiMethod method2) {
            PsiReferenceList list2;
            PsiClassType[] exceptions2;
            PsiReferenceList list1 = method1.getThrowsList();
            PsiClassType[] exceptions1 = list1.getReferencedTypes();
            if (exceptions1.length != (exceptions2 = (list2 = method2.getThrowsList()).getReferencedTypes()).length) {
                return false;
            }
            HashSet<PsiClassType> set1 = new HashSet<PsiClassType>(Arrays.asList(exceptions1));
            for (PsiClassType anException : exceptions2) {
                if (set1.contains(anException)) continue;
                return false;
            }
            return true;
        }

        private boolean methodsHaveSameReturnTypes(PsiMethod method1, PsiMethod method2) {
            PsiType type1 = method1.getReturnType();
            if (type1 == null) {
                return false;
            }
            PsiClass superClass = method2.getContainingClass();
            PsiClass aClass = method1.getContainingClass();
            if (aClass == null || superClass == null) {
                return false;
            }
            PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor(superClass, aClass, PsiSubstitutor.EMPTY);
            PsiType type2 = method2.getReturnType();
            return Comparing.equal(type1, substitutor.substitute(type2));
        }

        private boolean isAbstract(PsiMethod method) {
            if (method.hasModifierProperty("abstract")) {
                return true;
            }
            PsiClass containingClass = method.getContainingClass();
            return containingClass != null && containingClass.isInterface() && !method.hasModifierProperty("default");
        }
    }

    private static class AbstractMethodOverridesAbstractMethodFix
    extends InspectionGadgetsFix {
        private AbstractMethodOverridesAbstractMethodFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("abstract.method.overrides.abstract.method.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/AbstractMethodOverridesAbstractMethodInspection$AbstractMethodOverridesAbstractMethodFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodNameIdentifier = descriptor.getPsiElement();
            PsiElement method = methodNameIdentifier.getParent();
            assert (method != null);
            AbstractMethodOverridesAbstractMethodFix.deleteElement(method);
        }
    }
}

