/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HardcodedContracts {
    public static List<MethodContract> getHardcodedContracts(@NotNull PsiMethod method, @Nullable PsiMethodCallExpression call) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/HardcodedContracts", "getHardcodedContracts"));
        }
        PsiClass owner = method.getContainingClass();
        if (owner == null || InjectedLanguageManager.getInstance(owner.getProject()).isInjectedFragment(owner.getContainingFile())) {
            return Collections.emptyList();
        }
        int paramCount = method.getParameterList().getParametersCount();
        String className = owner.getQualifiedName();
        if (className == null) {
            return Collections.emptyList();
        }
        String methodName = method.getName();
        if ("java.lang.System".equals(className)) {
            if ("exit".equals(methodName)) {
                return Collections.singletonList(new MethodContract(MethodContract.createConstraintArray(paramCount), MethodContract.ValueConstraint.THROW_EXCEPTION));
            }
        } else if ("com.google.common.base.Preconditions".equals(className)) {
            if ("checkNotNull".equals(methodName) && paramCount > 0) {
                return HardcodedContracts.failIfNull(0, paramCount);
            }
            if (("checkArgument".equals(methodName) || "checkState".equals(methodName)) && paramCount > 0) {
                MethodContract.ValueConstraint[] constraints = MethodContract.createConstraintArray(paramCount);
                constraints[0] = MethodContract.ValueConstraint.FALSE_VALUE;
                return Collections.singletonList(new MethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
            }
        } else if ("java.util.Objects".equals(className)) {
            if ("requireNonNull".equals(methodName) && paramCount > 0) {
                return HardcodedContracts.failIfNull(0, paramCount);
            }
        } else if ("org.apache.commons.lang.Validate".equals(className) || "org.apache.commons.lang3.Validate".equals(className) || "org.springframework.util.Assert".equals(className)) {
            if (("isTrue".equals(methodName) || "state".equals(methodName)) && paramCount > 0) {
                MethodContract.ValueConstraint[] constraints = MethodContract.createConstraintArray(paramCount);
                constraints[0] = MethodContract.ValueConstraint.FALSE_VALUE;
                return Collections.singletonList(new MethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
            }
            if ("notNull".equals(methodName) && paramCount > 0) {
                MethodContract.ValueConstraint[] constraints = MethodContract.createConstraintArray(paramCount);
                constraints[0] = MethodContract.ValueConstraint.NULL_VALUE;
                return Collections.singletonList(new MethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
            }
        } else {
            if (HardcodedContracts.isJunit(className) || HardcodedContracts.isTestng(className) || className.startsWith("com.google.common.truth.") || className.startsWith("org.assertj.core.api.")) {
                return HardcodedContracts.handleTestFrameworks(paramCount, className, methodName, call);
            }
            if (TypeUtils.isOptional(owner) && (methodName.startsWith("get") || methodName.equals("isPresent")) && paramCount == 0) {
                return Collections.singletonList(new MethodContract(new MethodContract.ValueConstraint[0], MethodContract.ValueConstraint.NOT_NULL_VALUE));
            }
        }
        return Collections.emptyList();
    }

    private static boolean isJunit(String className) {
        return className.startsWith("junit.framework.") || className.startsWith("org.junit.");
    }

    private static boolean isTestng(String className) {
        return className.startsWith("org.testng.");
    }

    private static boolean isNotNullMatcher(PsiExpression expr) {
        if (expr instanceof PsiMethodCallExpression) {
            PsiExpression[] equalArgs;
            PsiExpression[] notArgs;
            String calledName = ((PsiMethodCallExpression)expr).getMethodExpression().getReferenceName();
            if ("notNullValue".equals(calledName)) {
                return true;
            }
            if ("not".equals(calledName) && (notArgs = ((PsiMethodCallExpression)expr).getArgumentList().getExpressions()).length == 1 && notArgs[0] instanceof PsiMethodCallExpression && "equalTo".equals(((PsiMethodCallExpression)notArgs[0]).getMethodExpression().getReferenceName()) && (equalArgs = ((PsiMethodCallExpression)notArgs[0]).getArgumentList().getExpressions()).length == 1 && ExpressionUtils.isNullLiteral(equalArgs[0])) {
                return true;
            }
        }
        return false;
    }

    private static List<MethodContract> handleTestFrameworks(int paramCount, String className, String methodName, @Nullable PsiMethodCallExpression call) {
        if (("assertThat".equals(methodName) || "assumeThat".equals(methodName) || "that".equals(methodName)) && call != null) {
            return HardcodedContracts.handleAssertThat(paramCount, call);
        }
        if (!HardcodedContracts.isJunit(className) && !HardcodedContracts.isTestng(className)) {
            return Collections.emptyList();
        }
        boolean testng = HardcodedContracts.isTestng(className);
        if ("fail".equals(methodName)) {
            return Collections.singletonList(new MethodContract(MethodContract.createConstraintArray(paramCount), MethodContract.ValueConstraint.THROW_EXCEPTION));
        }
        if (paramCount == 0) {
            return Collections.emptyList();
        }
        int checkedParam = testng ? 0 : paramCount - 1;
        MethodContract.ValueConstraint[] constraints = MethodContract.createConstraintArray(paramCount);
        if ("assertTrue".equals(methodName) || "assumeTrue".equals(methodName)) {
            constraints[checkedParam] = MethodContract.ValueConstraint.FALSE_VALUE;
            return Collections.singletonList(new MethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
        }
        if ("assertFalse".equals(methodName) || "assumeFalse".equals(methodName)) {
            constraints[checkedParam] = MethodContract.ValueConstraint.TRUE_VALUE;
            return Collections.singletonList(new MethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
        }
        if ("assertNull".equals(methodName)) {
            constraints[checkedParam] = MethodContract.ValueConstraint.NOT_NULL_VALUE;
            return Collections.singletonList(new MethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
        }
        if ("assertNotNull".equals(methodName) || "assumeNotNull".equals(methodName)) {
            return HardcodedContracts.failIfNull(checkedParam, paramCount);
        }
        return Collections.emptyList();
    }

    @NotNull
    private static List<MethodContract> handleAssertThat(int paramCount, @NotNull PsiMethodCallExpression call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/HardcodedContracts", "handleAssertThat"));
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length == paramCount) {
            for (int i2 = 1; i2 < args.length; ++i2) {
                if (!HardcodedContracts.isNotNullMatcher(args[i2])) continue;
                List<MethodContract> list = HardcodedContracts.failIfNull(i2 - 1, paramCount);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/HardcodedContracts", "handleAssertThat"));
                }
                return list;
            }
            if (args.length == 1 && HardcodedContracts.hasNotNullChainCall(call)) {
                List<MethodContract> list = HardcodedContracts.failIfNull(0, 1);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/HardcodedContracts", "handleAssertThat"));
                }
                return list;
            }
        }
        List<MethodContract> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/HardcodedContracts", "handleAssertThat"));
        }
        return list;
    }

    private static boolean hasNotNullChainCall(PsiMethodCallExpression call) {
        JBIterable<PsiElement> exprParents = SyntaxTraverser.psiApi().parents(call).takeWhile(e -> !(e instanceof PsiStatement) && !(e instanceof PsiMember));
        return ContainerUtil.exists(exprParents, HardcodedContracts::isNotNullCall);
    }

    private static boolean isNotNullCall(PsiElement ref) {
        return ref instanceof PsiReferenceExpression && "isNotNull".equals(((PsiReferenceExpression)ref).getReferenceName()) && ref.getParent() instanceof PsiMethodCallExpression;
    }

    @NotNull
    private static List<MethodContract> failIfNull(int argIndex, int argCount) {
        MethodContract.ValueConstraint[] constraints = MethodContract.createConstraintArray(argCount);
        constraints[argIndex] = MethodContract.ValueConstraint.NULL_VALUE;
        List<MethodContract> list = Collections.singletonList(new MethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/HardcodedContracts", "failIfNull"));
        }
        return list;
    }

    public static boolean isHardcodedPure(PsiMethod method) {
        PsiParameter[] parameters;
        String qName = PsiUtil.getMemberQualifiedName(method);
        if ("java.lang.System.exit".equals(qName)) {
            return false;
        }
        return !"java.util.Objects.requireNonNull".equals(qName) || (parameters = method.getParameterList().getParameters()).length != 2 || !parameters[1].getType().getCanonicalText().contains("Supplier");
    }

    public static boolean hasHardcodedContracts(@Nullable PsiElement element) {
        if (element instanceof PsiMethod) {
            return !HardcodedContracts.getHardcodedContracts((PsiMethod)element, null).isEmpty();
        }
        if (element instanceof PsiParameter) {
            PsiElement parent = element.getParent();
            return parent != null && HardcodedContracts.hasHardcodedContracts(parent.getParent());
        }
        return false;
    }
}

