/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.TransferTarget;
import com.intellij.codeInspection.dataFlow.Trap;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaOptionalValue;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.containers.FactoryMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaValueFactory {
    private final List<DfaValue> myValues = ContainerUtil.newArrayList();
    private final Map<Pair<DfaPsiType, DfaPsiType>, Boolean> myAssignableCache = ContainerUtil.newHashMap();
    private final Map<Pair<DfaPsiType, DfaPsiType>, Boolean> myConvertibleCache = ContainerUtil.newHashMap();
    private final Map<PsiType, DfaPsiType> myDfaTypes = ContainerUtil.newHashMap();
    private final boolean myHonorFieldInitializers;
    private final boolean myUnknownMembersAreNullable;
    private final Map<Pair<TransferTarget, FList<Trap>>, DfaControlTransferValue> myControlTransfers = FactoryMap.createMap(p -> new DfaControlTransferValue(this, (TransferTarget)p.first, (FList)p.second));
    private final DfaVariableValue.Factory myVarFactory;
    private final DfaConstValue.Factory myConstFactory;
    private final DfaBoxedValue.Factory myBoxedFactory;
    private final DfaTypeValue.Factory myTypeFactory;
    private final DfaRelationValue.Factory myRelationFactory;
    private final DfaExpressionFactory myExpressionFactory;
    private final DfaOptionalValue.Factory myOptionalFactory;

    public DfaValueFactory(boolean honorFieldInitializers, boolean unknownMembersAreNullable) {
        this.myHonorFieldInitializers = honorFieldInitializers;
        this.myUnknownMembersAreNullable = unknownMembersAreNullable;
        this.myValues.add(null);
        this.myVarFactory = new DfaVariableValue.Factory(this);
        this.myConstFactory = new DfaConstValue.Factory(this);
        this.myBoxedFactory = new DfaBoxedValue.Factory(this);
        this.myTypeFactory = new DfaTypeValue.Factory(this);
        this.myRelationFactory = new DfaRelationValue.Factory(this);
        this.myExpressionFactory = new DfaExpressionFactory(this);
        this.myOptionalFactory = new DfaOptionalValue.Factory(this);
    }

    public boolean isHonorFieldInitializers() {
        return this.myHonorFieldInitializers;
    }

    public boolean isUnknownMembersAreNullable() {
        return this.myUnknownMembersAreNullable;
    }

    @NotNull
    public DfaValue createTypeValue(@Nullable PsiType type, @NotNull Nullness nullability) {
        if (nullability == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullability", "com/intellij/codeInspection/dataFlow/value/DfaValueFactory", "createTypeValue"));
        }
        if ((type = TypeConversionUtil.erasure(type)) == null) {
            DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
            if (dfaUnknownValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaValueFactory", "createTypeValue"));
            }
            return dfaUnknownValue;
        }
        DfaTypeValue dfaTypeValue = this.getTypeFactory().createTypeValue(this.internType(type), nullability);
        if (dfaTypeValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaValueFactory", "createTypeValue"));
        }
        return dfaTypeValue;
    }

    private DfaPsiType internType(@NotNull PsiType psiType) {
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "com/intellij/codeInspection/dataFlow/value/DfaValueFactory", "internType"));
        }
        DfaPsiType dfaType = this.myDfaTypes.get(psiType);
        if (dfaType == null) {
            dfaType = new DfaPsiType(psiType, this.myAssignableCache, this.myConvertibleCache);
            this.myDfaTypes.put(psiType, dfaType);
        }
        return dfaType;
    }

    int registerValue(DfaValue value) {
        this.myValues.add(value);
        return this.myValues.size() - 1;
    }

    public DfaValue getValue(int id) {
        return this.myValues.get(id);
    }

    @Nullable
    public DfaValue createValue(PsiExpression psiExpression) {
        return this.myExpressionFactory.getExpressionDfaValue(psiExpression);
    }

    @Nullable
    public DfaValue createLiteralValue(PsiLiteralExpression literal) {
        if (literal.getValue() instanceof String) {
            return this.createTypeValue(literal.getType(), Nullness.NOT_NULL);
        }
        return this.getConstFactory().create(literal);
    }

    public static boolean isEffectivelyUnqualified(PsiReferenceExpression refExpression) {
        PsiExpression qualifier = refExpression.getQualifierExpression();
        if (qualifier == null) {
            return true;
        }
        if (qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) {
            PsiJavaCodeReferenceElement thisQualifier = ((PsiQualifiedExpression)qualifier).getQualifier();
            if (thisQualifier == null) {
                return true;
            }
            PsiClass innerMostClass = PsiTreeUtil.getParentOfType((PsiElement)refExpression, PsiClass.class);
            if (innerMostClass == thisQualifier.resolve()) {
                return true;
            }
        }
        return false;
    }

    public DfaControlTransferValue controlTransfer(TransferTarget kind, FList<Trap> traps) {
        return this.myControlTransfers.get(Pair.create(kind, traps));
    }

    @NotNull
    public DfaVariableValue.Factory getVarFactory() {
        DfaVariableValue.Factory factory = this.myVarFactory;
        if (factory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaValueFactory", "getVarFactory"));
        }
        return factory;
    }

    @NotNull
    public DfaConstValue.Factory getConstFactory() {
        DfaConstValue.Factory factory = this.myConstFactory;
        if (factory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaValueFactory", "getConstFactory"));
        }
        return factory;
    }

    @NotNull
    public DfaBoxedValue.Factory getBoxedFactory() {
        DfaBoxedValue.Factory factory = this.myBoxedFactory;
        if (factory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaValueFactory", "getBoxedFactory"));
        }
        return factory;
    }

    @NotNull
    public DfaTypeValue.Factory getTypeFactory() {
        DfaTypeValue.Factory factory = this.myTypeFactory;
        if (factory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaValueFactory", "getTypeFactory"));
        }
        return factory;
    }

    @NotNull
    public DfaRelationValue.Factory getRelationFactory() {
        DfaRelationValue.Factory factory = this.myRelationFactory;
        if (factory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaValueFactory", "getRelationFactory"));
        }
        return factory;
    }

    @NotNull
    public DfaOptionalValue.Factory getOptionalFactory() {
        DfaOptionalValue.Factory factory = this.myOptionalFactory;
        if (factory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaValueFactory", "getOptionalFactory"));
        }
        return factory;
    }
}

