/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.SchemeState;
import java.awt.Color;
import java.awt.Font;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultColorsScheme
extends AbstractColorsScheme
implements ReadOnlyColorsScheme {
    private String myName;

    public DefaultColorsScheme() {
        super(null);
    }

    @Override
    @Nullable
    public TextAttributes getAttributes(TextAttributesKey key) {
        return key == null ? null : this.getAttributes(key, true);
    }

    @Nullable
    public TextAttributes getAttributes(@NotNull TextAttributesKey key, boolean isUseDefault) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/impl/DefaultColorsScheme", "getAttributes"));
        }
        TextAttributes attrs = (TextAttributes)this.myAttributesMap.get(key);
        if (attrs == null) {
            if (key.getFallbackAttributeKey() != null && (attrs = this.getFallbackAttributes(key.getFallbackAttributeKey())) != null && attrs != TextAttributes.USE_INHERITED_MARKER) {
                return attrs;
            }
            if (isUseDefault) {
                attrs = this.getKeyDefaults(key);
            }
        }
        return attrs;
    }

    @Nullable
    protected TextAttributes getKeyDefaults(@NotNull TextAttributesKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/impl/DefaultColorsScheme", "getKeyDefaults"));
        }
        return key.getDefaultAttributes();
    }

    @Override
    @Nullable
    public Color getColor(ColorKey key) {
        if (key == null) {
            return null;
        }
        Color color = (Color)this.myColorsMap.get(key);
        return color != null ? color : key.getDefaultColor();
    }

    @Override
    public void readExternal(@NotNull Element parentNode) {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/openapi/editor/colors/impl/DefaultColorsScheme", "readExternal"));
        }
        super.readExternal(parentNode);
        this.myName = parentNode.getAttributeValue("name");
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/DefaultColorsScheme", "getName"));
        }
        return string;
    }

    @Override
    public void setAttributes(@NotNull TextAttributesKey key, TextAttributes attributes) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/impl/DefaultColorsScheme", "setAttributes"));
        }
    }

    @Override
    public void setColor(ColorKey key, Color color) {
    }

    @Override
    public void setFont(EditorFontType key, Font font) {
    }

    @Override
    public Object clone() {
        EditorColorsSchemeImpl newScheme = new EditorColorsSchemeImpl(this);
        this.copyTo(newScheme);
        newScheme.setName("Default");
        newScheme.setDefaultMetaInfo(this);
        return newScheme;
    }

    public boolean hasEditableCopy() {
        return true;
    }

    public String getEditableCopyName() {
        return "_@user_" + this.myName;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    @NotNull
    public SchemeState getSchemeState() {
        SchemeState schemeState = SchemeState.NON_PERSISTENT;
        if (schemeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/DefaultColorsScheme", "getSchemeState"));
        }
        return schemeState;
    }
}

