/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection;

import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface InspectionProfileManager {
    public static final String INSPECTION_DIR = "inspection";

    @NotNull
    public Collection<InspectionProfileImpl> getProfiles();

    default public NamedScopesHolder getScopesManager() {
        return null;
    }

    @NotNull
    public static InspectionProfileManager getInstance() {
        InspectionProfileManager inspectionProfileManager = ServiceManager.getService(InspectionProfileManager.class);
        if (inspectionProfileManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManager", "getInstance"));
        }
        return inspectionProfileManager;
    }

    @NotNull
    public static InspectionProfileManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/profile/codeInspection/InspectionProfileManager", "getInstance"));
        }
        InspectionProjectProfileManager inspectionProjectProfileManager = InspectionProjectProfileManager.getInstance(project);
        if (inspectionProjectProfileManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManager", "getInstance"));
        }
        return inspectionProjectProfileManager;
    }

    public void setRootProfile(@Nullable String var1);

    @Deprecated
    @NotNull
    default public InspectionProfile getRootProfile() {
        InspectionProfileImpl inspectionProfileImpl = this.getCurrentProfile();
        if (inspectionProfileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManager", "getRootProfile"));
        }
        return inspectionProfileImpl;
    }

    @NotNull
    public InspectionProfileImpl getCurrentProfile();

    public InspectionProfileImpl getProfile(@NotNull String var1, boolean var2);

    default public InspectionProfileImpl getProfile(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/profile/codeInspection/InspectionProfileManager", "getProfile"));
        }
        return this.getProfile(name, true);
    }

    @NotNull
    public SeverityRegistrar getSeverityRegistrar();

    @NotNull
    public SeverityRegistrar getOwnSeverityRegistrar();
}

