/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathMacroUtil {
    @NonNls
    public static final String PROJECT_DIR_MACRO_NAME = "PROJECT_DIR";
    @NonNls
    public static final String MODULE_DIR_MACRO_NAME = "MODULE_DIR";
    @NonNls
    public static final String DIRECTORY_STORE_NAME = ".idea";
    @NonNls
    public static final String APPLICATION_HOME_DIR = "APPLICATION_HOME_DIR";
    @NonNls
    public static final String APPLICATION_CONFIG_DIR = "APPLICATION_CONFIG_DIR";
    @NonNls
    public static final String APPLICATION_PLUGINS_DIR = "APPLICATION_PLUGINS_DIR";
    @NonNls
    public static final String USER_HOME_NAME = "USER_HOME";
    private static final Map<String, String> ourGlobalMacros = ContainerUtil.immutableMapBuilder().put("APPLICATION_HOME_DIR", FileUtilRt.toSystemIndependentName(PathManager.getHomePath())).put("APPLICATION_CONFIG_DIR", FileUtilRt.toSystemIndependentName(PathManager.getConfigPath())).put("APPLICATION_PLUGINS_DIR", FileUtilRt.toSystemIndependentName(PathManager.getPluginsPath())).put("USER_HOME", StringUtil.trimEnd(FileUtilRt.toSystemIndependentName(SystemProperties.getUserHome()), "/")).build();

    @Nullable
    public static String getModuleDir(@NotNull String moduleFilePath) {
        if (moduleFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleFilePath", "org/jetbrains/jps/model/serialization/PathMacroUtil", "getModuleDir"));
        }
        String moduleDir = PathUtilRt.getParentPath(moduleFilePath);
        if (StringUtil.isEmpty(moduleDir)) {
            return null;
        }
        String moduleDirParent = PathUtilRt.getParentPath(moduleDir);
        if (!StringUtil.isEmpty(moduleDirParent) && PathUtilRt.getFileName(moduleDir).equals(DIRECTORY_STORE_NAME)) {
            moduleDir = moduleDirParent;
        }
        if ((moduleDir = FileUtilRt.toSystemIndependentName(moduleDir)).endsWith(":/")) {
            moduleDir = moduleDir.substring(0, moduleDir.length() - 1);
        }
        return moduleDir;
    }

    @NotNull
    public static String getUserHomePath() {
        String string = ObjectUtils.assertNotNull(PathMacroUtil.getGlobalSystemMacroValue(USER_HOME_NAME));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/PathMacroUtil", "getUserHomePath"));
        }
        return string;
    }

    @NotNull
    public static Map<String, String> getGlobalSystemMacros() {
        Map<String, String> map = ourGlobalMacros;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/PathMacroUtil", "getGlobalSystemMacros"));
        }
        return map;
    }

    @Nullable
    public static String getGlobalSystemMacroValue(String name) {
        return ourGlobalMacros.get(name);
    }
}

