/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.util.Version;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum JavaSdkVersion {
    JDK_1_0(LanguageLevel.JDK_1_3, 0, new String[]{"1.0"}),
    JDK_1_1(LanguageLevel.JDK_1_3, 1, new String[]{"1.1"}),
    JDK_1_2(LanguageLevel.JDK_1_3, 2, new String[]{"1.2"}),
    JDK_1_3(LanguageLevel.JDK_1_3, 3, new String[]{"1.3"}),
    JDK_1_4(LanguageLevel.JDK_1_4, 4, new String[]{"1.4"}),
    JDK_1_5(LanguageLevel.JDK_1_5, 5, new String[]{"1.5", "5.0"}),
    JDK_1_6(LanguageLevel.JDK_1_6, 6, new String[]{"1.6", "6.0"}),
    JDK_1_7(LanguageLevel.JDK_1_7, 7, new String[]{"1.7", "7.0"}),
    JDK_1_8(LanguageLevel.JDK_1_8, 8, new String[]{"1.8", "8.0"}),
    JDK_1_9(LanguageLevel.JDK_1_9, 9, new String[]{"1.9", "9.0", "9-ea"}),
    JDK_10(LanguageLevel.JDK_1_9, 10, new String[]{"10.0", "10-ea"});

    private static final JavaSdkVersion MAX_JDK;
    private static final Pattern JAVA_VERSION;
    private final LanguageLevel myMaxLanguageLevel;
    private final int myRelease;
    private final String[] myVersionStrings;

    private JavaSdkVersion(@NotNull LanguageLevel maxLanguageLevel, int release, String[] description) {
        if (maxLanguageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maxLanguageLevel", "com/intellij/openapi/projectRoots/JavaSdkVersion", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/openapi/projectRoots/JavaSdkVersion", "<init>"));
        }
        this.myMaxLanguageLevel = maxLanguageLevel;
        this.myRelease = release;
        this.myVersionStrings = description;
    }

    @NotNull
    public LanguageLevel getMaxLanguageLevel() {
        LanguageLevel languageLevel = this.myMaxLanguageLevel;
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/JavaSdkVersion", "getMaxLanguageLevel"));
        }
        return languageLevel;
    }

    @NotNull
    public String getDescription() {
        String string = this.myVersionStrings[0];
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/JavaSdkVersion", "getDescription"));
        }
        return string;
    }

    public boolean isAtLeast(@NotNull JavaSdkVersion version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/openapi/projectRoots/JavaSdkVersion", "isAtLeast"));
        }
        return this.compareTo(version) >= 0;
    }

    public String toString() {
        return super.toString() + ", description: " + this.getDescription();
    }

    @NotNull
    public static JavaSdkVersion fromLanguageLevel(@NotNull LanguageLevel languageLevel) throws IllegalArgumentException {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/openapi/projectRoots/JavaSdkVersion", "fromLanguageLevel"));
        }
        if (languageLevel == LanguageLevel.JDK_1_3) {
            JavaSdkVersion javaSdkVersion = JDK_1_3;
            if (javaSdkVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/JavaSdkVersion", "fromLanguageLevel"));
            }
            return javaSdkVersion;
        }
        if (languageLevel == LanguageLevel.JDK_X) {
            JavaSdkVersion javaSdkVersion = MAX_JDK;
            if (javaSdkVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/JavaSdkVersion", "fromLanguageLevel"));
            }
            return javaSdkVersion;
        }
        for (JavaSdkVersion version : JavaSdkVersion.values()) {
            if (!version.getMaxLanguageLevel().isAtLeast(languageLevel)) continue;
            JavaSdkVersion javaSdkVersion = version;
            if (javaSdkVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/JavaSdkVersion", "fromLanguageLevel"));
            }
            return javaSdkVersion;
        }
        throw new IllegalArgumentException("Can't map " + (Object)((Object)languageLevel) + " to any of " + Arrays.toString((Object[])JavaSdkVersion.values()));
    }

    @Nullable
    public static JavaSdkVersion fromVersionString(@NotNull String versionString) {
        Version parsed;
        if (versionString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionString", "com/intellij/openapi/projectRoots/JavaSdkVersion", "fromVersionString"));
        }
        Matcher matcher = JAVA_VERSION.matcher(versionString.trim());
        if (matcher.matches()) {
            versionString = matcher.group(1);
        }
        if ((parsed = Version.parseVersion(versionString)) != null && parsed.major > 0) {
            int release = parsed.major == 1 ? parsed.minor : parsed.major;
            return ContainerUtil.find(JavaSdkVersion.values(), v -> v.myRelease == release);
        }
        for (JavaSdkVersion version : JavaSdkVersion.values()) {
            for (String pattern : version.myVersionStrings) {
                if (!versionString.contains(pattern)) continue;
                return version;
            }
        }
        return null;
    }

    static {
        MAX_JDK = JDK_1_9;
        JAVA_VERSION = Pattern.compile("java version \"(\\d.*)\"");
    }
}

