/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public class DefaultStateSerializer {
    private static final Logger LOG = Logger.getInstance(DefaultStateSerializer.class);

    private DefaultStateSerializer() {
    }

    @Nullable
    public static <T> T deserializeState(@Nullable Element stateElement, Class<T> stateClass, @Nullable T mergeInto) {
        if (stateElement == null) {
            return mergeInto;
        }
        if (stateClass == Element.class) {
            return (T)stateElement;
        }
        if (JDOMExternalizable.class.isAssignableFrom(stateClass)) {
            if (mergeInto != null) {
                String elementText = JDOMUtil.writeElement(stateElement, "\n");
                LOG.error("State is " + stateClass.getName() + ", merge into is " + mergeInto.toString() + ", state element text is " + elementText);
            }
            T t = ReflectionUtil.newInstance(stateClass);
            ((JDOMExternalizable)t).readExternal(stateElement);
            return t;
        }
        if (mergeInto == null) {
            return XmlSerializer.deserialize(stateElement, stateClass);
        }
        XmlSerializer.deserializeInto(mergeInto, stateElement);
        return mergeInto;
    }
}

