/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaClassSupers;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InheritanceImplUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.InheritanceImplUtil");

    public static boolean isInheritor(@NotNull PsiClass candidateClass, @NotNull PsiClass baseClass, boolean checkDeep) {
        if (candidateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateClass", "com/intellij/psi/impl/InheritanceImplUtil", "isInheritor"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/InheritanceImplUtil", "isInheritor"));
        }
        if (baseClass instanceof PsiAnonymousClass || baseClass.getManager().areElementsEquivalent(baseClass, candidateClass)) {
            return false;
        }
        if (!checkDeep) {
            return InheritanceImplUtil.isInheritor(candidateClass.getManager(), candidateClass, baseClass, false, null);
        }
        GlobalSearchScope scope = candidateClass.getResolveScope();
        return JavaClassSupers.getInstance().getSuperClassSubstitutor(baseClass, candidateClass, scope, PsiSubstitutor.EMPTY) != null;
    }

    static boolean hasObjectQualifiedName(@NotNull PsiClass candidateClass) {
        if (candidateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateClass", "com/intellij/psi/impl/InheritanceImplUtil", "hasObjectQualifiedName"));
        }
        if (!"Object".equals(candidateClass.getName())) {
            return false;
        }
        PsiElement parent = candidateClass.getParent();
        return parent instanceof PsiJavaFile && "java.lang".equals(((PsiJavaFile)parent).getPackageName());
    }

    private static boolean isInheritor(@NotNull PsiManager manager, @NotNull PsiClass candidateClass, @NotNull PsiClass baseClass, boolean checkDeep, @Nullable Set<PsiClass> checkedClasses) {
        PsiClass objectClass;
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/InheritanceImplUtil", "isInheritor"));
        }
        if (candidateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateClass", "com/intellij/psi/impl/InheritanceImplUtil", "isInheritor"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/InheritanceImplUtil", "isInheritor"));
        }
        if (candidateClass instanceof PsiAnonymousClass) {
            PsiClass baseCandidateClass = ((PsiAnonymousClass)candidateClass).getBaseClassType().resolve();
            if (baseCandidateClass != null) {
                if (!checkDeep) {
                    return manager.areElementsEquivalent(baseCandidateClass, baseClass);
                }
                return InheritanceUtil.isInheritorOrSelf(baseCandidateClass, baseClass, true);
            }
            return false;
        }
        if (checkDeep && LOG.isDebugEnabled()) {
            LOG.debug("Using uncached version for " + candidateClass.getQualifiedName() + " and " + baseClass);
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance(manager.getProject());
        if (InheritanceImplUtil.hasObjectQualifiedName(baseClass) && manager.areElementsEquivalent(baseClass, objectClass = facade.findClass("java.lang.Object", candidateClass.getResolveScope()))) {
            if (manager.areElementsEquivalent(candidateClass, objectClass)) {
                return false;
            }
            if (checkDeep || candidateClass.isInterface()) {
                return true;
            }
            return manager.areElementsEquivalent(candidateClass.getSuperClass(), objectClass);
        }
        if (!checkDeep) {
            if (candidateClass instanceof PsiCompiledElement) {
                boolean isBaseInterface;
                String baseQName = baseClass.getQualifiedName();
                if (baseQName == null) {
                    return false;
                }
                if ("java.lang.Enum".equals(baseQName) && candidateClass.isEnum()) {
                    return facade.findClass(baseQName, candidateClass.getResolveScope()) != null;
                }
                if ("java.lang.annotation.Annotation".equals(baseQName) && candidateClass.isAnnotationType()) {
                    return facade.findClass(baseQName, candidateClass.getResolveScope()) != null;
                }
                boolean isCandidateInterface = candidateClass.isInterface();
                if (isCandidateInterface == (isBaseInterface = baseClass.isInterface()) && InheritanceImplUtil.checkReferenceListWithQualifiedNamesInClsClass(baseQName, candidateClass.getExtendsList(), facade)) {
                    return true;
                }
                return isBaseInterface && !isCandidateInterface && InheritanceImplUtil.checkReferenceListWithQualifiedNamesInClsClass(baseQName, candidateClass.getImplementsList(), facade);
            }
            boolean isCandidateInterface = candidateClass.isInterface();
            boolean isBaseInterface = baseClass.isInterface();
            String baseName = baseClass.getName();
            if (isCandidateInterface == isBaseInterface) {
                return PsiClassImplUtil.isInExtendsList(candidateClass, baseClass, baseName, manager);
            }
            if (!isCandidateInterface) {
                return PsiClassImplUtil.isInReferenceList(candidateClass.getImplementsList(), baseClass, baseName, manager);
            }
            return false;
        }
        return InheritanceImplUtil.isInheritorWithoutCaching(manager, candidateClass, baseClass, checkedClasses);
    }

    private static boolean checkReferenceListWithQualifiedNamesInClsClass(@NotNull String baseQName, @Nullable PsiReferenceList extList, @NotNull JavaPsiFacade facade) {
        PsiJavaCodeReferenceElement[] referenceElements;
        if (baseQName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseQName", "com/intellij/psi/impl/InheritanceImplUtil", "checkReferenceListWithQualifiedNamesInClsClass"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/psi/impl/InheritanceImplUtil", "checkReferenceListWithQualifiedNamesInClsClass"));
        }
        if (extList != null && (referenceElements = extList.getReferenceElements()).length != 0) {
            GlobalSearchScope scope = extList.getResolveScope();
            for (PsiJavaCodeReferenceElement ref : referenceElements) {
                if (!Comparing.equal(PsiNameHelper.getQualifiedClassName(ref.getQualifiedName(), false), baseQName) || facade.findClass(baseQName, scope) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isInheritorWithoutCaching(@NotNull PsiManager manager, @NotNull PsiClass aClass, @NotNull PsiClass baseClass, @Nullable Set<PsiClass> checkedClasses) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/InheritanceImplUtil", "isInheritorWithoutCaching"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/InheritanceImplUtil", "isInheritorWithoutCaching"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/InheritanceImplUtil", "isInheritorWithoutCaching"));
        }
        if (manager.areElementsEquivalent(aClass, baseClass)) {
            return false;
        }
        if (aClass.isInterface() && !baseClass.isInterface()) {
            return false;
        }
        if (checkedClasses == null) {
            checkedClasses = new THashSet();
        }
        checkedClasses.add((PsiClass)aClass);
        return InheritanceImplUtil.checkInheritor(manager, aClass.getExtendsListTypes(), baseClass, (Set<PsiClass>)checkedClasses) || InheritanceImplUtil.checkInheritor(manager, aClass.getImplementsListTypes(), baseClass, (Set<PsiClass>)checkedClasses);
    }

    private static boolean checkInheritor(@NotNull PsiManager manager, @NotNull PsiClassType[] supers, @NotNull PsiClass baseClass, @NotNull Set<PsiClass> checkedClasses) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/InheritanceImplUtil", "checkInheritor"));
        }
        if (supers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supers", "com/intellij/psi/impl/InheritanceImplUtil", "checkInheritor"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/InheritanceImplUtil", "checkInheritor"));
        }
        if (checkedClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedClasses", "com/intellij/psi/impl/InheritanceImplUtil", "checkInheritor"));
        }
        for (PsiClassType aSuper : supers) {
            PsiClass aClass = aSuper.resolve();
            if (aClass == null || !InheritanceImplUtil.checkInheritor(manager, aClass, baseClass, checkedClasses)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkInheritor(@NotNull PsiManager manager, @NotNull PsiClass aClass, @NotNull PsiClass baseClass, @NotNull Set<PsiClass> checkedClasses) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/InheritanceImplUtil", "checkInheritor"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/InheritanceImplUtil", "checkInheritor"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/InheritanceImplUtil", "checkInheritor"));
        }
        if (checkedClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedClasses", "com/intellij/psi/impl/InheritanceImplUtil", "checkInheritor"));
        }
        ProgressIndicatorProvider.checkCanceled();
        if (manager.areElementsEquivalent(baseClass, aClass)) {
            return true;
        }
        if (checkedClasses.contains(aClass)) {
            return false;
        }
        return InheritanceImplUtil.isInheritor(manager, aClass, baseClass, true, checkedClasses);
    }

    public static boolean isInheritorDeep(@NotNull PsiClass candidateClass, @NotNull PsiClass baseClass, @Nullable PsiClass classToByPass) {
        if (candidateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateClass", "com/intellij/psi/impl/InheritanceImplUtil", "isInheritorDeep"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/InheritanceImplUtil", "isInheritorDeep"));
        }
        if (baseClass instanceof PsiAnonymousClass) {
            return false;
        }
        THashSet checkedClasses = null;
        if (classToByPass != null) {
            checkedClasses = new THashSet();
            checkedClasses.add(classToByPass);
        }
        return InheritanceImplUtil.isInheritor(candidateClass.getManager(), candidateClass, baseClass, true, (Set<PsiClass>)checkedClasses);
    }
}

