/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiIfStatementImpl
extends CompositePsiElement
implements PsiIfStatement,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiIfStatementImpl");

    public PsiIfStatementImpl() {
        super(IF_STATEMENT);
    }

    @Override
    public PsiExpression getCondition() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(32);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        ASTNode elseKeyword;
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/tree/java/PsiIfStatementImpl", "deleteChildInternal"));
        }
        if (child == this.getElseBranch() && (elseKeyword = this.findChildByRole(31)) != null) {
            super.deleteChildInternal(elseKeyword);
        }
        super.deleteChildInternal(child);
    }

    @Override
    public PsiStatement getThenBranch() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(33);
    }

    @Override
    public PsiStatement getElseBranch() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(34);
    }

    @Override
    public PsiJavaToken getLParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(24);
    }

    @Override
    public PsiJavaToken getRParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(25);
    }

    @Override
    public PsiKeyword getElseElement() {
        return (PsiKeyword)this.findChildByRoleAsPsiElement(31);
    }

    @Override
    public void setElseBranch(@NotNull PsiStatement statement) throws IncorrectOperationException {
        PsiKeyword elseElement;
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/psi/impl/source/tree/java/PsiIfStatementImpl", "setElseBranch"));
        }
        PsiStatement elseBranch = this.getElseBranch();
        if (elseBranch != null) {
            elseBranch.delete();
        }
        if ((elseElement = this.getElseElement()) != null) {
            elseElement.delete();
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance(this.getProject()).getElementFactory();
        PsiIfStatement ifStatement = (PsiIfStatement)elementFactory.createStatementFromText("if (true) {} else {}", null);
        ifStatement.getElseBranch().replace(statement);
        this.addRange(ifStatement.getElseElement(), ifStatement.getLastChild());
    }

    @Override
    public void setThenBranch(@NotNull PsiStatement statement) throws IncorrectOperationException {
        PsiStatement thenBranch;
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/psi/impl/source/tree/java/PsiIfStatementImpl", "setThenBranch"));
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance(this.getProject()).getElementFactory();
        ASTNode keyword = this.findChildByRole(30);
        LOG.assertTrue(keyword != null);
        PsiIfStatement ifStatementPattern = (PsiIfStatement)elementFactory.createStatementFromText("if (){}", this);
        if (this.getLParenth() == null) {
            this.addAfter(ifStatementPattern.getLParenth(), keyword.getPsi());
        }
        if (this.getRParenth() == null) {
            PsiElement anchor = this.getCondition() == null ? this.getLParenth() : this.getCondition();
            this.addAfter(ifStatementPattern.getRParenth(), anchor);
        }
        if ((thenBranch = this.getThenBranch()) == null) {
            this.addAfter(statement, this.getRParenth());
        } else {
            thenBranch.replace(statement);
        }
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 30: {
                return this.findChildByType(IF_KEYWORD);
            }
            case 24: {
                return this.findChildByType(LPARENTH);
            }
            case 32: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 25: {
                return this.findChildByType(RPARENTH);
            }
            case 33: {
                return PsiImplUtil.findStatementChild(this);
            }
            case 31: {
                return this.findChildByType(ELSE_KEYWORD);
            }
            case 34: 
        }
        ASTNode elseKeyword = this.findChildByRole(31);
        if (elseKeyword == null) {
            return null;
        }
        for (ASTNode child = elseKeyword.getTreeNext(); child != null; child = child.getTreeNext()) {
            if (!(child.getPsi() instanceof PsiStatement)) continue;
            return child;
        }
        return null;
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i2 = child.getElementType();
        if (i2 == IF_KEYWORD) {
            return 30;
        }
        if (i2 == ELSE_KEYWORD) {
            return 31;
        }
        if (i2 == LPARENTH) {
            return 24;
        }
        if (i2 == RPARENTH) {
            return 25;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 32;
        }
        if (child.getPsi() instanceof PsiStatement) {
            if (this.findChildByRoleAsPsiElement(33) == child) {
                return 33;
            }
            return 34;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/java/PsiIfStatementImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitIfStatement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiIfStatement";
    }
}

