/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.execution;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public class ParametersListUtil {
    public static final Function<String, List<String>> DEFAULT_LINE_PARSER = new Function<String, List<String>>(){

        @Override
        public List<String> fun(String text) {
            return ParametersListUtil.parse(text, true);
        }
    };
    public static final Function<List<String>, String> DEFAULT_LINE_JOINER = new Function<List<String>, String>(){

        @Override
        public String fun(List<String> strings) {
            return StringUtil.join(strings, " ");
        }
    };
    public static final Function<String, List<String>> COLON_LINE_PARSER = new Function<String, List<String>>(){

        @Override
        public List<String> fun(String text) {
            ArrayList<String> result = ContainerUtilRt.newArrayList();
            StringTokenizer tokenizer = new StringTokenizer(text, ";", false);
            while (tokenizer.hasMoreTokens()) {
                result.add(tokenizer.nextToken());
            }
            return result;
        }
    };
    public static final Function<List<String>, String> COLON_LINE_JOINER = new Function<List<String>, String>(){

        @Override
        public String fun(List<String> strings) {
            return StringUtil.join(strings, ";");
        }
    };

    @NotNull
    public static String join(@NotNull List<? extends CharSequence> parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/util/execution/ParametersListUtil", "join"));
        }
        String string = ParametersListUtil.encode(parameters);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/execution/ParametersListUtil", "join"));
        }
        return string;
    }

    @NotNull
    public static String join(String ... parameters) {
        String string = ParametersListUtil.encode(Arrays.asList(parameters));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/execution/ParametersListUtil", "join"));
        }
        return string;
    }

    @NotNull
    public static String[] parseToArray(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/util/execution/ParametersListUtil", "parseToArray"));
        }
        List<String> params = ParametersListUtil.parse(string);
        String[] stringArray = ArrayUtil.toStringArray(params);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/execution/ParametersListUtil", "parseToArray"));
        }
        return stringArray;
    }

    @NotNull
    public static List<String> parse(@NotNull String parameterString) {
        if (parameterString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterString", "com/intellij/util/execution/ParametersListUtil", "parse"));
        }
        List<String> list = ParametersListUtil.parse(parameterString, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/execution/ParametersListUtil", "parse"));
        }
        return list;
    }

    @NotNull
    public static List<String> parse(@NotNull String parameterString, boolean keepQuotes) {
        if (parameterString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterString", "com/intellij/util/execution/ParametersListUtil", "parse"));
        }
        List<String> list = ParametersListUtil.parse(parameterString, keepQuotes, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/execution/ParametersListUtil", "parse"));
        }
        return list;
    }

    @NotNull
    public static List<String> parse(@NotNull String parameterString, boolean keepQuotes, boolean supportSingleQuotes) {
        if (parameterString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterString", "com/intellij/util/execution/ParametersListUtil", "parse"));
        }
        parameterString = parameterString.trim();
        ArrayList<String> params = ContainerUtilRt.newArrayList();
        StringBuilder token = new StringBuilder(128);
        boolean inQuotes = false;
        boolean escapedQuote = false;
        TIntHashSet possibleQuoteChars = new TIntHashSet();
        possibleQuoteChars.add(34);
        if (supportSingleQuotes) {
            possibleQuoteChars.add(39);
        }
        char currentQuote = '\u0000';
        boolean nonEmpty = false;
        for (int i2 = 0; i2 < parameterString.length(); ++i2) {
            char ch = parameterString.charAt(i2);
            if (inQuotes ? currentQuote == ch : possibleQuoteChars.contains((int)ch)) {
                if (!escapedQuote) {
                    inQuotes = !inQuotes;
                    currentQuote = ch;
                    nonEmpty = true;
                    if (!keepQuotes) continue;
                }
                escapedQuote = false;
            } else if (Character.isWhitespace(ch)) {
                if (!inQuotes) {
                    if (token.length() <= 0 && !nonEmpty) continue;
                    params.add(token.toString());
                    token.setLength(0);
                    nonEmpty = false;
                    continue;
                }
            } else if (ch == '\\' && i2 < parameterString.length() - 1) {
                char nextchar = parameterString.charAt(i2 + 1);
                if (inQuotes ? currentQuote == nextchar : possibleQuoteChars.contains((int)nextchar)) {
                    escapedQuote = true;
                    if (!keepQuotes) continue;
                }
            }
            token.append(ch);
        }
        if (token.length() > 0 || nonEmpty) {
            params.add(token.toString());
        }
        ArrayList<String> arrayList = params;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/execution/ParametersListUtil", "parse"));
        }
        return arrayList;
    }

    @NotNull
    private static String encode(@NotNull List<? extends CharSequence> parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/util/execution/ParametersListUtil", "encode"));
        }
        if (parameters.isEmpty()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/execution/ParametersListUtil", "encode"));
            }
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        StringBuilder paramBuilder = new StringBuilder();
        for (CharSequence charSequence : parameters) {
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            paramBuilder.append(charSequence);
            ParametersListUtil.encodeParam(paramBuilder);
            buffer.append((CharSequence)paramBuilder);
            paramBuilder.setLength(0);
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/execution/ParametersListUtil", "encode"));
        }
        return string;
    }

    private static void encodeParam(@NotNull StringBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/util/execution/ParametersListUtil", "encodeParam"));
        }
        StringUtil.escapeQuotes(builder);
        if (builder.length() == 0 || StringUtil.indexOf((CharSequence)builder, ' ') >= 0 || StringUtil.indexOf((CharSequence)builder, '|') >= 0) {
            int numTrailingBackslashes = builder.length() - StringUtil.trimTrailing(builder, '\\').length();
            StringUtil.quote(builder);
            StringUtil.repeatSymbol(builder, '\\', numTrailingBackslashes);
        }
    }
}

