/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantCastUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.redundantCast.RedundantCastUtil");

    private RedundantCastUtil() {
    }

    @NotNull
    public static List<PsiTypeCastExpression> getRedundantCastsInside(PsiElement where) {
        MyCollectingVisitor visitor = new MyCollectingVisitor();
        if (where instanceof PsiEnumConstant) {
            where.accept(visitor);
        } else {
            where.acceptChildren(visitor);
        }
        ArrayList<PsiTypeCastExpression> arrayList = new ArrayList<PsiTypeCastExpression>(visitor.myFoundCasts);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/RedundantCastUtil", "getRedundantCastsInside"));
        }
        return arrayList;
    }

    public static boolean isCastRedundant(PsiTypeCastExpression typeCast) {
        PsiElement parent = typeCast.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiExpressionList) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiReferenceExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiAnonymousClass) {
            parent = parent.getParent();
        }
        MyIsRedundantVisitor visitor = new MyIsRedundantVisitor(true);
        parent.accept(visitor);
        return visitor.isRedundant;
    }

    @Nullable
    private static PsiExpression deparenthesizeExpression(PsiExpression arg) {
        while (arg instanceof PsiParenthesizedExpression) {
            arg = ((PsiParenthesizedExpression)arg).getExpression();
        }
        return arg;
    }

    public static PsiExpression removeCast(PsiTypeCastExpression castExpression) {
        if (castExpression == null) {
            return null;
        }
        PsiExpression operand = castExpression.getOperand();
        if (operand instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parExpr = (PsiParenthesizedExpression)operand;
            operand = parExpr.getExpression();
        }
        if (operand == null) {
            return null;
        }
        PsiExpression toBeReplaced = castExpression;
        PsiElement parent = castExpression.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            toBeReplaced = (PsiExpression)parent;
            parent = parent.getParent();
        }
        try {
            return (PsiExpression)toBeReplaced.replace(operand);
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
            return toBeReplaced;
        }
    }

    private static boolean isCastRedundantInRefExpression(PsiReferenceExpression refExpression, PsiExpression castOperand) {
        if (refExpression.getParent() instanceof PsiMethodCallExpression) {
            return false;
        }
        PsiElement resolved = refExpression.resolve();
        try {
            PsiReferenceExpression copy;
            PsiExpression qualifier;
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance(refExpression.getProject()).getElementFactory();
            PsiExpression copyExpression = elementFactory.createExpressionFromText(refExpression.getText(), refExpression);
            if (copyExpression instanceof PsiReferenceExpression && (qualifier = (copy = (PsiReferenceExpression)copyExpression).getQualifierExpression()) != null) {
                qualifier.replace(castOperand);
                return copy.resolve() == resolved;
            }
        }
        catch (IncorrectOperationException incorrectOperationException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isTypeCastSemantic(PsiTypeCastExpression typeCast) {
        PsiExpression stripParenthesisOperand;
        PsiExpression operand = typeCast.getOperand();
        if (operand == null) {
            return false;
        }
        if (RedundantCastUtil.isInPolymorphicCall(typeCast)) {
            return true;
        }
        PsiType opType = operand.getType();
        PsiTypeElement typeElement = typeCast.getCastType();
        if (typeElement == null) {
            return false;
        }
        PsiType castType = typeElement.getType();
        if (castType instanceof PsiPrimitiveType) {
            if (opType instanceof PsiPrimitiveType) {
                return !opType.equals(castType);
            }
            PsiPrimitiveType unboxedOpType = PsiPrimitiveType.getUnboxedType(opType);
            if (unboxedOpType != null && !unboxedOpType.equals(castType)) {
                return true;
            }
        } else if (castType instanceof PsiClassType && ((PsiClassType)castType).hasParameters() && opType instanceof PsiClassType && ((PsiClassType)opType).isRaw()) {
            return true;
        }
        if ((stripParenthesisOperand = PsiUtil.skipParenthesizedExprDown(operand)) instanceof PsiFunctionalExpression) {
            if (RedundantCastUtil.isCastToSerializable(castType)) {
                return true;
            }
        } else if (stripParenthesisOperand instanceof PsiConditionalExpression) {
            PsiExpression thenExpr = PsiUtil.skipParenthesizedExprDown(((PsiConditionalExpression)stripParenthesisOperand).getThenExpression());
            PsiExpression elseExpr = PsiUtil.skipParenthesizedExprDown(((PsiConditionalExpression)stripParenthesisOperand).getElseExpression());
            if (thenExpr instanceof PsiFunctionalExpression || elseExpr instanceof PsiFunctionalExpression) {
                return true;
            }
        }
        PsiElement parent = typeCast.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiBinaryExpression) {
            PsiBinaryExpression expression = (PsiBinaryExpression)parent;
            PsiExpression firstOperand = expression.getLOperand();
            PsiExpression otherOperand = expression.getROperand();
            if (PsiTreeUtil.isAncestor(otherOperand, typeCast, false)) {
                PsiExpression temp = otherOperand;
                otherOperand = firstOperand;
                firstOperand = temp;
            }
            if (firstOperand != null && otherOperand != null && RedundantCastUtil.wrapperCastChangeSemantics(firstOperand, otherOperand, operand)) {
                return true;
            }
        } else if (parent instanceof PsiConditionalExpression && opType instanceof PsiPrimitiveType && !(((PsiConditionalExpression)parent).getType() instanceof PsiPrimitiveType) && PsiPrimitiveType.getUnboxedType(PsiTypesUtil.getExpectedTypeByParent(parent)) != null) {
            return true;
        }
        return false;
    }

    private static boolean isCastToSerializable(PsiType castType) {
        return InheritanceUtil.isInheritor(castType, "java.io.Serializable");
    }

    private static boolean wrapperCastChangeSemantics(PsiExpression operand, PsiExpression otherOperand, PsiExpression toCast) {
        boolean isPrimitiveComparisonWithoutCast;
        boolean isPrimitiveComparisonWithCast;
        if (TypeConversionUtil.isPrimitiveAndNotNull(otherOperand.getType())) {
            isPrimitiveComparisonWithCast = TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(operand.getType());
            isPrimitiveComparisonWithoutCast = TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(toCast.getType());
        } else {
            isPrimitiveComparisonWithCast = TypeConversionUtil.isPrimitiveAndNotNull(operand.getType());
            isPrimitiveComparisonWithoutCast = TypeConversionUtil.isPrimitiveAndNotNull(toCast.getType());
        }
        return isPrimitiveComparisonWithCast != isPrimitiveComparisonWithoutCast;
    }

    public static boolean isInPolymorphicCall(PsiTypeCastExpression typeCast) {
        PsiElement methodCall;
        if (!PsiUtil.isLanguageLevel7OrHigher(typeCast)) {
            return false;
        }
        PsiExpression operand = typeCast.getOperand();
        if (operand instanceof PsiMethodCallExpression && RedundantCastUtil.isPolymorphicMethod((PsiMethodCallExpression)operand)) {
            return true;
        }
        PsiElement exprList = typeCast.getParent();
        return exprList instanceof PsiExpressionList && (methodCall = exprList.getParent()) instanceof PsiMethodCallExpression && RedundantCastUtil.isPolymorphicMethod((PsiMethodCallExpression)methodCall);
    }

    private static boolean isPolymorphicMethod(PsiMethodCallExpression expression) {
        PsiElement method = expression.getMethodExpression().resolve();
        return method instanceof PsiMethod && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiMethod)method), "java.lang.invoke.MethodHandle.PolymorphicSignature", false, true);
    }

    private static class MyIsRedundantVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean isRedundant;
        private final boolean myRecursive;

        private MyIsRedundantVisitor(boolean recursive) {
            this.myRecursive = recursive;
        }

        @Override
        public void visitElement(PsiElement element) {
            if (this.myRecursive) {
                super.visitElement(element);
            }
        }

        protected void addToResults(@NotNull PsiTypeCastExpression typeCast) {
            if (typeCast == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeCast", "com/intellij/psi/util/RedundantCastUtil$MyIsRedundantVisitor", "addToResults"));
            }
            if (!RedundantCastUtil.isTypeCastSemantic(typeCast)) {
                this.isRedundant = true;
            }
        }

        @Override
        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            this.processPossibleTypeCast(expression.getRExpression(), expression.getLExpression().getType());
            super.visitAssignmentExpression(expression);
        }

        @Override
        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
            PsiType type = expression.getType();
            if (type instanceof PsiArrayType) {
                for (PsiExpression initializer : expression.getInitializers()) {
                    this.processPossibleTypeCast(initializer, ((PsiArrayType)type).getComponentType());
                }
            }
            super.visitArrayInitializerExpression(expression);
        }

        @Override
        public void visitVariable(PsiVariable variable) {
            this.processPossibleTypeCast(variable.getInitializer(), variable.getType());
            super.visitVariable(variable);
        }

        @Override
        public void visitReturnStatement(PsiReturnStatement statement) {
            PsiMethod method = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class, true, PsiLambdaExpression.class);
            if (method != null) {
                PsiType returnType = method.getReturnType();
                PsiExpression returnValue = statement.getReturnValue();
                if (returnValue != null) {
                    this.processPossibleTypeCast(returnValue, returnType);
                }
            }
            super.visitReturnStatement(statement);
        }

        @Override
        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            IElementType tokenType = expression.getOperationTokenType();
            PsiExpression[] operands = expression.getOperands();
            if (operands.length >= 2) {
                PsiType lType = operands[0].getType();
                this.processBinaryExpressionOperand(RedundantCastUtil.deparenthesizeExpression(operands[0]), operands[1].getType(), tokenType);
                for (int i = 1; i < operands.length; ++i) {
                    PsiExpression operand = RedundantCastUtil.deparenthesizeExpression(operands[i]);
                    if (operand == null) continue;
                    this.processBinaryExpressionOperand(operand, lType, tokenType);
                    lType = TypeConversionUtil.calcTypeForBinaryExpression(lType, operand.getType(), tokenType, true);
                }
            }
            super.visitPolyadicExpression(expression);
        }

        private void processBinaryExpressionOperand(PsiExpression operand, PsiType otherType, IElementType binaryToken) {
            PsiTypeCastExpression typeCast;
            PsiExpression toCast;
            if (operand instanceof PsiTypeCastExpression && (toCast = (typeCast = (PsiTypeCastExpression)operand).getOperand()) != null && TypeConversionUtil.isBinaryOperatorApplicable(binaryToken, toCast.getType(), otherType, false)) {
                this.addToResults(typeCast);
            }
        }

        private void processPossibleTypeCast(PsiExpression rExpr, @Nullable PsiType lType) {
            PsiExpression castOperand;
            if ((rExpr = RedundantCastUtil.deparenthesizeExpression(rExpr)) instanceof PsiTypeCastExpression && (castOperand = ((PsiTypeCastExpression)rExpr).getOperand()) != null) {
                PsiType operandType;
                if (castOperand instanceof PsiTypeCastExpression) {
                    PsiExpression nestedCastOperand = ((PsiTypeCastExpression)castOperand).getOperand();
                    operandType = nestedCastOperand != null ? nestedCastOperand.getType() : null;
                } else if (castOperand instanceof PsiFunctionalExpression && lType != null) {
                    PsiTypeElement typeElement = ((PsiTypeCastExpression)rExpr).getCastType();
                    PsiType castType = typeElement != null ? typeElement.getType() : null;
                    operandType = lType.equals(castType) ? castOperand.getType() : null;
                } else {
                    operandType = castOperand.getType();
                }
                if (operandType != null && lType != null && TypeConversionUtil.isAssignable(lType, operandType, false)) {
                    this.addToResults((PsiTypeCastExpression)rExpr);
                }
            }
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            this.processCall(expression);
            this.checkForVirtual(expression);
            super.visitMethodCallExpression(expression);
        }

        private void checkForVirtual(PsiMethodCallExpression methodCall) {
            PsiReferenceExpression methodExpr = methodCall.getMethodExpression();
            PsiExpression qualifier = methodExpr.getQualifierExpression();
            if (!(qualifier instanceof PsiParenthesizedExpression)) {
                return;
            }
            PsiExpression operand = ((PsiParenthesizedExpression)qualifier).getExpression();
            if (!(operand instanceof PsiTypeCastExpression)) {
                return;
            }
            PsiTypeCastExpression typeCast = (PsiTypeCastExpression)operand;
            PsiExpression castOperand = typeCast.getOperand();
            if (castOperand == null) {
                return;
            }
            PsiType type = castOperand.getType();
            if (type == null) {
                return;
            }
            if (type instanceof PsiPrimitiveType) {
                return;
            }
            JavaResolveResult resolveResult = methodExpr.advancedResolve(false);
            PsiMethod targetMethod = (PsiMethod)resolveResult.getElement();
            if (targetMethod == null) {
                return;
            }
            if (targetMethod.hasModifierProperty("static")) {
                return;
            }
            try {
                PsiManager manager = methodExpr.getManager();
                PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
                PsiExpression expressionFromText = factory.createExpressionFromText(methodCall.getText(), methodCall);
                if (!(expressionFromText instanceof PsiMethodCallExpression)) {
                    return;
                }
                PsiMethodCallExpression newCall = (PsiMethodCallExpression)expressionFromText;
                PsiExpression newQualifier = newCall.getMethodExpression().getQualifierExpression();
                PsiExpression newOperand = ((PsiTypeCastExpression)((PsiParenthesizedExpression)newQualifier).getExpression()).getOperand();
                newQualifier.replace(newOperand);
                JavaResolveResult newResult = newCall.getMethodExpression().advancedResolve(false);
                if (!newResult.isValidResult()) {
                    return;
                }
                PsiMethod newTargetMethod = (PsiMethod)newResult.getElement();
                PsiType newReturnType = newCall.getType();
                PsiType oldReturnType = methodCall.getType();
                if (newReturnType instanceof PsiCapturedWildcardType && oldReturnType instanceof PsiCapturedWildcardType) {
                    newReturnType = ((PsiCapturedWildcardType)newReturnType).getUpperBound();
                    oldReturnType = ((PsiCapturedWildcardType)oldReturnType).getUpperBound();
                }
                if (Comparing.equal(newReturnType, oldReturnType) && (Comparing.equal(newTargetMethod, targetMethod) || newTargetMethod.getSignature(newResult.getSubstitutor()).equals(targetMethod.getSignature(resolveResult.getSubstitutor())) && (!newTargetMethod.isDeprecated() || targetMethod.isDeprecated()) && MyIsRedundantVisitor.areThrownExceptionsCompatible(targetMethod, newTargetMethod))) {
                    this.addToResults(typeCast);
                }
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
        }

        private static boolean areThrownExceptionsCompatible(PsiMethod targetMethod, PsiMethod newTargetMethod) {
            PsiClassType[] newThrowsTypes;
            PsiClassType[] oldThrowsTypes = targetMethod.getThrowsList().getReferencedTypes();
            for (PsiClassType throwsType : newThrowsTypes = newTargetMethod.getThrowsList().getReferencedTypes()) {
                if (MyIsRedundantVisitor.isExceptionThrown(throwsType, oldThrowsTypes)) continue;
                return false;
            }
            return true;
        }

        private static boolean isExceptionThrown(PsiClassType exceptionType, PsiClassType[] thrownTypes) {
            for (PsiClassType type : thrownTypes) {
                if (!type.equals(exceptionType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void visitNewExpression(PsiNewExpression expression) {
            this.processCall(expression);
            super.visitNewExpression(expression);
        }

        @Override
        public void visitEnumConstant(PsiEnumConstant enumConstant) {
            this.processCall(enumConstant);
            super.visitEnumConstant(enumConstant);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
        }

        private void processCall(PsiCall expression) {
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] args = argumentList.getExpressions();
            JavaResolveResult oldResult = expression.resolveMethodGenerics();
            PsiElement element = oldResult.getElement();
            if (!(element instanceof PsiMethod)) {
                return;
            }
            PsiMethod oldMethod = (PsiMethod)element;
            PsiParameter[] parameters = oldMethod.getParameterList().getParameters();
            try {
                for (int i = 0; i < args.length; ++i) {
                    PsiType interfaceType;
                    PsiExpression arg = RedundantCastUtil.deparenthesizeExpression(args[i]);
                    if (arg instanceof PsiTypeCastExpression) {
                        PsiAnonymousClass newAnonymousClass;
                        JavaResolveResult newResult;
                        PsiCall newCall;
                        PsiTypeCastExpression cast = (PsiTypeCastExpression)arg;
                        if (i == args.length - 1 && args.length == parameters.length && parameters[i].isVarArgs()) continue;
                        PsiType typeByParent = PsiTypesUtil.getExpectedTypeByParent(expression);
                        if (typeByParent != null) {
                            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(expression.getProject());
                            String arrayCreationText = "new " + typeByParent.getCanonicalText() + "[] {" + expression.getText() + "}";
                            PsiExpression arrayDeclaration = elementFactory.createExpressionFromText(arrayCreationText, expression);
                            newCall = (PsiCall)((Object)((PsiNewExpression)arrayDeclaration).getArrayInitializer().getInitializers()[0]);
                        } else {
                            PsiCall call = LambdaUtil.treeWalkUp(expression);
                            if (call != null) {
                                PsiCall callCopy = (PsiCall)call.copy();
                                newCall = (PsiCall)PsiTreeUtil.getParentOfType(callCopy.findElementAt(argumentList.getTextRange().getStartOffset() - call.getTextRange().getStartOffset()), expression.getClass());
                            } else {
                                newCall = (PsiCall)expression.copy();
                            }
                        }
                        PsiExpressionList argList = newCall.getArgumentList();
                        LOG.assertTrue(argList != null);
                        PsiExpression[] newArgs = argList.getExpressions();
                        LOG.assertTrue(newArgs.length == args.length, "oldCall: " + expression.getText() + "; old length: " + args.length + "; newCall: " + newCall.getText() + "; new length: " + newArgs.length);
                        PsiTypeCastExpression castExpression = (PsiTypeCastExpression)RedundantCastUtil.deparenthesizeExpression(newArgs[i]);
                        PsiTypeElement castTypeElement = cast.getCastType();
                        PsiType castType = castTypeElement != null ? castTypeElement.getType() : null;
                        PsiExpression castOperand = castExpression.getOperand();
                        if (castOperand == null) {
                            return;
                        }
                        newArgs[i] = (PsiExpression)castExpression.replace(castOperand);
                        if (newCall instanceof PsiEnumConstant) {
                            PsiEnumConstant enumConstant = (PsiEnumConstant)expression;
                            PsiClass containingClass = enumConstant.getContainingClass();
                            JavaPsiFacade facade = JavaPsiFacade.getInstance(enumConstant.getProject());
                            PsiClassType type = facade.getElementFactory().createType(containingClass);
                            newResult = facade.getResolveHelper().resolveConstructor(type, newCall.getArgumentList(), enumConstant);
                        } else {
                            newResult = newCall.resolveMethodGenerics();
                        }
                        PsiAnonymousClass oldAnonymousClass = expression instanceof PsiNewExpression ? ((PsiNewExpression)expression).getAnonymousClass() : null;
                        PsiAnonymousClass psiAnonymousClass = newAnonymousClass = newCall instanceof PsiNewExpression ? ((PsiNewExpression)newCall).getAnonymousClass() : null;
                        if (!oldMethod.equals(newResult.getElement()) || newCall instanceof PsiCallExpression && (oldAnonymousClass == null || newAnonymousClass == null || !Comparing.equal(oldAnonymousClass.getBaseClassType(), newAnonymousClass.getBaseClassType())) && !Comparing.equal(PsiUtil.recaptureWildcards(((PsiCallExpression)newCall).getType(), expression), ((PsiCallExpression)expression).getType()) || !newResult.isValidResult()) continue;
                        if (!(newArgs[i] instanceof PsiFunctionalExpression)) {
                            this.addToResults(cast);
                            continue;
                        }
                        boolean varargs = newResult instanceof MethodCandidateInfo && ((MethodCandidateInfo)newResult).isVarargs();
                        PsiType parameterType = PsiTypesUtil.getParameterType(parameters, i, varargs);
                        PsiType newArgType = newResult.getSubstitutor().substitute(parameterType);
                        if (!Comparing.equal(oldResult.getSubstitutor().substitute(parameterType), newArgType) || !Comparing.equal(TypeConversionUtil.erasure(castType), TypeConversionUtil.erasure(newArgType))) continue;
                        this.addToResults(cast);
                        continue;
                    }
                    if (!(arg instanceof PsiLambdaExpression) || (interfaceType = ((PsiLambdaExpression)arg).getFunctionalInterfaceType()) == null) continue;
                    List<PsiExpression> expressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)arg);
                    for (int returnExprIdx = 0; returnExprIdx < expressions.size(); ++returnExprIdx) {
                        PsiExpression elseExpression;
                        PsiExpression returnExpression = RedundantCastUtil.deparenthesizeExpression(expressions.get(returnExprIdx));
                        if (returnExpression instanceof PsiTypeCastExpression) {
                            this.processLambdaReturnExpression(expression, i, interfaceType, (PsiTypeCastExpression)returnExpression, returnExprIdx, expression13 -> (PsiTypeCastExpression)expression13);
                            continue;
                        }
                        if (!(returnExpression instanceof PsiConditionalExpression)) continue;
                        PsiExpression thenExpression = ((PsiConditionalExpression)returnExpression).getThenExpression();
                        if (thenExpression instanceof PsiTypeCastExpression) {
                            this.processLambdaReturnExpression(expression, i, interfaceType, (PsiTypeCastExpression)thenExpression, returnExprIdx, expression12 -> (PsiTypeCastExpression)((PsiConditionalExpression)expression12).getThenExpression());
                        }
                        if (!((elseExpression = ((PsiConditionalExpression)returnExpression).getElseExpression()) instanceof PsiTypeCastExpression)) continue;
                        this.processLambdaReturnExpression(expression, i, interfaceType, (PsiTypeCastExpression)elseExpression, returnExprIdx, expression1 -> (PsiTypeCastExpression)((PsiConditionalExpression)expression1).getElseExpression());
                    }
                }
            }
            catch (IncorrectOperationException e) {
                return;
            }
            for (PsiExpression arg : args) {
                if (arg instanceof PsiTypeCastExpression) {
                    PsiExpression castOperand = ((PsiTypeCastExpression)arg).getOperand();
                    if (castOperand == null) continue;
                    castOperand.accept(this);
                    continue;
                }
                arg.accept(this);
            }
        }

        private void processLambdaReturnExpression(PsiCall expression, int i, PsiType interfaceType, PsiTypeCastExpression returnExpression, int returnExprIdx, Function<PsiExpression, PsiTypeCastExpression> computeCastExpression) {
            PsiCall newCall = LambdaUtil.copyTopLevelCall(expression);
            if (newCall == null) {
                return;
            }
            PsiExpressionList newArgsList = newCall.getArgumentList();
            LOG.assertTrue(newArgsList != null);
            PsiExpression[] newArgs = newArgsList.getExpressions();
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)RedundantCastUtil.deparenthesizeExpression(newArgs[i]);
            LOG.assertTrue(lambdaExpression != null, newCall);
            PsiExpression newReturnExpression = RedundantCastUtil.deparenthesizeExpression(LambdaUtil.getReturnExpressions(lambdaExpression).get(returnExprIdx));
            PsiTypeCastExpression castExpression = computeCastExpression.fun(newReturnExpression);
            PsiExpression castOperand = castExpression.getOperand();
            if (castOperand == null) {
                return;
            }
            castOperand = (PsiExpression)castExpression.replace(castOperand);
            PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
            if (interfaceType.equals(functionalInterfaceType)) {
                PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType(interfaceType);
                PsiType castExprType = castOperand.getType();
                if (interfaceReturnType != null && castExprType != null && interfaceReturnType.isAssignableFrom(castExprType)) {
                    this.addToResults(returnExpression);
                }
            }
        }

        @Override
        public void visitTypeCastExpression(PsiTypeCastExpression typeCast) {
            PsiExpression operand = typeCast.getOperand();
            if (operand == null) {
                return;
            }
            PsiExpression expr = RedundantCastUtil.deparenthesizeExpression(operand);
            PsiType topCastType = typeCast.getType();
            if (expr instanceof PsiTypeCastExpression) {
                PsiType operandType;
                PsiTypeElement typeElement = ((PsiTypeCastExpression)expr).getCastType();
                if (typeElement == null) {
                    return;
                }
                PsiType castType = typeElement.getType();
                PsiExpression innerOperand = ((PsiTypeCastExpression)expr).getOperand();
                PsiType psiType = operandType = innerOperand != null ? innerOperand.getType() : null;
                if (!(castType instanceof PsiPrimitiveType) && !(topCastType instanceof PsiPrimitiveType)) {
                    if (operandType != null && topCastType != null && TypeConversionUtil.areTypesConvertible(operandType, topCastType)) {
                        this.addToResults((PsiTypeCastExpression)expr);
                    }
                } else if (Comparing.equal(PsiPrimitiveType.getUnboxedType(operandType), topCastType)) {
                    this.addToResults((PsiTypeCastExpression)expr);
                }
            } else {
                PsiElement parent = typeCast.getParent();
                if (parent instanceof PsiConditionalExpression) {
                    PsiType conditionalType;
                    PsiType operandType = operand.getType();
                    if (!Comparing.equal(operandType, conditionalType = ((PsiConditionalExpression)parent).getType())) {
                        PsiExpression opposite;
                        if (!PsiUtil.isLanguageLevel5OrHigher(typeCast)) {
                            return;
                        }
                        if (!MyIsRedundantVisitor.checkResolveAfterRemoveCast(parent)) {
                            return;
                        }
                        PsiExpression thenExpression = ((PsiConditionalExpression)parent).getThenExpression();
                        PsiExpression elseExpression = ((PsiConditionalExpression)parent).getElseExpression();
                        PsiExpression psiExpression = opposite = thenExpression == typeCast ? elseExpression : thenExpression;
                        if (opposite == null || conditionalType instanceof PsiPrimitiveType && !Comparing.equal(conditionalType, opposite.getType())) {
                            return;
                        }
                    }
                } else {
                    if (parent instanceof PsiSynchronizedStatement && expr != null && expr.getType() instanceof PsiPrimitiveType) {
                        return;
                    }
                    if (expr instanceof PsiLambdaExpression || expr instanceof PsiMethodReferenceExpression) {
                        if (parent instanceof PsiParenthesizedExpression && parent.getParent() instanceof PsiReferenceExpression) {
                            return;
                        }
                        PsiType functionalInterfaceType = PsiTypesUtil.getExpectedTypeByParent(typeCast);
                        if (topCastType != null && functionalInterfaceType != null && !TypeConversionUtil.isAssignable(topCastType, functionalInterfaceType, false)) {
                            return;
                        }
                    }
                }
                this.processAlreadyHasTypeCast(typeCast);
            }
            super.visitTypeCastExpression(typeCast);
        }

        private static boolean checkResolveAfterRemoveCast(PsiElement parent) {
            PsiElement grandPa = parent.getParent();
            if (grandPa instanceof PsiExpressionList) {
                PsiMethod resolve;
                PsiExpression[] expressions = ((PsiExpressionList)grandPa).getExpressions();
                int idx = ArrayUtil.find(expressions, parent);
                PsiElement grandGrandPa = grandPa.getParent();
                if (grandGrandPa instanceof PsiCall && (resolve = ((PsiCall)grandGrandPa).resolveMethod()) != null) {
                    PsiCall expression = LambdaUtil.copyTopLevelCall((PsiCall)grandGrandPa);
                    if (expression == null) {
                        return false;
                    }
                    PsiExpressionList argumentList = expression.getArgumentList();
                    LOG.assertTrue(argumentList != null);
                    PsiExpression toReplace = argumentList.getExpressions()[idx];
                    if (toReplace instanceof PsiConditionalExpression) {
                        PsiExpression elseOperand;
                        PsiExpression thenExpression = ((PsiConditionalExpression)toReplace).getThenExpression();
                        PsiExpression elseExpression = ((PsiConditionalExpression)toReplace).getElseExpression();
                        if (thenExpression instanceof PsiTypeCastExpression) {
                            PsiExpression thenOperand = ((PsiTypeCastExpression)thenExpression).getOperand();
                            if (thenOperand != null) {
                                thenExpression.replace(thenOperand);
                            }
                        } else if (elseExpression instanceof PsiTypeCastExpression && (elseOperand = ((PsiTypeCastExpression)elseExpression).getOperand()) != null) {
                            elseExpression.replace(elseOperand);
                        }
                    }
                    if (expression.resolveMethod() != resolve) {
                        return false;
                    }
                }
            }
            return true;
        }

        private void processAlreadyHasTypeCast(PsiTypeCastExpression typeCast) {
            PsiElement parent = typeCast.getParent();
            while (parent instanceof PsiParenthesizedExpression) {
                parent = parent.getParent();
            }
            if (parent instanceof PsiExpressionList) {
                return;
            }
            if (parent instanceof PsiReturnStatement) {
                return;
            }
            if (parent instanceof PsiTypeCastExpression) {
                return;
            }
            if (parent instanceof PsiLambdaExpression) {
                return;
            }
            if (parent instanceof PsiConditionalExpression) {
                PsiElement gParent = PsiUtil.skipParenthesizedExprUp(parent.getParent());
                if (gParent instanceof PsiLambdaExpression) {
                    return;
                }
                if (gParent instanceof PsiReturnStatement && PsiTreeUtil.getParentOfType(gParent, PsiMethod.class, PsiLambdaExpression.class) instanceof PsiLambdaExpression) {
                    return;
                }
            }
            if (RedundantCastUtil.isTypeCastSemantic(typeCast)) {
                return;
            }
            PsiTypeElement typeElement = typeCast.getCastType();
            if (typeElement == null) {
                return;
            }
            PsiType castTo = typeElement.getType();
            PsiExpression operand = typeCast.getOperand();
            PsiType opType = operand.getType();
            PsiType expectedTypeByParent = PsiTypesUtil.getExpectedTypeByParent(typeCast);
            if (expectedTypeByParent != null) {
                try {
                    PsiExpression expr;
                    Project project = operand.getProject();
                    String uniqueVariableName = JavaCodeStyleManager.getInstance(project).suggestUniqueVariableName("l", parent, false);
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)JavaPsiFacade.getElementFactory(project).createStatementFromText(expectedTypeByParent.getCanonicalText() + " " + uniqueVariableName + " = " + operand.getText() + ";", parent);
                    PsiExpression initializer = ((PsiLocalVariable)declarationStatement.getDeclaredElements()[0]).getInitializer();
                    LOG.assertTrue(initializer != null, operand.getText());
                    opType = initializer.getType();
                    if (opType != null && (expr = PsiUtil.skipParenthesizedExprDown(operand)) instanceof PsiConditionalExpression) {
                        if (!MyIsRedundantVisitor.isApplicableForConditionalBranch(opType, ((PsiConditionalExpression)expr).getThenExpression())) {
                            return;
                        }
                        if (!MyIsRedundantVisitor.isApplicableForConditionalBranch(opType, ((PsiConditionalExpression)expr).getElseExpression())) {
                            return;
                        }
                    }
                }
                catch (IncorrectOperationException project) {
                    // empty catch block
                }
            }
            if (opType == null) {
                return;
            }
            if (parent instanceof PsiReferenceExpression) {
                if (castTo instanceof PsiClassType && opType instanceof PsiPrimitiveType) {
                    return;
                }
                if (opType instanceof PsiClassType) {
                    PsiReferenceExpression refExpression = (PsiReferenceExpression)parent;
                    PsiElement element = refExpression.resolve();
                    if (!(element instanceof PsiMember)) {
                        return;
                    }
                    PsiClass accessClass = ((PsiClassType)opType).resolve();
                    if (accessClass == null) {
                        return;
                    }
                    if (!JavaPsiFacade.getInstance(parent.getProject()).getResolveHelper().isAccessible((PsiMember)element, typeCast, accessClass)) {
                        return;
                    }
                    if (!RedundantCastUtil.isCastRedundantInRefExpression(refExpression, operand)) {
                        return;
                    }
                }
            }
            if (parent instanceof PsiConditionalExpression) {
                if (castTo instanceof PsiClassType && opType instanceof PsiPrimitiveType && opType != PsiType.NULL) {
                    PsiExpression opposite;
                    PsiExpression thenExpression = ((PsiConditionalExpression)parent).getThenExpression();
                    PsiExpression elseExpression = ((PsiConditionalExpression)parent).getElseExpression();
                    PsiExpression psiExpression = opposite = PsiTreeUtil.isAncestor(thenExpression, typeCast, false) ? elseExpression : thenExpression;
                    if (opposite != null && !(opposite.getType() instanceof PsiPrimitiveType) && !(PsiTypesUtil.getExpectedTypeByParent(parent) instanceof PsiPrimitiveType)) {
                        return;
                    }
                }
                if (operand instanceof PsiFunctionalExpression && !castTo.equals(PsiTypesUtil.getExpectedTypeByParent(parent))) {
                    return;
                }
            }
            if (MyIsRedundantVisitor.arrayAccessAtTheLeftSideOfAssignment(parent, typeCast)) {
                if (TypeConversionUtil.isAssignable(opType, castTo, false) && opType.getArrayDimensions() == castTo.getArrayDimensions()) {
                    this.addToResults(typeCast);
                }
            } else {
                if (parent instanceof PsiInstanceOfExpression && opType instanceof PsiPrimitiveType) {
                    return;
                }
                if (parent instanceof PsiForeachStatement) {
                    PsiClassType.ClassResolveResult castResolveResult = PsiUtil.resolveGenericsClassInType(opType);
                    PsiClass psiClass = castResolveResult.getElement();
                    if (psiClass != null) {
                        PsiType resultedParamType;
                        PsiTypeParameter[] iterableTypeParameters;
                        PsiClass iterableClass = JavaPsiFacade.getInstance(parent.getProject()).findClass("java.lang.Iterable", psiClass.getResolveScope());
                        if (iterableClass != null && InheritanceUtil.isInheritorOrSelf(psiClass, iterableClass, true) && (iterableTypeParameters = iterableClass.getTypeParameters()).length == 1 && (resultedParamType = TypeConversionUtil.getSuperClassSubstitutor(iterableClass, psiClass, castResolveResult.getSubstitutor()).substitute(iterableTypeParameters[0])) != null && TypeConversionUtil.isAssignable(((PsiForeachStatement)parent).getIterationParameter().getType(), resultedParamType)) {
                            this.addToResults(typeCast);
                            return;
                        }
                    } else {
                        return;
                    }
                }
                if (parent instanceof PsiThrowStatement) {
                    PsiMethod method;
                    PsiClass thrownClass = PsiUtil.resolveClassInType(opType);
                    if (InheritanceUtil.isInheritor(thrownClass, false, "java.lang.RuntimeException")) {
                        this.addToResults(typeCast);
                        return;
                    }
                    if (InheritanceUtil.isInheritor(thrownClass, false, "java.lang.Throwable") && (method = PsiTreeUtil.getParentOfType(parent, PsiMethod.class)) != null) {
                        for (PsiClassType thrownType : method.getThrowsList().getReferencedTypes()) {
                            if (!TypeConversionUtil.isAssignable(thrownType, opType, false)) continue;
                            this.addToResults(typeCast);
                            return;
                        }
                    }
                }
                if (parent instanceof PsiInstanceOfExpression) {
                    PsiTypeElement checkTypeElement = ((PsiInstanceOfExpression)parent).getCheckType();
                    if (checkTypeElement != null && TypeConversionUtil.areTypesConvertible(opType, checkTypeElement.getType())) {
                        this.addToResults(typeCast);
                    }
                } else if (TypeConversionUtil.isAssignable(castTo, opType, false) && (expectedTypeByParent == null || TypeConversionUtil.isAssignable(expectedTypeByParent, opType, false))) {
                    this.addToResults(typeCast);
                }
            }
        }

        private static boolean isApplicableForConditionalBranch(PsiType opType, PsiExpression thenExpression) {
            PsiType thenType;
            return thenExpression == null || (thenType = thenExpression.getType()) == null || TypeConversionUtil.isAssignable(opType, thenType);
        }

        private static boolean arrayAccessAtTheLeftSideOfAssignment(PsiElement parent, PsiElement element) {
            PsiAssignmentExpression assignment = PsiTreeUtil.getParentOfType(parent, PsiAssignmentExpression.class, false, PsiMember.class);
            if (assignment == null) {
                return false;
            }
            PsiExpression lExpression = assignment.getLExpression();
            return lExpression instanceof PsiArrayAccessExpression && PsiTreeUtil.isAncestor(lExpression, parent, false) && !MyIsRedundantVisitor.isIndexExpression(element, (PsiArrayAccessExpression)lExpression);
        }

        private static boolean isIndexExpression(PsiElement element, PsiArrayAccessExpression arrayAccessExpression) {
            if (PsiTreeUtil.isAncestor(arrayAccessExpression.getIndexExpression(), element, false)) {
                return true;
            }
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            if (arrayExpression instanceof PsiArrayAccessExpression) {
                return MyIsRedundantVisitor.isIndexExpression(element, (PsiArrayAccessExpression)arrayExpression);
            }
            return false;
        }
    }

    private static class MyCollectingVisitor
    extends MyIsRedundantVisitor {
        private final Set<PsiTypeCastExpression> myFoundCasts = new HashSet<PsiTypeCastExpression>();

        private MyCollectingVisitor() {
            super(true);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.visitElement(expression);
        }

        @Override
        public void visitClass(PsiClass aClass) {
        }

        @Override
        public void visitMethod(PsiMethod method) {
        }

        @Override
        public void visitField(PsiField field) {
        }

        @Override
        protected void addToResults(@NotNull PsiTypeCastExpression typeCast) {
            if (typeCast == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeCast", "com/intellij/psi/util/RedundantCastUtil$MyCollectingVisitor", "addToResults"));
            }
            if (!RedundantCastUtil.isTypeCastSemantic(typeCast)) {
                this.myFoundCasts.add(typeCast);
            }
        }
    }
}

