/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19modules;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefJavaModule;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.impl.source.PsiJavaModuleReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Java9RedundantRequiresStatementInspection
extends GlobalJavaBatchInspectionTool {
    private static final Logger LOG = Logger.getInstance(Java9RedundantRequiresStatementInspection.class);
    private static final Key<Set<String>> IMPORTED_JAVA_PACKAGES = Key.create("imported_java_packages");

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.redundant.requires.statement.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection", "checkElement"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection", "checkElement"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection", "checkElement"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection", "checkElement"));
        }
        if (refEntity instanceof RefJavaModule) {
            List<RefJavaModule.RequiredModule> requiredModules;
            Set<String> moduleImportedPackages;
            RefJavaModule refJavaModule = (RefJavaModule)refEntity;
            RefModule refModule = refJavaModule.getModule();
            PsiJavaModule psiJavaModule = refJavaModule.getElement();
            if (refModule != null && psiJavaModule != null && (moduleImportedPackages = refModule.getUserData(IMPORTED_JAVA_PACKAGES)) != null && !(requiredModules = refJavaModule.getRequiredModules()).isEmpty()) {
                ArrayList<ProblemDescriptor> descriptors = new ArrayList<ProblemDescriptor>();
                for (RefJavaModule.RequiredModule requiredModule : requiredModules) {
                    PsiRequiresStatement requiresStatement;
                    String requiredModuleName = requiredModule.moduleName;
                    if (!"java.base".equals(requiredModuleName) && !Java9RedundantRequiresStatementInspection.isDependencyUnused(requiredModule.packagesExportedByModule, moduleImportedPackages, refJavaModule.getName()) || (requiresStatement = (PsiRequiresStatement)((Object)ContainerUtil.find(psiJavaModule.getRequires(), statement -> requiredModuleName.equals(statement.getModuleName())))) == null) continue;
                    ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)requiresStatement, InspectionsBundle.message("inspection.redundant.requires.statement.description", requiredModuleName), new DeleteRedundantRequiresStatementFix(requiredModuleName, moduleImportedPackages), ProblemHighlightType.LIKE_UNUSED_SYMBOL, false);
                    descriptors.add(descriptor);
                }
                if (!ContainerUtil.isEmpty(descriptors)) {
                    return descriptors.toArray(CommonProblemDescriptor.EMPTY_ARRAY);
                }
            }
        }
        return null;
    }

    private static boolean isDependencyUnused(@NotNull Map<String, List<String>> dependencyExportedPackages, @NotNull Set<String> importedPackageNames, @NotNull String contextModuleName) {
        if (dependencyExportedPackages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyExportedPackages", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection", "isDependencyUnused"));
        }
        if (importedPackageNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedPackageNames", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection", "isDependencyUnused"));
        }
        if (contextModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextModuleName", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection", "isDependencyUnused"));
        }
        for (Map.Entry<String, List<String>> entry : dependencyExportedPackages.entrySet()) {
            String exportedPackageName = entry.getKey();
            List<String> exportedToModules = entry.getValue();
            if (!exportedToModules.isEmpty() && !exportedToModules.contains(contextModuleName) || !importedPackageNames.contains(exportedPackageName)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public RefGraphAnnotator getAnnotator(@NotNull RefManager refManager) {
        if (refManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refManager", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection", "getAnnotator"));
        }
        return new RedundantRequiresStatementAnnotator();
    }

    private static PsiJavaModule resolveRequiredModule(PsiRequiresStatement requiresStatement) {
        return PsiJavaModuleReference.resolve(requiresStatement, requiresStatement.getModuleName(), false);
    }

    private static class RedundantRequiresStatementAnnotator
    extends RefGraphAnnotator {
        private static final Set<String> DONT_COLLECT_PACKAGES = Collections.emptySet();

        private RedundantRequiresStatementAnnotator() {
        }

        @Override
        public void onReferencesBuild(RefElement refElement) {
            RefModule refModule;
            if (refElement instanceof RefFile) {
                RefFile refFile = (RefFile)refElement;
                PsiFile file = refFile.getElement();
                if (file instanceof PsiJavaFile) {
                    RedundantRequiresStatementAnnotator.onJavaFileReferencesBuilt(refFile, (PsiJavaFile)file);
                }
            } else if (refElement instanceof RefJavaModule && (refModule = refElement.getModule()) != null) {
                RedundantRequiresStatementAnnotator.setImportedPackages(refModule, refElement.getElement() != null);
            }
        }

        private static void onJavaFileReferencesBuilt(@NotNull RefFile refFile, @NotNull PsiJavaFile file) {
            Set<String> packageNames;
            RefModule refModule;
            PsiImportList importList;
            if (refFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refFile", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$RedundantRequiresStatementAnnotator", "onJavaFileReferencesBuilt"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$RedundantRequiresStatementAnnotator", "onJavaFileReferencesBuilt"));
            }
            if (file.getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_9) && (importList = file.getImportList()) != null && (refModule = refFile.getModule()) != null && (packageNames = RedundantRequiresStatementAnnotator.getImportedPackages(refModule, refFile)) != DONT_COLLECT_PACKAGES) {
                PsiImportStatementBase[] statements;
                for (PsiImportStatementBase statement : statements = importList.getAllImportStatements()) {
                    String packageName = RedundantRequiresStatementAnnotator.getPackageName(statement);
                    if (StringUtil.isEmpty(packageName)) continue;
                    packageNames.add(packageName);
                }
            }
        }

        @Nullable
        private static String getPackageName(@NotNull PsiImportStatementBase statement) {
            PsiJavaFile parentFile;
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$RedundantRequiresStatementAnnotator", "getPackageName"));
            }
            PsiElement resolved = statement.resolve();
            if (resolved instanceof PsiPackage) {
                return ((PsiPackage)resolved).getQualifiedName();
            }
            if (resolved instanceof PsiMember && (parentFile = PsiTreeUtil.getParentOfType(resolved, PsiJavaFile.class)) != null) {
                return parentFile.getPackageName();
            }
            return null;
        }

        @NotNull
        private static Set<String> getImportedPackages(@NotNull RefModule refModule, @NotNull RefFile refFile) {
            if (refModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refModule", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$RedundantRequiresStatementAnnotator", "getImportedPackages"));
            }
            if (refFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refFile", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$RedundantRequiresStatementAnnotator", "getImportedPackages"));
            }
            Set importedPackages = (Set)refModule.getUserData(IMPORTED_JAVA_PACKAGES);
            if (importedPackages == null) {
                PsiJavaModule javaModule = JavaModuleGraphUtil.findDescriptorByElement(refFile.getElement());
                importedPackages = javaModule != null ? new THashSet() : DONT_COLLECT_PACKAGES;
                refModule.putUserData(IMPORTED_JAVA_PACKAGES, importedPackages);
            }
            Set set = importedPackages;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$RedundantRequiresStatementAnnotator", "getImportedPackages"));
            }
            return set;
        }

        private static void setImportedPackages(RefModule refModule, boolean collectPackages) {
            Set importedPackages = (Set)refModule.getUserData(IMPORTED_JAVA_PACKAGES);
            if (importedPackages == null) {
                refModule.putUserData(IMPORTED_JAVA_PACKAGES, collectPackages ? new THashSet() : DONT_COLLECT_PACKAGES);
            }
        }
    }

    private static class DeleteRedundantRequiresStatementFix
    implements LocalQuickFix {
        private String myRequiredModuleName;
        private Set<String> myImportedPackages;

        public DeleteRedundantRequiresStatementFix(String requiredModuleName, Set<String> importedPackages) {
            this.myRequiredModuleName = requiredModuleName;
            this.myImportedPackages = importedPackages;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message("inspection.redundant.requires.statement.fix.family", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message("inspection.redundant.requires.statement.fix.name", this.myRequiredModuleName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "getName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                return;
            }
            LOG.assertTrue(element instanceof PsiRequiresStatement, "Should be 'requires' statement");
            PsiRequiresStatement statementToDelete = (PsiRequiresStatement)element;
            this.addTransitiveDependencies(statementToDelete);
            statementToDelete.delete();
        }

        private Set<String> getReexportedDependencies(@NotNull PsiJavaModule currentModule, @NotNull PsiJavaModule dependencyModule) {
            if (currentModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModule", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "getReexportedDependencies"));
            }
            if (dependencyModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyModule", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "getReexportedDependencies"));
            }
            Set directDependencies = ((StreamEx)StreamEx.of(currentModule.getRequires().iterator()).map(PsiRequiresStatement::getModuleName).nonNull()).toSet();
            List transitiveModules = ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(dependencyModule.getRequires().iterator()).filter(statement -> statement.hasModifierProperty("transitive"))).filter(requiresStatement -> !directDependencies.contains(requiresStatement.getModuleName()))).map(x$0 -> Java9RedundantRequiresStatementInspection.resolveRequiredModule(x$0)).nonNull()).toList();
            return ((StreamEx)StreamEx.of((Collection)transitiveModules).filter(transitiveModule -> {
                if (currentModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModule", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "lambda$getReexportedDependencies$3"));
                }
                return this.isReexported(currentModule, (PsiJavaModule)transitiveModule);
            })).map(transitiveModule -> transitiveModule.getName()).toSet();
        }

        private boolean isReexported(@NotNull PsiJavaModule currentModule, @NotNull PsiJavaModule transitiveModule) {
            if (currentModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModule", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "isReexported"));
            }
            if (transitiveModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transitiveModule", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "isReexported"));
            }
            return ((StreamEx)((StreamEx)StreamEx.of(transitiveModule.getExports().iterator()).map(PsiPackageAccessibilityStatement::getPackageName).nonNull()).filter(this.myImportedPackages::contains)).anyMatch(packageName -> {
                if (transitiveModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transitiveModule", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "lambda$isReexported$5"));
                }
                if (currentModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModule", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "lambda$isReexported$5"));
                }
                return JavaModuleGraphUtil.exports(transitiveModule, packageName, currentModule);
            });
        }

        private void addTransitiveDependencies(@NotNull PsiRequiresStatement statementToDelete) {
            if (statementToDelete == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementToDelete", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "addTransitiveDependencies"));
            }
            PsiElement parent = statementToDelete.getParent();
            if (parent instanceof PsiJavaModule) {
                PsiJavaModule currentModule = (PsiJavaModule)parent;
                Optional.of(statementToDelete).map(x$0 -> Java9RedundantRequiresStatementInspection.resolveRequiredModule(x$0)).map(dependencyModule -> this.getReexportedDependencies(currentModule, (PsiJavaModule)dependencyModule)).ifPresent(reexportedDependencies -> {
                    if (statementToDelete == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementToDelete", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "lambda$addTransitiveDependencies$8"));
                    }
                    DeleteRedundantRequiresStatementFix.addReexportedDependencies(reexportedDependencies, currentModule, statementToDelete);
                });
            }
        }

        private static void addReexportedDependencies(@NotNull Set<String> reexportedDependencies, @NotNull PsiJavaModule currentModule, @NotNull PsiElement addingPlace) {
            if (reexportedDependencies == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reexportedDependencies", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "addReexportedDependencies"));
            }
            if (currentModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModule", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "addReexportedDependencies"));
            }
            if (addingPlace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "addingPlace", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "addReexportedDependencies"));
            }
            if (!reexportedDependencies.isEmpty()) {
                PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(currentModule.getProject()).getParserFacade();
                for (String dependencyName : reexportedDependencies) {
                    PsiJavaModule tempModule = parserFacade.createModuleFromText("module " + currentModule.getName() + " { requires " + dependencyName + "; }");
                    Iterable<PsiRequiresStatement> tempModuleRequires = tempModule.getRequires();
                    PsiRequiresStatement requiresStatement = tempModuleRequires.iterator().next();
                    currentModule.addAfter(requiresStatement, addingPlace);
                }
            }
        }
    }
}

