/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.util.BitUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class RefEntityImpl
implements RefEntity {
    private volatile RefEntityImpl myOwner;
    protected List<RefEntity> myChildren;
    private final String myName;
    private Map<Key, Object> myUserMap;
    protected long myFlags;
    protected final RefManagerImpl myManager;

    RefEntityImpl(@NotNull String name, @NotNull RefManager manager) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInspection/reference/RefEntityImpl", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/reference/RefEntityImpl", "<init>"));
        }
        this.myManager = (RefManagerImpl)manager;
        this.myName = this.myManager.internName(name);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefEntityImpl", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefEntityImpl", "getQualifiedName"));
        }
        return string;
    }

    @Override
    @NotNull
    public synchronized List<RefEntity> getChildren() {
        List<RefEntity> list = ObjectUtils.notNull(this.myChildren, ContainerUtil.emptyList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefEntityImpl", "getChildren"));
        }
        return list;
    }

    @Override
    public RefEntity getOwner() {
        return this.myOwner;
    }

    protected void setOwner(@Nullable RefEntityImpl owner) {
        this.myOwner = owner;
    }

    public synchronized void add(@NotNull RefEntity child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/codeInspection/reference/RefEntityImpl", "add"));
        }
        List<RefEntity> children = this.myChildren;
        if (children == null) {
            this.myChildren = children = new ArrayList<RefEntity>(1);
        }
        children.add(child);
        ((RefEntityImpl)child).setOwner(this);
    }

    protected synchronized void removeChild(@NotNull RefEntity child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/codeInspection/reference/RefEntityImpl", "removeChild"));
        }
        if (this.myChildren != null) {
            this.myChildren.remove(child);
            ((RefEntityImpl)child).setOwner(null);
        }
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/reference/RefEntityImpl", "getUserData"));
        }
        RefEntityImpl refEntityImpl = this;
        synchronized (refEntityImpl) {
            if (this.myUserMap == null) {
                return null;
            }
            return (T)this.myUserMap.get(key);
        }
    }

    @Override
    public void accept(@NotNull RefVisitor refVisitor) {
        if (refVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refVisitor", "com/intellij/codeInspection/reference/RefEntityImpl", "accept"));
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (refVisitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refVisitor", "com/intellij/codeInspection/reference/RefEntityImpl", "lambda$accept$0"));
            }
            refVisitor.visitElement(this);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void putUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/reference/RefEntityImpl", "putUserData"));
        }
        RefEntityImpl refEntityImpl = this;
        synchronized (refEntityImpl) {
            THashMap userMap = this.myUserMap;
            if (userMap == null) {
                if (value == null) {
                    return;
                }
                this.myUserMap = userMap = new THashMap();
            }
            if (value != null) {
                userMap.put(key, value);
            } else {
                userMap.remove(key);
                if (userMap.isEmpty()) {
                    this.myUserMap = null;
                }
            }
        }
    }

    public synchronized boolean checkFlag(long mask) {
        return BitUtil.isSet(this.myFlags, mask);
    }

    public synchronized void setFlag(boolean value, long mask) {
        this.myFlags = BitUtil.set(this.myFlags, mask, value);
    }

    @Override
    public String getExternalName() {
        return this.myName;
    }

    @Override
    @NotNull
    public RefManagerImpl getRefManager() {
        RefManagerImpl refManagerImpl = this.myManager;
        if (refManagerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefEntityImpl", "getRefManager"));
        }
        return refManagerImpl;
    }
}

