/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.Nullable;

public abstract class IndexedContainer {
    private final PsiExpression myQualifier;

    protected IndexedContainer(PsiExpression qualifier) {
        this.myQualifier = PsiUtil.skipParenthesizedExprDown(qualifier);
    }

    public abstract boolean isGetMethodReference(PsiMethodReferenceExpression var1);

    public abstract PsiExpression extractGetExpressionFromIndex(@Nullable PsiExpression var1);

    public abstract PsiExpression extractIndexFromGetExpression(@Nullable PsiExpression var1);

    public PsiExpression getQualifier() {
        return this.myQualifier;
    }

    public boolean isQualifierEquivalent(@Nullable PsiExpression candidate) {
        return (candidate = PsiUtil.skipParenthesizedExprDown(candidate)) != null && PsiEquivalenceUtil.areElementsEquivalent(this.myQualifier, candidate);
    }

    public abstract PsiType getElementType();

    @Nullable
    public static IndexedContainer fromLengthExpression(@Nullable PsiExpression expression) {
        PsiMethodCallExpression call;
        PsiExpression arrayExpression = ExpressionUtils.getArrayFromLengthExpression(expression = PsiUtil.skipParenthesizedExprDown(expression));
        if (arrayExpression != null) {
            return new ArrayIndexedContainer(arrayExpression);
        }
        if (expression instanceof PsiMethodCallExpression && ListIndexedContainer.isSizeCall(call = (PsiMethodCallExpression)expression)) {
            return new ListIndexedContainer(ExpressionUtils.getQualifierOrThis(call.getMethodExpression()));
        }
        return null;
    }

    static class ListIndexedContainer
    extends IndexedContainer {
        ListIndexedContainer(PsiExpression qualifier) {
            super(qualifier);
        }

        @Override
        public boolean isGetMethodReference(PsiMethodReferenceExpression methodReference) {
            if (!"get".equals(methodReference.getReferenceName())) {
                return false;
            }
            if (!this.isQualifierEquivalent(ExpressionUtils.getQualifierOrThis(methodReference))) {
                return false;
            }
            PsiMethod method = ObjectUtils.tryCast(methodReference.resolve(), PsiMethod.class);
            return method != null && MethodUtils.methodMatches(method, "java.util.List", null, "get", PsiType.INT);
        }

        @Override
        public PsiExpression extractGetExpressionFromIndex(@Nullable PsiExpression indexExpression) {
            PsiElement gParent;
            PsiElement parent;
            if (indexExpression != null && (parent = PsiUtil.skipParenthesizedExprUp(indexExpression.getParent())) instanceof PsiExpressionList && (gParent = PsiUtil.skipParenthesizedExprUp(parent.getParent())) instanceof PsiMethodCallExpression && PsiTreeUtil.isAncestor(this.extractIndexFromGetExpression((PsiExpression)gParent), indexExpression, false)) {
                return (PsiExpression)gParent;
            }
            return null;
        }

        @Override
        public PsiExpression extractIndexFromGetExpression(@Nullable PsiExpression expression) {
            PsiMethodCallExpression call = ObjectUtils.tryCast(PsiUtil.skipParenthesizedExprDown(expression), PsiMethodCallExpression.class);
            if (call == null) {
                return null;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length == 1 && ListIndexedContainer.isGetCall(call) && this.isQualifierEquivalent(ExpressionUtils.getQualifierOrThis(call.getMethodExpression()))) {
                return args[0];
            }
            return null;
        }

        @Override
        public PsiType getElementType() {
            PsiType type = PsiUtil.substituteTypeParameter(this.getQualifier().getType(), "java.util.List", 0, false);
            return GenericsUtil.getVariableTypeByExpressionType(type);
        }

        static boolean isGetCall(PsiMethodCallExpression call) {
            return MethodCallUtils.isCallToMethod(call, "java.util.List", null, "get", PsiType.INT);
        }

        static boolean isSizeCall(PsiMethodCallExpression call) {
            return MethodCallUtils.isCallToMethod(call, "java.util.List", (PsiType)PsiType.INT, "size", new PsiType[0]);
        }
    }

    static class ArrayIndexedContainer
    extends IndexedContainer {
        ArrayIndexedContainer(PsiExpression qualifier) {
            super(qualifier);
        }

        @Override
        public boolean isGetMethodReference(PsiMethodReferenceExpression methodReference) {
            return false;
        }

        @Override
        public PsiExpression extractGetExpressionFromIndex(@Nullable PsiExpression indexExpression) {
            PsiElement parent;
            if (indexExpression != null && (parent = PsiUtil.skipParenthesizedExprUp(indexExpression.getParent())) instanceof PsiExpression && PsiTreeUtil.isAncestor(this.extractIndexFromGetExpression((PsiExpression)parent), indexExpression, false)) {
                return (PsiExpression)parent;
            }
            return null;
        }

        @Override
        public PsiExpression extractIndexFromGetExpression(@Nullable PsiExpression expression) {
            PsiArrayAccessExpression arrayAccess;
            if ((expression = PsiUtil.skipParenthesizedExprDown(expression)) instanceof PsiArrayAccessExpression && this.isQualifierEquivalent((arrayAccess = (PsiArrayAccessExpression)expression).getArrayExpression())) {
                return arrayAccess.getIndexExpression();
            }
            return null;
        }

        @Override
        public PsiType getElementType() {
            PsiType type = this.getQualifier().getType();
            return type instanceof PsiArrayType ? ((PsiArrayType)type).getComponentType() : null;
        }
    }
}

