/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class DeprecatedIsStillUsedInspection
extends LocalInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/DeprecatedIsStillUsedInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInspection/DeprecatedIsStillUsedInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitIdentifier(PsiIdentifier identifier) {
                PsiElement parent = identifier.getParent();
                if (parent instanceof PsiMember && parent instanceof PsiNameIdentifierOwner && ((PsiNameIdentifierOwner)parent).getNameIdentifier() == identifier) {
                    DeprecatedIsStillUsedInspection.checkMember((PsiMember)parent, identifier, holder);
                }
                super.visitIdentifier(identifier);
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/DeprecatedIsStillUsedInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static void checkMember(@NotNull PsiMember member, @NotNull PsiIdentifier identifier, @NotNull ProblemsHolder holder) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInspection/DeprecatedIsStillUsedInspection", "checkMember"));
        }
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/codeInspection/DeprecatedIsStillUsedInspection", "checkMember"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/DeprecatedIsStillUsedInspection", "checkMember"));
        }
        if (!(member instanceof PsiDocCommentOwner) || !DeprecatedIsStillUsedInspection.isDeprecated((PsiDocCommentOwner)member)) {
            return;
        }
        PsiSearchHelper searchHelper = PsiSearchHelper.SERVICE.getInstance(member.getProject());
        String name = member.getName();
        if (name != null && DeprecatedIsStillUsedInspection.hasUsages(member, name, searchHelper, member.getResolveScope())) {
            holder.registerProblem((PsiElement)identifier, "Deprecated member '" + name + "' is still used", new LocalQuickFix[0]);
        }
    }

    private static boolean isDeprecated(PsiDocCommentOwner element) {
        return element.isDeprecated();
    }

    private static boolean hasUsages(@NotNull PsiElement element, @NotNull String name, @NotNull PsiSearchHelper psiSearchHelper, @NotNull GlobalSearchScope searchScope) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/DeprecatedIsStillUsedInspection", "hasUsages"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInspection/DeprecatedIsStillUsedInspection", "hasUsages"));
        }
        if (psiSearchHelper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiSearchHelper", "com/intellij/codeInspection/DeprecatedIsStillUsedInspection", "hasUsages"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/codeInspection/DeprecatedIsStillUsedInspection", "hasUsages"));
        }
        PsiSearchHelper.SearchCostResult cheapEnough = psiSearchHelper.isCheapEnoughToSearch(name, searchScope, null, null);
        if (cheapEnough == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES || cheapEnough == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
            return false;
        }
        return !ReferencesSearch.search(element, searchScope, false).forEach(reference -> {
            PsiElement referenceElement = reference.getElement();
            return DeprecatedIsStillUsedInspection.isInsideDeprecated(referenceElement);
        });
    }

    private static boolean isInsideDeprecated(PsiElement element) {
        PsiElement parent = element;
        while ((parent = PsiTreeUtil.getParentOfType(parent, PsiDocCommentOwner.class, true)) != null) {
            if (!((PsiDocCommentOwner)parent).isDeprecated()) continue;
            return true;
        }
        return false;
    }
}

