/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefEntityImpl;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RefElementImpl
extends RefEntityImpl
implements RefElement {
    protected static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.reference.RefElement");
    private static final int IS_ENTRY_MASK = 128;
    private static final int IS_PERMANENT_ENTRY_MASK = 256;
    private final SmartPsiElementPointer myID;
    private List<RefElement> myOutReferences;
    private List<RefElement> myInReferences;
    private String[] mySuppressions;
    private volatile boolean myIsDeleted;
    protected static final int IS_REACHABLE_MASK = 64;

    protected RefElementImpl(@NotNull String name, @NotNull RefElement owner) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInspection/reference/RefElementImpl", "<init>"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/reference/RefElementImpl", "<init>"));
        }
        super(name, owner.getRefManager());
        this.myID = null;
        this.myFlags = 0L;
    }

    protected RefElementImpl(PsiFile file, RefManager manager) {
        this(file.getName(), file, manager);
    }

    protected RefElementImpl(@NotNull String name, @NotNull PsiElement element, @NotNull RefManager manager) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInspection/reference/RefElementImpl", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/reference/RefElementImpl", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/reference/RefElementImpl", "<init>"));
        }
        super(name, manager);
        this.myID = SmartPointerManager.getInstance(manager.getProject()).createSmartPsiElementPointer(element);
        this.myFlags = 0L;
    }

    protected boolean isDeleted() {
        return this.myIsDeleted;
    }

    @Override
    public boolean isValid() {
        if (this.myIsDeleted) {
            return false;
        }
        return ReadAction.compute(() -> {
            if (this.getRefManager().getProject().isDisposed()) {
                return false;
            }
            PsiFile file = this.myID.getContainingFile();
            if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                return file != null && file.isPhysical();
            }
            PsiElement element = this.getElement();
            return element != null && element.isPhysical();
        });
    }

    @Override
    @Nullable
    public Icon getIcon(boolean expanded) {
        PsiElement element = this.getElement();
        if (element != null && element.isValid()) {
            return element.getIcon(3);
        }
        return null;
    }

    @Override
    public RefModule getModule() {
        RefEntity owner = this.getOwner();
        return owner instanceof RefElement ? ((RefElement)owner).getModule() : null;
    }

    @Override
    public String getExternalName() {
        return this.getName();
    }

    @Override
    @Nullable
    public PsiElement getElement() {
        return this.myID.getElement();
    }

    @Nullable
    public PsiFile getContainingFile() {
        return this.myID.getContainingFile();
    }

    public VirtualFile getVirtualFile() {
        return this.myID.getVirtualFile();
    }

    @Override
    public SmartPsiElementPointer getPointer() {
        return this.myID;
    }

    public void buildReferences() {
    }

    @Override
    public boolean isReachable() {
        return this.checkFlag(64L);
    }

    @Override
    public boolean isReferenced() {
        return !this.getInReferences().isEmpty();
    }

    public boolean hasSuspiciousCallers() {
        for (RefElement refCaller : this.getInReferences()) {
            if (!((RefElementImpl)refCaller).isSuspicious()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public synchronized Collection<RefElement> getOutReferences() {
        Collection collection = ObjectUtils.notNull(this.myOutReferences, ContainerUtil.emptyList());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefElementImpl", "getOutReferences"));
        }
        return collection;
    }

    @Override
    @NotNull
    public synchronized Collection<RefElement> getInReferences() {
        Collection collection = ObjectUtils.notNull(this.myInReferences, ContainerUtil.emptyList());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefElementImpl", "getInReferences"));
        }
        return collection;
    }

    synchronized void addInReference(RefElement refElement) {
        List<RefElement> inReferences = this.myInReferences;
        if (inReferences == null) {
            this.myInReferences = inReferences = new ArrayList<RefElement>(1);
        }
        if (!inReferences.contains(refElement)) {
            inReferences.add(refElement);
        }
    }

    synchronized void addOutReference(RefElement refElement) {
        List<RefElement> outReferences = this.myOutReferences;
        if (outReferences == null) {
            this.myOutReferences = outReferences = new ArrayList<RefElement>(1);
        }
        if (!outReferences.contains(refElement)) {
            outReferences.add(refElement);
        }
    }

    public void setEntry(boolean entry) {
        this.setFlag(entry, 128L);
    }

    @Override
    public boolean isEntry() {
        return this.checkFlag(128L);
    }

    @Override
    public boolean isPermanentEntry() {
        return this.checkFlag(256L);
    }

    @Override
    @NotNull
    public RefElement getContainingEntry() {
        RefElementImpl refElementImpl = this;
        if (refElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefElementImpl", "getContainingEntry"));
        }
        return refElementImpl;
    }

    public void setPermanentEntry(boolean permanentEntry) {
        this.setFlag(permanentEntry, 256L);
    }

    public boolean isSuspicious() {
        return !this.isReachable();
    }

    public void referenceRemoved() {
        this.myIsDeleted = true;
        if (this.getOwner() != null) {
            ((RefEntityImpl)this.getOwner()).removeChild(this);
        }
        for (RefElement refCallee : this.getOutReferences()) {
            refCallee.getInReferences().remove(this);
        }
        for (RefElement refCaller : this.getInReferences()) {
            refCaller.getOutReferences().remove(this);
        }
    }

    @Nullable
    public String getURL() {
        PsiElement element = this.getElement();
        if (element == null || !element.isPhysical()) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        return virtualFile.getUrl() + "#" + element.getTextOffset();
    }

    protected abstract void initialize();

    void addSuppression(String text2) {
        this.mySuppressions = text2.split("[, ]");
    }

    public boolean isSuppressed(String ... toolId) {
        RefEntity entity;
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInspection/reference/RefElementImpl", "isSuppressed"));
        }
        if (this.mySuppressions != null) {
            for (String suppression : this.mySuppressions) {
                for (String id : toolId) {
                    if (!suppression.equals(id)) continue;
                    return true;
                }
                if (!suppression.equalsIgnoreCase("ALL")) continue;
                return true;
            }
        }
        return (entity = this.getOwner()) instanceof RefElementImpl && ((RefElementImpl)entity).isSuppressed(toolId);
    }
}

