/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.components.PathMacroMap;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ExpandMacroToPathMap
extends PathMacroMap {
    private final Map<String, String> myPlainMap = ContainerUtilRt.newLinkedHashMap();
    private final Map<String, String> myMacroExpands = ContainerUtil.newHashMap();

    public void addMacroExpand(@NotNull String macroName, @NotNull String path) {
        if (macroName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "macroName", "com/intellij/openapi/components/ExpandMacroToPathMap", "addMacroExpand"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/components/ExpandMacroToPathMap", "addMacroExpand"));
        }
        this.myMacroExpands.put(macroName, FileUtil.toSystemIndependentName(path));
    }

    public void put(@NotNull String fromText, @NotNull String toText) {
        if (fromText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromText", "com/intellij/openapi/components/ExpandMacroToPathMap", "put"));
        }
        if (toText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toText", "com/intellij/openapi/components/ExpandMacroToPathMap", "put"));
        }
        this.myPlainMap.put(fromText, toText);
    }

    public void putAll(@NotNull ExpandMacroToPathMap another) {
        if (another == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "another", "com/intellij/openapi/components/ExpandMacroToPathMap", "putAll"));
        }
        this.myPlainMap.putAll(another.myPlainMap);
        this.myMacroExpands.putAll(another.myMacroExpands);
    }

    @Override
    public String substitute(String text2, boolean caseSensitive) {
        if (text2 == null) {
            return null;
        }
        if (text2.indexOf(36) < 0 && text2.indexOf(37) < 0) {
            return text2;
        }
        for (Map.Entry<String, String> entry : this.myPlainMap.entrySet()) {
            text2 = StringUtil.replace(text2, entry.getKey(), entry.getValue(), false);
        }
        for (String macroName : this.myMacroExpands.keySet()) {
            text2 = ExpandMacroToPathMap.replaceMacro(text2, macroName, this.myMacroExpands.get(macroName));
        }
        return text2;
    }

    @NotNull
    private static String replaceMacro(@NotNull String text2, @NotNull String macroName, @NotNull String replacement) {
        int start;
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/components/ExpandMacroToPathMap", "replaceMacro"));
        }
        if (macroName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "macroName", "com/intellij/openapi/components/ExpandMacroToPathMap", "replaceMacro"));
        }
        if (replacement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacement", "com/intellij/openapi/components/ExpandMacroToPathMap", "replaceMacro"));
        }
        while ((start = ExpandMacroToPathMap.findMacroIndex(text2, macroName)) >= 0) {
            int end = start + macroName.length() + 2;
            int slashCount = ExpandMacroToPathMap.getSlashCount(text2, end);
            String actualReplacement = slashCount > 0 && !replacement.endsWith("/") ? replacement + "/" : replacement;
            text2 = StringUtil.replaceSubstring(text2, new TextRange(start, end + slashCount), actualReplacement);
        }
        String string = text2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/ExpandMacroToPathMap", "replaceMacro"));
        }
        return string;
    }

    private static int getSlashCount(@NotNull String text2, int pos) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/components/ExpandMacroToPathMap", "getSlashCount"));
        }
        return StringUtil.isChar(text2, pos, '/') ? (StringUtil.isChar(text2, pos + 1, '/') ? 2 : 1) : 0;
    }

    private static int findMacroIndex(@NotNull String text2, @NotNull String macroName) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/components/ExpandMacroToPathMap", "findMacroIndex"));
        }
        if (macroName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "macroName", "com/intellij/openapi/components/ExpandMacroToPathMap", "findMacroIndex"));
        }
        int i2 = -1;
        do {
            if ((i2 = text2.indexOf(36, i2 + 1)) >= 0) continue;
            return -1;
        } while (!StringUtil.startsWith(text2, i2 + 1, macroName) || !StringUtil.isChar(text2, i2 + macroName.length() + 1, '$'));
        return i2;
    }

    @Override
    public int hashCode() {
        return this.myPlainMap.hashCode() + this.myMacroExpands.hashCode();
    }
}

