/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Queue;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class ModuleWithDependentsScope
extends GlobalSearchScope {
    private final Module myModule;
    private final ProjectFileIndex myProjectFileIndex;
    private final Set<Module> myModules;
    private final GlobalSearchScope myProjectScope;

    ModuleWithDependentsScope(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/module/impl/scopes/ModuleWithDependentsScope", "<init>"));
        }
        super(module.getProject());
        this.myModule = module;
        this.myProjectFileIndex = ProjectRootManager.getInstance(module.getProject()).getFileIndex();
        this.myProjectScope = ProjectScope.getProjectScope(module.getProject());
        this.myModules = ModuleWithDependentsScope.buildDependents(this.myModule);
    }

    private static Set<Module> buildDependents(Module module) {
        THashSet result = new THashSet();
        result.add(module);
        THashSet processedExporting = new THashSet();
        ModuleIndex index = ModuleWithDependentsScope.getModuleIndex(module.getProject());
        Queue<Module> walkingQueue = new Queue<Module>(10);
        walkingQueue.addLast(module);
        while (!walkingQueue.isEmpty()) {
            Module current = (Module)walkingQueue.pullFirst();
            processedExporting.add(current);
            result.addAll(index.plainUsages.get(current));
            for (Module dependent : index.exportingUsages.get(current)) {
                result.add(dependent);
                if (!processedExporting.add(dependent)) continue;
                walkingQueue.addLast(dependent);
            }
        }
        return result;
    }

    private static ModuleIndex getModuleIndex(Project project) {
        return (ModuleIndex)CachedValuesManager.getManager(project).getCachedValue(project, () -> {
            ModuleIndex index = new ModuleIndex();
            for (Module module : ModuleManager.getInstance(project).getModules()) {
                for (OrderEntry orderEntry : ModuleRootManager.getInstance(module).getOrderEntries()) {
                    Module referenced;
                    if (!(orderEntry instanceof ModuleOrderEntry) || (referenced = ((ModuleOrderEntry)orderEntry).getModule()) == null) continue;
                    MultiMap<Module, Module> map = ((ModuleOrderEntry)orderEntry).isExported() ? index.exportingUsages : index.plainUsages;
                    map.putValue(referenced, module);
                }
            }
            return CachedValueProvider.Result.create(index, ProjectRootManager.getInstance(project));
        });
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/module/impl/scopes/ModuleWithDependentsScope", "contains"));
        }
        return this.contains(file, false);
    }

    boolean contains(@NotNull VirtualFile file, boolean myOnlyTests) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/module/impl/scopes/ModuleWithDependentsScope", "contains"));
        }
        Module moduleOfFile = this.myProjectFileIndex.getModuleForFile(file);
        if (moduleOfFile == null || !this.myModules.contains(moduleOfFile)) {
            return false;
        }
        if (myOnlyTests && !TestSourcesFilter.isTestSources(file, moduleOfFile.getProject())) {
            return false;
        }
        return this.myProjectScope.contains(file);
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/openapi/module/impl/scopes/ModuleWithDependentsScope", "compare"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/openapi/module/impl/scopes/ModuleWithDependentsScope", "compare"));
        }
        return 0;
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/openapi/module/impl/scopes/ModuleWithDependentsScope", "isSearchInModuleContent"));
        }
        return this.myModules.contains(aModule);
    }

    @Override
    public boolean isSearchInLibraries() {
        return false;
    }

    @Override
    public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        ModuleManager moduleManager = ModuleManager.getInstance(this.myModule.getProject());
        return ContainerUtil.mapNotNull(DirectoryIndex.getInstance(this.myModule.getProject()).getDependentUnloadedModules(this.myModule), moduleManager::getUnloadedModuleDescription);
    }

    @NonNls
    public String toString() {
        return "Module with dependents:" + this.myModule.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleWithDependentsScope)) {
            return false;
        }
        ModuleWithDependentsScope moduleWithDependentsScope = (ModuleWithDependentsScope)o;
        return this.myModule.equals(moduleWithDependentsScope.myModule);
    }

    @Override
    public int hashCode() {
        return this.myModule.hashCode();
    }

    private static class ModuleIndex {
        final MultiMap<Module, Module> plainUsages = MultiMap.create();
        final MultiMap<Module, Module> exportingUsages = MultiMap.create();

        private ModuleIndex() {
        }
    }
}

