/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.packageSet.InvalidPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NamedScopesHolder
implements PersistentStateComponent<Element> {
    private List<NamedScope> myScopes;
    @NonNls
    private static final String SCOPE_TAG = "scope";
    @NonNls
    private static final String NAME_ATT = "name";
    @NonNls
    private static final String PATTERN_ATT = "pattern";
    protected final Project myProject;
    private VirtualFile myProjectBaseDir;
    private final List<ScopeListener> myScopeListeners;

    public NamedScopesHolder(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/scope/packageSet/NamedScopesHolder", "<init>"));
        }
        this.myScopes = new ArrayList<NamedScope>();
        this.myScopeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
    }

    public abstract String getDisplayName();

    public abstract Icon getIcon();

    public VirtualFile getProjectBaseDir() {
        if (this.myProjectBaseDir == null) {
            this.myProjectBaseDir = this.myProject.getBaseDir();
        }
        return this.myProjectBaseDir;
    }

    public void addScopeListener(@NotNull ScopeListener scopeListener) {
        if (scopeListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeListener", "com/intellij/psi/search/scope/packageSet/NamedScopesHolder", "addScopeListener"));
        }
        this.myScopeListeners.add(scopeListener);
    }

    public void removeScopeListener(@NotNull ScopeListener scopeListener) {
        if (scopeListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeListener", "com/intellij/psi/search/scope/packageSet/NamedScopesHolder", "removeScopeListener"));
        }
        this.myScopeListeners.remove(scopeListener);
    }

    public void fireScopeListeners() {
        for (ScopeListener listener : this.myScopeListeners) {
            listener.scopesChanged();
        }
    }

    @NotNull
    public NamedScope[] getScopes() {
        ArrayList<NamedScope> scopes = new ArrayList<NamedScope>();
        List<NamedScope> list = this.getPredefinedScopes();
        scopes.addAll(list);
        scopes.addAll(this.myScopes);
        NamedScope[] namedScopeArray = scopes.toArray(new NamedScope[scopes.size()]);
        if (namedScopeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/scope/packageSet/NamedScopesHolder", "getScopes"));
        }
        return namedScopeArray;
    }

    @NotNull
    public NamedScope[] getEditableScopes() {
        NamedScope[] namedScopeArray = this.myScopes.toArray(new NamedScope[this.myScopes.size()]);
        if (namedScopeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/scope/packageSet/NamedScopesHolder", "getEditableScopes"));
        }
        return namedScopeArray;
    }

    public void removeAllSets() {
        this.myScopes.clear();
        this.fireScopeListeners();
    }

    public void setScopes(NamedScope[] scopes) {
        this.myScopes = new ArrayList<NamedScope>(Arrays.asList(scopes));
        this.fireScopeListeners();
    }

    public void addScope(NamedScope scope) {
        this.myScopes.add(scope);
        this.fireScopeListeners();
    }

    @Nullable
    public static NamedScope getScope(@NotNull Project project, String scopeName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/scope/packageSet/NamedScopesHolder", "getScope"));
        }
        for (NamedScopesHolder holder : NamedScopesHolder.getAllNamedScopeHolders(project)) {
            NamedScope scope = holder.getScope(scopeName);
            if (scope == null) continue;
            return scope;
        }
        return null;
    }

    @NotNull
    public static NamedScopesHolder[] getAllNamedScopeHolders(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/scope/packageSet/NamedScopesHolder", "getAllNamedScopeHolders"));
        }
        NamedScopesHolder[] holders = new NamedScopesHolder[]{NamedScopeManager.getInstance(project), DependencyValidationManager.getInstance(project)};
        if (holders == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/scope/packageSet/NamedScopesHolder", "getAllNamedScopeHolders"));
        }
        return holders;
    }

    @Nullable
    public static NamedScopesHolder getHolder(Project project, String scopeName, NamedScopesHolder defaultHolder) {
        NamedScopesHolder[] holders;
        for (NamedScopesHolder holder : holders = NamedScopesHolder.getAllNamedScopeHolders(project)) {
            NamedScope scope = holder.getScope(scopeName);
            if (scope == null) continue;
            return holder;
        }
        return defaultHolder;
    }

    private static Element writeScope(NamedScope scope) {
        Element setElement = new Element(SCOPE_TAG);
        setElement.setAttribute(NAME_ATT, scope.getName());
        PackageSet packageSet = scope.getValue();
        setElement.setAttribute(PATTERN_ATT, packageSet != null ? packageSet.getText() : "");
        return setElement;
    }

    private static NamedScope readScope(Element setElement) {
        PackageSet set;
        String name = setElement.getAttributeValue(NAME_ATT);
        String attributeValue = setElement.getAttributeValue(PATTERN_ATT);
        try {
            set = PackageSetFactory.getInstance().compile(attributeValue);
        }
        catch (ParsingException e) {
            set = new InvalidPackageSet(attributeValue);
        }
        return new NamedScope(name, set);
    }

    @Override
    public void loadState(Element state) {
        this.myScopes.clear();
        List sets = state.getChildren(SCOPE_TAG);
        for (Element set : sets) {
            this.myScopes.add(NamedScopesHolder.readScope(set));
        }
        this.fireScopeListeners();
    }

    @Override
    public Element getState() {
        Element element = new Element("state");
        for (NamedScope myScope : this.myScopes) {
            element.addContent(NamedScopesHolder.writeScope(myScope));
        }
        return element;
    }

    @Nullable
    public NamedScope getScope(@Nullable String name) {
        if (name == null) {
            return null;
        }
        for (NamedScope scope : this.myScopes) {
            if (!name.equals(scope.getName())) continue;
            return scope;
        }
        return this.getPredefinedScope(name);
    }

    @NotNull
    public List<NamedScope> getPredefinedScopes() {
        List<NamedScope> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/scope/packageSet/NamedScopesHolder", "getPredefinedScopes"));
        }
        return list;
    }

    @Nullable
    public NamedScope getPredefinedScope(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME_ATT, "com/intellij/psi/search/scope/packageSet/NamedScopesHolder", "getPredefinedScope"));
        }
        return null;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/scope/packageSet/NamedScopesHolder", "getProject"));
        }
        return project;
    }

    public static interface ScopeListener {
        public void scopesChanged();
    }
}

