/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class SingletonUtil {
    private SingletonUtil() {
    }

    public static boolean isSingleton(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/psiutils/SingletonUtil", "isSingleton"));
        }
        if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
            return false;
        }
        if (aClass instanceof PsiTypeParameter || aClass instanceof PsiAnonymousClass) {
            return false;
        }
        PsiMethod[] constructors = SingletonUtil.getIfOnlyInvisibleConstructors(aClass);
        if (constructors.length == 0) {
            return false;
        }
        PsiField selfInstance = SingletonUtil.getIfOneStaticSelfInstance(aClass);
        return selfInstance != null && SingletonUtil.newOnlyAssignsToStaticSelfInstance(constructors[0], selfInstance);
    }

    private static PsiField getIfOneStaticSelfInstance(PsiClass aClass) {
        Stream<PsiField> fieldStream = Stream.concat(Arrays.stream(aClass.getFields()), Arrays.stream(aClass.getInnerClasses()).filter(innerClass -> innerClass.hasModifierProperty("static")).flatMap(innerClass -> Arrays.stream(innerClass.getFields())));
        List fields = fieldStream.filter(field -> SingletonUtil.resolveToSingletonField(aClass, field)).limit(2L).collect(Collectors.toList());
        return fields.size() == 1 ? (PsiField)fields.get(0) : null;
    }

    private static boolean resolveToSingletonField(PsiClass aClass, PsiField field) {
        if (!field.hasModifierProperty("static")) {
            return false;
        }
        PsiType type = field.getType();
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass targetClass = classType.resolve();
        return aClass.equals(targetClass);
    }

    @NotNull
    private static PsiMethod[] getIfOnlyInvisibleConstructors(PsiClass aClass) {
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/SingletonUtil", "getIfOnlyInvisibleConstructors"));
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        for (PsiMethod constructor : constructors) {
            if (constructor.hasModifierProperty("public")) {
                if (PsiMethod.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/SingletonUtil", "getIfOnlyInvisibleConstructors"));
                }
                return PsiMethod.EMPTY_ARRAY;
            }
            if (constructor.hasModifierProperty("private") || constructor.hasModifierProperty("protected")) continue;
            if (PsiMethod.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/SingletonUtil", "getIfOnlyInvisibleConstructors"));
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        if (constructors == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/SingletonUtil", "getIfOnlyInvisibleConstructors"));
        }
        return constructors;
    }

    private static boolean newOnlyAssignsToStaticSelfInstance(PsiMethod method, PsiField field) {
        Query<PsiReference> search = MethodReferencesSearch.search(method, field.getUseScope(), false);
        NewOnlyAssignedToFieldProcessor processor = new NewOnlyAssignedToFieldProcessor(field);
        search.forEach(processor);
        return processor.isNewOnlyAssignedToField();
    }

    private static class NewOnlyAssignedToFieldProcessor
    implements Processor<PsiReference> {
        private boolean newOnlyAssignedToField = true;
        private final PsiField field;

        public NewOnlyAssignedToFieldProcessor(PsiField field) {
            this.field = field;
        }

        @Override
        public boolean process(PsiReference reference) {
            PsiElement element = reference.getElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiNewExpression)) {
                this.newOnlyAssignedToField = false;
                return false;
            }
            PsiElement grandParent = parent.getParent();
            if (this.field.equals(grandParent)) {
                return true;
            }
            if (!(grandParent instanceof PsiAssignmentExpression)) {
                this.newOnlyAssignedToField = false;
                return false;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)grandParent;
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                this.newOnlyAssignedToField = false;
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement target = referenceExpression.resolve();
            if (!this.field.equals(target)) {
                this.newOnlyAssignedToField = false;
                return false;
            }
            return true;
        }

        public boolean isNewOnlyAssignedToField() {
            return this.newOnlyAssignedToField;
        }
    }
}

