/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.MainHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorHighlightingPassRegistrarImpl
extends TextEditorHighlightingPassRegistrarEx {
    private final TIntObjectHashMap<PassConfig> myRegisteredPassFactories = new TIntObjectHashMap();
    private final List<DirtyScopeTrackingHighlightingPassFactory> myDirtyScopeTrackingFactories = new ArrayList<DirtyScopeTrackingHighlightingPassFactory>();
    private int nextAvailableId = 13;
    private boolean checkedForCycles;
    private final Project myProject;

    public TextEditorHighlightingPassRegistrarImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public void registerTextEditorHighlightingPass(TextEditorHighlightingPassFactory factory, int anchor, int anchorPass) {
        TextEditorHighlightingPassRegistrar.Anchor anc = TextEditorHighlightingPassRegistrar.Anchor.FIRST;
        switch (anchor) {
            case 0: {
                anc = TextEditorHighlightingPassRegistrar.Anchor.FIRST;
                break;
            }
            case 1: {
                anc = TextEditorHighlightingPassRegistrar.Anchor.LAST;
                break;
            }
            case 3: {
                anc = TextEditorHighlightingPassRegistrar.Anchor.BEFORE;
                break;
            }
            case 2: {
                anc = TextEditorHighlightingPassRegistrar.Anchor.AFTER;
            }
        }
        this.registerTextEditorHighlightingPass(factory, anc, anchorPass, true, true);
    }

    @Override
    public synchronized int registerTextEditorHighlightingPass(@NotNull TextEditorHighlightingPassFactory factory, @Nullable int[] runAfterCompletionOf, @Nullable int[] runAfterOfStartingOf, boolean runIntentionsPassAfter, int forcedPassId) {
        int n;
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl", "registerTextEditorHighlightingPass"));
        }
        assert (!this.checkedForCycles);
        PassConfig info = new PassConfig(factory, runAfterCompletionOf == null || runAfterCompletionOf.length == 0 ? ArrayUtil.EMPTY_INT_ARRAY : runAfterCompletionOf, runAfterOfStartingOf == null || runAfterOfStartingOf.length == 0 ? ArrayUtil.EMPTY_INT_ARRAY : runAfterOfStartingOf);
        if (forcedPassId == -1) {
            int n2 = this.nextAvailableId;
            n = n2;
            this.nextAvailableId = n2 + 1;
        } else {
            n = forcedPassId;
        }
        int passId = n;
        PassConfig registered = (PassConfig)this.myRegisteredPassFactories.get(passId);
        assert (registered == null) : "Pass id " + passId + " has already been registered in: " + PassConfig.access$100(registered);
        this.myRegisteredPassFactories.put(passId, (Object)info);
        if (factory instanceof DirtyScopeTrackingHighlightingPassFactory) {
            this.myDirtyScopeTrackingFactories.add((DirtyScopeTrackingHighlightingPassFactory)factory);
        }
        return passId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<TextEditorHighlightingPass> instantiatePasses(@NotNull PsiFile psiFile, @NotNull Editor editor, @NotNull int[] passesToIgnore) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl", "instantiatePasses"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl", "instantiatePasses"));
        }
        if (passesToIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "passesToIgnore", "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl", "instantiatePasses"));
        }
        TextEditorHighlightingPassRegistrarImpl textEditorHighlightingPassRegistrarImpl = this;
        synchronized (textEditorHighlightingPassRegistrarImpl) {
            if (!this.checkedForCycles) {
                this.checkedForCycles = true;
                this.checkForCycles();
            }
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(this.myProject);
        Document document = editor.getDocument();
        PsiFile fileFromDoc = documentManager.getPsiFile(document);
        if (!(fileFromDoc instanceof PsiCompiledElement)) {
            assert (fileFromDoc == psiFile) : "Files are different: " + psiFile + ";" + fileFromDoc;
            Document documentFromFile = documentManager.getDocument(psiFile);
            assert (documentFromFile == document) : "Documents are different. Doc: " + document + "; Doc from file: " + documentFromFile + "; File: " + psiFile + "; Virtual file: " + PsiUtilCore.getVirtualFile(psiFile);
        }
        TIntObjectHashMap id2Pass = new TIntObjectHashMap();
        TIntArrayList passesRefusedToCreate = new TIntArrayList();
        this.myRegisteredPassFactories.forEachKey(passId -> {
            if (passesToIgnore == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "passesToIgnore", "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl", "lambda$instantiatePasses$0"));
            }
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl", "lambda$instantiatePasses$0"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl", "lambda$instantiatePasses$0"));
            }
            if (ArrayUtil.find(passesToIgnore, passId) != -1) {
                return true;
            }
            PassConfig passConfig = (PassConfig)this.myRegisteredPassFactories.get(passId);
            TextEditorHighlightingPassFactory factory = passConfig.passFactory;
            TextEditorHighlightingPass pass = factory.createHighlightingPass(psiFile, editor);
            if (pass == null) {
                passesRefusedToCreate.add(passId);
            } else {
                pass.setColorsScheme(editor.getColorsScheme());
                TIntArrayList ids = new TIntArrayList(passConfig.completionPredecessorIds.length);
                for (int id : passConfig.completionPredecessorIds) {
                    if (!this.myRegisteredPassFactories.containsKey(id)) continue;
                    ids.add(id);
                }
                pass.setCompletionPredecessorIds(ids.isEmpty() ? ArrayUtil.EMPTY_INT_ARRAY : ids.toNativeArray());
                ids = new TIntArrayList(passConfig.startingPredecessorIds.length);
                for (int id : passConfig.startingPredecessorIds) {
                    if (!this.myRegisteredPassFactories.containsKey(id)) continue;
                    ids.add(id);
                }
                pass.setStartingPredecessorIds(ids.isEmpty() ? ArrayUtil.EMPTY_INT_ARRAY : ids.toNativeArray());
                pass.setId(passId);
                id2Pass.put(passId, (Object)pass);
            }
            return true;
        });
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        FileStatusMap statusMap = daemonCodeAnalyzer.getFileStatusMap();
        passesRefusedToCreate.forEach(passId -> {
            statusMap.markFileUpToDate(document, passId);
            return true;
        });
        List<Object> list = Arrays.asList(id2Pass.getValues());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl", "instantiatePasses"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<TextEditorHighlightingPass> instantiateMainPasses(@NotNull PsiFile psiFile, @NotNull Document document, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl", "instantiateMainPasses"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl", "instantiateMainPasses"));
        }
        if (highlightInfoProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfoProcessor", "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl", "instantiateMainPasses"));
        }
        THashSet ids = new THashSet();
        this.myRegisteredPassFactories.forEachKey(passId -> {
            TextEditorHighlightingPass pass;
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl", "lambda$instantiateMainPasses$2"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl", "lambda$instantiateMainPasses$2"));
            }
            if (highlightInfoProcessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfoProcessor", "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl", "lambda$instantiateMainPasses$2"));
            }
            PassConfig passConfig = (PassConfig)this.myRegisteredPassFactories.get(passId);
            TextEditorHighlightingPassFactory factory = passConfig.passFactory;
            if (factory instanceof MainHighlightingPassFactory && (pass = ((MainHighlightingPassFactory)factory).createMainHighlightingPass(psiFile, document, highlightInfoProcessor)) != null) {
                ids.add((Object)pass);
                pass.setId(passId);
            }
            return true;
        });
        ArrayList<TextEditorHighlightingPass> arrayList = new ArrayList<TextEditorHighlightingPass>((Collection<TextEditorHighlightingPass>)ids);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl", "instantiateMainPasses"));
        }
        return arrayList;
    }

    private void checkForCycles() {
        TIntObjectHashMap transitivePredecessors = new TIntObjectHashMap();
        this.myRegisteredPassFactories.forEachEntry((passId, config) -> {
            TIntHashSet allPredecessors = new TIntHashSet(((PassConfig)config).completionPredecessorIds);
            allPredecessors.addAll(((PassConfig)config).startingPredecessorIds);
            transitivePredecessors.put(passId, (Object)allPredecessors);
            allPredecessors.forEach(predecessorId -> {
                PassConfig predecessor = (PassConfig)this.myRegisteredPassFactories.get(predecessorId);
                if (predecessor == null) {
                    return true;
                }
                TIntHashSet transitives = (TIntHashSet)transitivePredecessors.get(predecessorId);
                if (transitives == null) {
                    transitives = new TIntHashSet();
                    transitivePredecessors.put(predecessorId, (Object)transitives);
                }
                transitives.addAll(predecessor.completionPredecessorIds);
                transitives.addAll(predecessor.startingPredecessorIds);
                return true;
            });
            return true;
        });
        transitivePredecessors.forEachKey(passId -> {
            if (((TIntHashSet)transitivePredecessors.get(passId)).contains(passId)) {
                throw new IllegalArgumentException("There is a cycle introduced involving pass " + ((PassConfig)this.myRegisteredPassFactories.get(passId)).passFactory);
            }
            return true;
        });
    }

    @Override
    @NotNull
    public List<DirtyScopeTrackingHighlightingPassFactory> getDirtyScopeTrackingFactories() {
        List<DirtyScopeTrackingHighlightingPassFactory> list = this.myDirtyScopeTrackingFactories;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl", "getDirtyScopeTrackingFactories"));
        }
        return list;
    }

    private static class PassConfig {
        private final TextEditorHighlightingPassFactory passFactory;
        private final int[] startingPredecessorIds;
        private final int[] completionPredecessorIds;

        private PassConfig(@NotNull TextEditorHighlightingPassFactory passFactory, @NotNull int[] completionPredecessorIds, @NotNull int[] startingPredecessorIds) {
            if (passFactory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "passFactory", "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl$PassConfig", "<init>"));
            }
            if (completionPredecessorIds == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completionPredecessorIds", "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl$PassConfig", "<init>"));
            }
            if (startingPredecessorIds == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startingPredecessorIds", "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl$PassConfig", "<init>"));
            }
            this.completionPredecessorIds = completionPredecessorIds;
            this.startingPredecessorIds = startingPredecessorIds;
            this.passFactory = passFactory;
        }
    }
}

