/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CastMethodArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapArrayToArraysAsListFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapLongWithMathToIntExactFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapObjectWithOptionalOfNullableFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapStringWithFileFix;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.annotations.NotNull;

public class ConstructorParametersFixer {
    public static void registerFixActions(@NotNull PsiJavaCodeReferenceElement ctrRef, PsiConstructorCall constructorCall, HighlightInfo highlightInfo, TextRange fixRange) {
        if (ctrRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctrRef", "com/intellij/codeInsight/daemon/impl/quickfix/ConstructorParametersFixer", "registerFixActions"));
        }
        JavaResolveResult resolved = ctrRef.advancedResolve(false);
        PsiClass aClass = (PsiClass)resolved.getElement();
        if (aClass == null) {
            return;
        }
        PsiMethod[] methods = aClass.getConstructors();
        CandidateInfo[] candidates = new CandidateInfo[methods.length];
        for (int i2 = 0; i2 < candidates.length; ++i2) {
            candidates[i2] = new CandidateInfo(methods[i2], resolved.getSubstitutor());
        }
        CastMethodArgumentFix.REGISTRAR.registerCastActions(candidates, constructorCall, highlightInfo, fixRange);
        AddTypeArgumentsFix.REGISTRAR.registerCastActions(candidates, constructorCall, highlightInfo, fixRange);
        WrapArrayToArraysAsListFix.REGISTAR.registerCastActions(candidates, constructorCall, highlightInfo, fixRange);
        WrapLongWithMathToIntExactFix.REGISTAR.registerCastActions(candidates, constructorCall, highlightInfo, fixRange);
        WrapObjectWithOptionalOfNullableFix.REGISTAR.registerCastActions(candidates, constructorCall, highlightInfo, fixRange);
        WrapStringWithFileFix.REGISTAR.registerCastActions(candidates, constructorCall, highlightInfo, fixRange);
    }
}

