/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ExplicitTypeCanBeDiamondInspection
extends BaseJavaBatchLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance(ExplicitTypeCanBeDiamondInspection.class);

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ExplicitTypeCanBeDiamondInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Explicit type can be replaced with <>" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ExplicitTypeCanBeDiamondInspection", "getDisplayName"));
        }
        return "Explicit type can be replaced with <>";
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("Convert2Diamond" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ExplicitTypeCanBeDiamondInspection", "getShortName"));
        }
        return "Convert2Diamond";
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/ExplicitTypeCanBeDiamondInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitNewExpression(PsiNewExpression expression) {
                if (PsiDiamondTypeUtil.canCollapseToDiamond(expression, expression, null)) {
                    PsiJavaCodeReferenceElement classReference = expression.getClassOrAnonymousClassReference();
                    LOG.assertTrue(classReference != null);
                    PsiReferenceParameterList parameterList = classReference.getParameterList();
                    LOG.assertTrue(parameterList != null);
                    PsiElement firstChild = parameterList.getFirstChild();
                    PsiElement lastChild = parameterList.getLastChild();
                    TextRange range = new TextRange(firstChild != null && firstChild.getNode().getElementType() == JavaTokenType.LT ? 1 : 0, parameterList.getTextLength() - (lastChild != null && lastChild.getNode().getElementType() == JavaTokenType.GT ? 1 : 0));
                    holder.registerProblem((PsiElement)parameterList, "Explicit type argument #ref #loc can be replaced with <>", ProblemHighlightType.LIKE_UNUSED_SYMBOL, range, new ReplaceWithDiamondFix());
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ExplicitTypeCanBeDiamondInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static class ReplaceWithDiamondFix
    implements LocalQuickFix,
    HighPriorityAction {
        private ReplaceWithDiamondFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Replace with <>" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ExplicitTypeCanBeDiamondInspection$ReplaceWithDiamondFix", "getFamilyName"));
            }
            return "Replace with <>";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ExplicitTypeCanBeDiamondInspection$ReplaceWithDiamondFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/ExplicitTypeCanBeDiamondInspection$ReplaceWithDiamondFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            PsiNewExpression newExpression = PsiTreeUtil.getParentOfType(PsiDiamondTypeUtil.replaceExplicitWithDiamond(element), PsiNewExpression.class);
            if (newExpression != null) {
                CodeStyleManager.getInstance(project).reformat(newExpression);
            }
        }
    }
}

