/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.ProjectRootListener;
import com.intellij.openapi.projectRoots.ex.ProjectRoot;
import com.intellij.openapi.projectRoots.ex.ProjectRootContainer;
import com.intellij.openapi.projectRoots.impl.CompositeProjectRoot;
import com.intellij.openapi.projectRoots.impl.ProjectRootUtil;
import com.intellij.openapi.projectRoots.impl.SimpleProjectRoot;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.vfs.JarCopyingFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ProjectRootContainerImpl
implements JDOMExternalizable,
ProjectRootContainer {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.projectRoots.impl.ProjectRootContainerImpl");
    private final Map<OrderRootType, CompositeProjectRoot> myRoots = new THashMap();
    private final Map<OrderRootType, VirtualFile[]> myCachedFiles = new THashMap();
    private boolean myInsideChange;
    private final List<ProjectRootListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final boolean myNoCopyJars;

    ProjectRootContainerImpl(boolean noCopyJars) {
        this.myNoCopyJars = noCopyJars;
        for (OrderRootType rootType : OrderRootType.getAllTypes()) {
            this.myRoots.put(rootType, new CompositeProjectRoot());
            this.myCachedFiles.put(rootType, VirtualFile.EMPTY_ARRAY);
        }
    }

    @Override
    @NotNull
    public VirtualFile[] getRootFiles(@NotNull OrderRootType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "getRootFiles"));
        }
        VirtualFile[] virtualFileArray = ObjectUtils.chooseNotNull(this.myCachedFiles.get(type), VirtualFile.EMPTY_ARRAY);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "getRootFiles"));
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public ProjectRoot[] getRoots(@NotNull OrderRootType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "getRoots"));
        }
        ProjectRoot[] projectRootArray = this.myRoots.get(type).getProjectRoots();
        if (projectRootArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "getRoots"));
        }
        return projectRootArray;
    }

    void startChange() {
        this.myInsideChange = true;
    }

    private void assertNotInsideChange() {
        if (this.myInsideChange) {
            throw new IllegalStateException();
        }
    }

    private void assertInsideChange() {
        if (!this.myInsideChange) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void changeRoots(@NotNull Runnable change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "changeRoots"));
        }
        this.assertNotInsideChange();
        this.myInsideChange = true;
        THashMap oldRoots = new THashMap(this.myCachedFiles);
        try {
            change.run();
        }
        finally {
            this.myInsideChange = false;
            if (this.cacheFiles((Map<OrderRootType, VirtualFile[]>)oldRoots)) {
                this.fireRootsChanged();
            }
        }
    }

    private boolean cacheFiles(@NotNull Map<OrderRootType, VirtualFile[]> oldRoots) {
        if (oldRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRoots", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "cacheFiles"));
        }
        this.myCachedFiles.clear();
        boolean changed = false;
        for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
            VirtualFile[] roots = this.myRoots.get(orderRootType).getVirtualFiles();
            changed |= !Comparing.equal(roots, (Object[])oldRoots.get(orderRootType));
            this.myCachedFiles.put(orderRootType, roots);
        }
        return changed;
    }

    void addProjectRootContainerListener(@NotNull ProjectRootListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "addProjectRootContainerListener"));
        }
        this.myListeners.add(listener);
    }

    public void removeProjectRootContainerListener(@NotNull ProjectRootListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "removeProjectRootContainerListener"));
        }
        this.myListeners.remove(listener);
    }

    private void fireRootsChanged() {
        for (ProjectRootListener listener : this.myListeners) {
            listener.rootsChanged();
        }
    }

    @Override
    public void removeRoot(@NotNull ProjectRoot root, @NotNull OrderRootType type) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "removeRoot"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "removeRoot"));
        }
        this.assertInsideChange();
        this.myRoots.get(type).remove(root);
    }

    @Override
    @NotNull
    public ProjectRoot addRoot(@NotNull VirtualFile virtualFile, @NotNull OrderRootType type) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "addRoot"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "addRoot"));
        }
        this.assertInsideChange();
        ProjectRoot projectRoot = this.myRoots.get(type).add(virtualFile);
        if (projectRoot == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "addRoot"));
        }
        return projectRoot;
    }

    @Override
    public void addRoot(@NotNull ProjectRoot root, @NotNull OrderRootType type) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "addRoot"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "addRoot"));
        }
        this.assertInsideChange();
        this.myRoots.get(type).add(root);
    }

    @Override
    public void removeAllRoots(@NotNull OrderRootType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "removeAllRoots"));
        }
        this.assertInsideChange();
        this.myRoots.get(type).clear();
    }

    @Override
    public void removeRoot(@NotNull VirtualFile root, @NotNull OrderRootType type) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "removeRoot"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "removeRoot"));
        }
        this.assertInsideChange();
        this.myRoots.get(type).remove(root);
    }

    @Override
    public void removeAllRoots() {
        this.assertInsideChange();
        for (CompositeProjectRoot myRoot : this.myRoots.values()) {
            myRoot.clear();
        }
    }

    @Override
    public void update() {
        this.assertInsideChange();
        for (CompositeProjectRoot myRoot : this.myRoots.values()) {
            myRoot.update();
        }
    }

    @Override
    public void readExternal(Element element) {
        this.assertInsideChange();
        for (OrderRootType type : OrderRootType.getAllPersistentTypes()) {
            this.read(element, (PersistentOrderRootType)type);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            this.myRoots.values().forEach(root -> {
                if (this.myNoCopyJars) {
                    ProjectRootContainerImpl.setNoCopyJars(root);
                }
            });
            this.cacheFiles((Map<OrderRootType, VirtualFile[]>)new THashMap(this.myCachedFiles));
        });
        OrderRootType[] orderRootTypeArray = OrderRootType.getAllTypes();
        int n = orderRootTypeArray.length;
        for (int j = 0; j < n; ++j) {
            OrderRootType type;
            VirtualFile[] oldRoots = VirtualFile.EMPTY_ARRAY;
            type = orderRootTypeArray[j];
            VirtualFile[] newRoots = this.getRootFiles(type);
            if (Comparing.equal(oldRoots, newRoots)) continue;
            this.fireRootsChanged();
            break;
        }
    }

    @Override
    public void writeExternal(Element element) {
        List<PersistentOrderRootType> allTypes = OrderRootType.getSortedRootTypes();
        for (PersistentOrderRootType type : allTypes) {
            this.write(element, type);
        }
    }

    void copyRootsFrom(@NotNull ProjectRootContainerImpl rootContainer) {
        if (rootContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootContainer", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "copyRootsFrom"));
        }
        this.changeRoots(() -> {
            if (rootContainer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootContainer", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "lambda$copyRootsFrom$2"));
            }
            this.removeAllRoots();
            for (OrderRootType rootType : OrderRootType.getAllTypes()) {
                ProjectRoot[] newRoots;
                for (ProjectRoot newRoot : newRoots = rootContainer.getRoots(rootType)) {
                    this.addRoot(newRoot, rootType);
                }
            }
        });
    }

    private static void setNoCopyJars(ProjectRoot root) {
        block3: {
            block2: {
                if (!(root instanceof SimpleProjectRoot)) break block2;
                String url = ((SimpleProjectRoot)root).getUrl();
                if (!"jar".equals(VirtualFileManager.extractProtocol(url))) break block3;
                String path = VirtualFileManager.extractPath(url);
                VirtualFileSystem fileSystem = StandardFileSystems.jar();
                if (!(fileSystem instanceof JarCopyingFileSystem)) break block3;
                ((JarCopyingFileSystem)((Object)fileSystem)).setNoCopyJarForPath(path);
                break block3;
            }
            if (root instanceof CompositeProjectRoot) {
                ProjectRoot[] roots;
                for (ProjectRoot root1 : roots = ((CompositeProjectRoot)root).getProjectRoots()) {
                    ProjectRootContainerImpl.setNoCopyJars(root1);
                }
            }
        }
    }

    private void read(Element element, PersistentOrderRootType type) {
        Element child;
        String sdkRootName = type.getSdkRootName();
        Element element2 = child = sdkRootName != null ? element.getChild(sdkRootName) : null;
        if (child == null) {
            this.myRoots.put(type, new CompositeProjectRoot());
            return;
        }
        List children = child.getChildren();
        if (children.size() != 1) {
            LOG.error(children);
        }
        CompositeProjectRoot root = (CompositeProjectRoot)ProjectRootUtil.read((Element)children.get(0));
        this.myRoots.put(type, root);
    }

    private void write(Element roots, PersistentOrderRootType type) {
        String sdkRootName = type.getSdkRootName();
        if (sdkRootName != null) {
            Element e = new Element(sdkRootName);
            roots.addContent(e);
            Element root = ProjectRootUtil.write(this.myRoots.get(type));
            e.addContent(root);
        }
    }
}

