/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.DependencyVisitorFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiFileEx;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DependenciesBuilder {
    private final Project myProject;
    private final AnalysisScope myScope;
    private final AnalysisScope myScopeOfInterest;
    private final Map<PsiFile, Set<PsiFile>> myDependencies;
    protected int myTotalFileCount;
    protected int myFileCount;
    protected int myTransitive;

    protected DependenciesBuilder(@NotNull Project project, @NotNull AnalysisScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packageDependencies/DependenciesBuilder", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/packageDependencies/DependenciesBuilder", "<init>"));
        }
        this(project, scope, null);
    }

    public DependenciesBuilder(Project project, AnalysisScope scope, @Nullable AnalysisScope scopeOfInterest) {
        this.myDependencies = new HashMap<PsiFile, Set<PsiFile>>();
        this.myFileCount = 0;
        this.myTransitive = 0;
        this.myProject = project;
        this.myScope = scope;
        this.myScopeOfInterest = scopeOfInterest;
        this.myTotalFileCount = scope.getFileCount();
    }

    public void setInitialFileCount(int fileCount) {
        this.myFileCount = fileCount;
    }

    public void setTotalFileCount(int totalFileCount) {
        this.myTotalFileCount = totalFileCount;
    }

    public int getTotalFileCount() {
        return this.myTotalFileCount;
    }

    public Map<PsiFile, Set<PsiFile>> getDependencies() {
        return this.myDependencies;
    }

    public Map<PsiFile, Set<PsiFile>> getDirectDependencies() {
        return this.getDependencies();
    }

    public AnalysisScope getScope() {
        return this.myScope;
    }

    public AnalysisScope getScopeOfInterest() {
        return this.myScopeOfInterest;
    }

    public Project getProject() {
        return this.myProject;
    }

    public abstract String getRootNodeNameInUsageView();

    public abstract String getInitialUsagesPosition();

    public abstract boolean isBackward();

    public abstract void analyze();

    public Map<PsiFile, Map<DependencyRule, Set<PsiFile>>> getIllegalDependencies() {
        HashMap<PsiFile, Map<DependencyRule, Set<PsiFile>>> result = new HashMap<PsiFile, Map<DependencyRule, Set<PsiFile>>>();
        DependencyValidationManager validator = DependencyValidationManager.getInstance(this.myProject);
        for (PsiFile file : this.getDirectDependencies().keySet()) {
            Set<PsiFile> deps = this.getDirectDependencies().get(file);
            HashMap<DependencyRule, HashSet<PsiFile>> illegal = null;
            for (PsiFile dependency : deps) {
                HashSet<PsiFile> illegalFilesByRule;
                DependencyRule rule = this.isBackward() ? validator.getViolatorDependencyRule(dependency, file) : validator.getViolatorDependencyRule(file, dependency);
                if (rule == null) continue;
                if (illegal == null) {
                    illegal = new HashMap<DependencyRule, HashSet<PsiFile>>();
                    result.put(file, illegal);
                }
                if ((illegalFilesByRule = (HashSet<PsiFile>)illegal.get(rule)) == null) {
                    illegalFilesByRule = new HashSet<PsiFile>();
                }
                illegalFilesByRule.add(dependency);
                illegal.put(rule, illegalFilesByRule);
            }
        }
        return result;
    }

    public List<List<PsiFile>> findPaths(PsiFile from, PsiFile to) {
        return this.findPaths(from, to, new HashSet<PsiFile>());
    }

    private List<List<PsiFile>> findPaths(PsiFile from, PsiFile to, Set<PsiFile> processed2) {
        ArrayList<List<PsiFile>> result = new ArrayList<List<PsiFile>>();
        Set<PsiFile> reachable = this.getDirectDependencies().get(from);
        if (reachable != null) {
            if (reachable.contains(to)) {
                result.add(new ArrayList());
                return result;
            }
            if (processed2.add(from)) {
                for (PsiFile file : reachable) {
                    if (this.getScope().contains(file)) continue;
                    List<List<PsiFile>> paths = this.findPaths(file, to, processed2);
                    for (List<PsiFile> path : paths) {
                        path.add(0, file);
                    }
                    result.addAll(paths);
                }
            }
        }
        return result;
    }

    public boolean isTransitive() {
        return this.myTransitive > 0;
    }

    public int getTransitiveBorder() {
        return this.myTransitive;
    }

    public String getRelativeToProjectPath(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/packageDependencies/DependenciesBuilder", "getRelativeToProjectPath"));
        }
        return ProjectUtilCore.displayUrlRelativeToProject(virtualFile, virtualFile.getPresentableUrl(), this.getProject(), true, false);
    }

    public static void analyzeFileDependencies(@NotNull PsiFile file, @NotNull DependencyProcessor processor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/packageDependencies/DependenciesBuilder", "analyzeFileDependencies"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/packageDependencies/DependenciesBuilder", "analyzeFileDependencies"));
        }
        DependenciesBuilder.analyzeFileDependencies(file, processor, DependencyVisitorFactory.VisitorOptions.fromSettings(file.getProject()));
    }

    public static void analyzeFileDependencies(@NotNull PsiFile file, @NotNull DependencyProcessor processor, @NotNull DependencyVisitorFactory.VisitorOptions options) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/packageDependencies/DependenciesBuilder", "analyzeFileDependencies"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/packageDependencies/DependenciesBuilder", "analyzeFileDependencies"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/packageDependencies/DependenciesBuilder", "analyzeFileDependencies"));
        }
        file.putUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING, Boolean.TRUE);
        file.accept(DependencyVisitorFactory.createVisitor(file, processor, options));
        file.putUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING, null);
    }

    public static interface DependencyProcessor {
        public void process(PsiElement var1, PsiElement var2);
    }
}

