/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.FileNameIndexService;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilenameIndex {
    @Deprecated
    @NonNls
    public static final ID<String, Void> NAME = ID.create("FilenameIndex");

    @NotNull
    public static String[] getAllFilenames(Project project) {
        THashSet names = new THashSet();
        FilenameIndex.getService().processAllFileNames(arg_0 -> FilenameIndex.lambda$getAllFilenames$0((Set)names, arg_0), project == null ? new EverythingGlobalScope() : GlobalSearchScope.allScope(project), null);
        String[] stringArray = ArrayUtil.toStringArray((Collection<String>)names);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getAllFilenames"));
        }
        return stringArray;
    }

    public static void processAllFileNames(Processor<String> processor, GlobalSearchScope scope, IdFilter filter) {
        FilenameIndex.getService().processAllFileNames(processor, scope, filter);
    }

    public static Collection<VirtualFile> getVirtualFilesByName(Project project, String name, GlobalSearchScope scope) {
        return FilenameIndex.getService().getVirtualFilesByName(project, name, scope, null);
    }

    public static Collection<VirtualFile> getVirtualFilesByName(Project project, String name, boolean caseSensitively, GlobalSearchScope scope) {
        if (caseSensitively) {
            return FilenameIndex.getVirtualFilesByName(project, name, scope);
        }
        return FilenameIndex.getVirtualFilesByNameIgnoringCase(name, scope, project, null);
    }

    @NotNull
    public static PsiFile[] getFilesByName(Project project, String name, GlobalSearchScope scope) {
        PsiFile[] psiFileArray = (PsiFile[])FilenameIndex.getFilesByName(project, name, scope, false);
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getFilesByName"));
        }
        return psiFileArray;
    }

    public static boolean processFilesByName(@NotNull String name, boolean includeDirs, @NotNull Processor<? super PsiFileSystemItem> processor, @NotNull GlobalSearchScope scope, @NotNull Project project, @Nullable IdFilter idFilter) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        return FilenameIndex.processFilesByName(name, includeDirs, true, processor, scope, project, idFilter);
    }

    public static boolean processFilesByName(@NotNull String name, boolean includeDirs, boolean caseSensitively, @NotNull Processor<? super PsiFileSystemItem> processor, @NotNull GlobalSearchScope scope, @NotNull Project project, @Nullable IdFilter idFilter) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        Collection<VirtualFile> files = caseSensitively ? FilenameIndex.getService().getVirtualFilesByName(project, name, scope, idFilter) : FilenameIndex.getVirtualFilesByNameIgnoringCase(name, scope, project, idFilter);
        if (files.isEmpty()) {
            return false;
        }
        PsiManager psiManager = PsiManager.getInstance(project);
        int processedFiles = 0;
        for (VirtualFile file : files) {
            PsiDirectory dir;
            if (!file.isValid()) continue;
            if (!includeDirs && !file.isDirectory()) {
                PsiFile psiFile = psiManager.findFile(file);
                if (psiFile == null) continue;
                if (!processor.process(psiFile)) {
                    return true;
                }
                ++processedFiles;
                continue;
            }
            if (!includeDirs || !file.isDirectory() || (dir = psiManager.findDirectory(file)) == null) continue;
            if (!processor.process(dir)) {
                return true;
            }
            ++processedFiles;
        }
        return processedFiles > 0;
    }

    @NotNull
    private static Set<VirtualFile> getVirtualFilesByNameIgnoringCase(@NotNull String name, @NotNull GlobalSearchScope scope, @NotNull Project project, @Nullable IdFilter idFilter) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/search/FilenameIndex", "getVirtualFilesByNameIgnoringCase"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/FilenameIndex", "getVirtualFilesByNameIgnoringCase"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/FilenameIndex", "getVirtualFilesByNameIgnoringCase"));
        }
        THashSet keys = new THashSet();
        FileNameIndexService fileNameIndexService = FilenameIndex.getService();
        fileNameIndexService.processAllFileNames(arg_0 -> FilenameIndex.lambda$getVirtualFilesByNameIgnoringCase$1(name, (Set)keys, arg_0), scope, idFilter);
        THashSet files = new THashSet();
        for (String each : keys) {
            files.addAll(fileNameIndexService.getVirtualFilesByName(project, each, scope, idFilter));
        }
        THashSet tHashSet = files;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getVirtualFilesByNameIgnoringCase"));
        }
        return tHashSet;
    }

    @NotNull
    public static PsiFileSystemItem[] getFilesByName(Project project, String name, @NotNull GlobalSearchScope scope, boolean includeDirs) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/FilenameIndex", "getFilesByName"));
        }
        SmartList result = new SmartList();
        Processor processor = Processors.cancelableCollectProcessor(result);
        FilenameIndex.processFilesByName(name, includeDirs, processor, scope, project, null);
        if (includeDirs) {
            PsiFileSystemItem[] psiFileSystemItemArray = ArrayUtil.toObjectArray(result, PsiFileSystemItem.class);
            if (psiFileSystemItemArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getFilesByName"));
            }
            return psiFileSystemItemArray;
        }
        PsiFileSystemItem[] psiFileSystemItemArray = result.toArray(new PsiFile[result.size()]);
        if (psiFileSystemItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getFilesByName"));
        }
        return psiFileSystemItemArray;
    }

    @NotNull
    public static Collection<VirtualFile> getAllFilesByExt(@NotNull Project project, @NotNull String ext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        if (ext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ext", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        Collection<VirtualFile> collection = FilenameIndex.getAllFilesByExt(project, ext, GlobalSearchScope.allScope(project));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        return collection;
    }

    @NotNull
    public static Collection<VirtualFile> getAllFilesByExt(@NotNull Project project, @NotNull String ext, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        if (ext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ext", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        int len = ext.length();
        if (len == 0) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
            }
            return list;
        }
        ext = "." + ext;
        ++len;
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (String name : FilenameIndex.getAllFilenames(project)) {
            int length = name.length();
            if (length <= len || !name.substring(length - len).equalsIgnoreCase(ext)) continue;
            files.addAll(FilenameIndex.getVirtualFilesByName(project, name, searchScope));
        }
        ArrayList<VirtualFile> arrayList = files;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        return arrayList;
    }

    static FileNameIndexService getService() {
        return ServiceManager.getService(FileNameIndexService.class);
    }

    private static /* synthetic */ boolean lambda$getVirtualFilesByNameIgnoringCase$1(@NotNull String name, Set keys, String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/search/FilenameIndex", "lambda$getVirtualFilesByNameIgnoringCase$1"));
        }
        if (name.equalsIgnoreCase(value)) {
            keys.add(value);
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$getAllFilenames$0(Set names, String s) {
        names.add(s);
        return true;
    }
}

