/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public interface PsiReferenceProcessor {
    public boolean execute(PsiReference var1);

    public static class FindElement
    implements PsiReferenceProcessor {
        private volatile PsiReference myFoundElement;

        public boolean isFound() {
            return this.myFoundElement != null;
        }

        public PsiReference getFoundReference() {
            return this.myFoundElement;
        }

        @Override
        public boolean execute(PsiReference element) {
            this.myFoundElement = element;
            return false;
        }
    }

    public static class CollectElements
    implements PsiReferenceProcessor {
        private final Collection<PsiReference> myCollection;

        public CollectElements(Collection<PsiReference> collection) {
            this.myCollection = Collections.synchronizedCollection(collection);
        }

        public CollectElements() {
            this(new ArrayList<PsiReference>());
        }

        @NotNull
        public PsiReference[] toArray() {
            PsiReference[] psiReferenceArray = this.myCollection.toArray(new PsiReference[this.myCollection.size()]);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/PsiReferenceProcessor$CollectElements", "toArray"));
            }
            return psiReferenceArray;
        }

        @NotNull
        public PsiReference[] toArray(PsiReference[] array) {
            PsiReference[] psiReferenceArray = this.myCollection.toArray(array);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/PsiReferenceProcessor$CollectElements", "toArray"));
            }
            return psiReferenceArray;
        }

        @Override
        public boolean execute(PsiReference element) {
            this.myCollection.add(element);
            return true;
        }
    }
}

