/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageFilter;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompositeLanguage
extends Language {
    private final List<LanguageFilter> myFilters = ContainerUtil.createLockFreeCopyOnWriteList();

    protected CompositeLanguage(String id) {
        super(id);
    }

    protected CompositeLanguage(String ID2, String ... mimeTypes) {
        super(ID2, mimeTypes);
    }

    protected CompositeLanguage(Language baseLanguage, String ID2, String ... mimeTypes) {
        super(baseLanguage, ID2, mimeTypes);
    }

    public void registerLanguageExtension(LanguageFilter filter) {
        if (!this.myFilters.contains(filter)) {
            this.myFilters.add(filter);
        }
    }

    public boolean unregisterLanguageExtension(LanguageFilter filter) {
        return this.myFilters.remove(filter);
    }

    @NotNull
    public Language[] getLanguageExtensionsForFile(@NotNull PsiFile psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/lang/CompositeLanguage", "getLanguageExtensionsForFile"));
        }
        ArrayList<Language> extensions = new ArrayList<Language>(1);
        for (LanguageFilter filter : this.myFilters) {
            if (!filter.isRelevantForFile(psi)) continue;
            extensions.add(filter.getLanguage());
        }
        Language[] languageArray = extensions.toArray(new Language[extensions.size()]);
        if (languageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/CompositeLanguage", "getLanguageExtensionsForFile"));
        }
        return languageArray;
    }

    @NotNull
    public LanguageFilter[] getLanguageExtensions() {
        LanguageFilter[] languageFilterArray = ArrayUtil.stripTrailingNulls(this.myFilters.toArray(new LanguageFilter[this.myFilters.size()]));
        if (languageFilterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/CompositeLanguage", "getLanguageExtensions"));
        }
        return languageFilterArray;
    }
}

