/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.diff;

import com.intellij.openapi.util.Ref;
import com.intellij.util.ThreeState;
import com.intellij.util.diff.DiffTreeChangeBuilder;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.util.diff.ShallowNodeComparator;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DiffTree<OT, NT> {
    private static final int CHANGE_PARENT_VERSUS_CHILDREN_THRESHOLD = 20;
    private final FlyweightCapableTreeStructure<OT> myOldTree;
    private final FlyweightCapableTreeStructure<NT> myNewTree;
    private final ShallowNodeComparator<OT, NT> myComparator;
    private final List<Ref<OT[]>> myOldChildrenLists;
    private final List<Ref<NT[]>> myNewChildrenLists;
    private final CharSequence myOldText;
    private final CharSequence myNewText;
    private final int myOldTreeStart;
    private final int myNewTreeStart;
    private static final DiffTreeChangeBuilder EMPTY_CONSUMER = new DiffTreeChangeBuilder(){

        public void nodeReplaced(@NotNull Object oldChild, @NotNull Object newChild) {
            if (oldChild == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldChild", "com/intellij/util/diff/DiffTree$1", "nodeReplaced"));
            }
            if (newChild == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newChild", "com/intellij/util/diff/DiffTree$1", "nodeReplaced"));
            }
        }

        public void nodeDeleted(@NotNull Object oldParent, @NotNull Object oldNode) {
            if (oldParent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldParent", "com/intellij/util/diff/DiffTree$1", "nodeDeleted"));
            }
            if (oldNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNode", "com/intellij/util/diff/DiffTree$1", "nodeDeleted"));
            }
        }

        public void nodeInserted(@NotNull Object oldParent, @NotNull Object newNode, int pos) {
            if (oldParent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldParent", "com/intellij/util/diff/DiffTree$1", "nodeInserted"));
            }
            if (newNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNode", "com/intellij/util/diff/DiffTree$1", "nodeInserted"));
            }
        }
    };

    private DiffTree(@NotNull FlyweightCapableTreeStructure<OT> oldTree, @NotNull FlyweightCapableTreeStructure<NT> newTree, @NotNull ShallowNodeComparator<OT, NT> comparator, @NotNull CharSequence oldText) {
        if (oldTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldTree", "com/intellij/util/diff/DiffTree", "<init>"));
        }
        if (newTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTree", "com/intellij/util/diff/DiffTree", "<init>"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/diff/DiffTree", "<init>"));
        }
        if (oldText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldText", "com/intellij/util/diff/DiffTree", "<init>"));
        }
        this.myOldChildrenLists = new ArrayList<Ref<OT[]>>();
        this.myNewChildrenLists = new ArrayList<Ref<NT[]>>();
        this.myOldTree = oldTree;
        this.myNewTree = newTree;
        this.myComparator = comparator;
        this.myOldText = oldText;
        this.myOldTreeStart = oldTree.getStartOffset(oldTree.getRoot());
        this.myNewText = newTree.toString(newTree.getRoot());
        this.myNewTreeStart = newTree.getStartOffset(newTree.getRoot());
    }

    public static <OT, NT> void diff(@NotNull FlyweightCapableTreeStructure<OT> oldTree, @NotNull FlyweightCapableTreeStructure<NT> newTree, @NotNull ShallowNodeComparator<OT, NT> comparator, @NotNull DiffTreeChangeBuilder<OT, NT> consumer, @NotNull CharSequence oldText) {
        if (oldTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldTree", "com/intellij/util/diff/DiffTree", "diff"));
        }
        if (newTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTree", "com/intellij/util/diff/DiffTree", "diff"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/diff/DiffTree", "diff"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/diff/DiffTree", "diff"));
        }
        if (oldText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldText", "com/intellij/util/diff/DiffTree", "diff"));
        }
        DiffTree<OT, NT> tree = new DiffTree<OT, NT>(oldTree, newTree, comparator, oldText);
        super.build(oldTree.getRoot(), newTree.getRoot(), 0, consumer);
    }

    @NotNull
    private static <OT, NT> DiffTreeChangeBuilder<OT, NT> emptyConsumer() {
        DiffTreeChangeBuilder diffTreeChangeBuilder = EMPTY_CONSUMER;
        if (diffTreeChangeBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/diff/DiffTree", "emptyConsumer"));
        }
        return diffTreeChangeBuilder;
    }

    @NotNull
    private CompareResult build(@NotNull OT oldNode, @NotNull NT newNode, int level, @NotNull DiffTreeChangeBuilder<OT, NT> consumer) {
        CompareResult result;
        if (oldNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNode", "com/intellij/util/diff/DiffTree", "build"));
        }
        if (newNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNode", "com/intellij/util/diff/DiffTree", "build"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/diff/DiffTree", "build"));
        }
        if (level == this.myNewChildrenLists.size()) {
            this.myNewChildrenLists.add(new Ref());
            this.myOldChildrenLists.add(new Ref());
        }
        Ref<T[]> oldChildrenR = this.myOldChildrenLists.get(level);
        int oldChildrenSize = this.myOldTree.getChildren(oldNode, oldChildrenR);
        T[] oldChildren = oldChildrenR.get();
        Ref<T[]> newChildrenR = this.myNewChildrenLists.get(level);
        int newChildrenSize = this.myNewTree.getChildren(newNode, newChildrenR);
        T[] newChildren = newChildrenR.get();
        if (Math.abs(oldChildrenSize - newChildrenSize) > 20) {
            consumer.nodeReplaced(oldNode, newNode);
            result = CompareResult.NOT_EQUAL;
        } else if (oldChildrenSize == 0 && newChildrenSize == 0) {
            if (!this.myComparator.hashCodesEqual(oldNode, newNode) || !this.myComparator.typesEqual(oldNode, newNode)) {
                consumer.nodeReplaced(oldNode, newNode);
                result = CompareResult.NOT_EQUAL;
            } else {
                result = CompareResult.EQUAL;
            }
        } else {
            ShallowNodeComparator<OT, NT> comparator = this.myComparator;
            int minSize = Math.min(oldChildrenSize, newChildrenSize);
            int suffixLength = this.match(oldChildren, oldChildrenSize - 1, newChildren, newChildrenSize - 1, level, -1, minSize);
            int maxPrefixLength = minSize - suffixLength - (oldChildrenSize == newChildrenSize && suffixLength < minSize ? 1 : 0);
            int prefixLength = this.match(oldChildren, 0, newChildren, 0, level, 1, maxPrefixLength);
            if (oldChildrenSize == newChildrenSize && suffixLength + prefixLength == oldChildrenSize) {
                result = CompareResult.EQUAL;
            } else if (consumer == DiffTree.emptyConsumer()) {
                result = CompareResult.NOT_EQUAL;
            } else {
                int oldIndex = prefixLength;
                int newIndex = prefixLength;
                while (oldIndex < oldChildrenSize - suffixLength || newIndex < newChildrenSize - suffixLength) {
                    CompareResult c;
                    Object oldChild1 = oldIndex < oldChildrenSize - suffixLength ? (Object)oldChildren[oldIndex] : null;
                    Object oldChild2 = oldIndex < oldChildrenSize - suffixLength - 1 ? (Object)oldChildren[oldIndex + 1] : null;
                    OT oldChild3 = oldIndex < oldChildrenSize - suffixLength - 2 ? (OT)oldChildren[oldIndex + 2] : null;
                    Object newChild1 = newIndex < newChildrenSize - suffixLength ? (Object)newChildren[newIndex] : null;
                    Object newChild2 = newIndex < newChildrenSize - suffixLength - 1 ? (Object)newChildren[newIndex + 1] : null;
                    NT newChild3 = newIndex < newChildrenSize - suffixLength - 2 ? (NT)newChildren[newIndex + 2] : null;
                    CompareResult c11 = this.looksEqual(comparator, oldChild1, newChild1);
                    if (c11 == CompareResult.EQUAL || c11 == CompareResult.DRILL_DOWN_NEEDED) {
                        if (c11 == CompareResult.DRILL_DOWN_NEEDED) {
                            this.build(oldChild1, newChild1, level + 1, consumer);
                        }
                        ++oldIndex;
                        ++newIndex;
                        continue;
                    }
                    if (c11 == CompareResult.TYPE_ONLY) {
                        CompareResult c21 = this.looksEqual(comparator, oldChild2, newChild1);
                        if (c21 == CompareResult.EQUAL || c21 == CompareResult.DRILL_DOWN_NEEDED) {
                            consumer.nodeDeleted(oldNode, oldChild1);
                            ++oldIndex;
                            continue;
                        }
                        CompareResult c12 = this.looksEqual(comparator, oldChild1, newChild2);
                        if (c12 == CompareResult.EQUAL || c12 == CompareResult.DRILL_DOWN_NEEDED) {
                            consumer.nodeInserted(oldNode, newChild1, newIndex);
                            ++newIndex;
                            continue;
                        }
                        consumer.nodeReplaced(oldChild1, newChild1);
                        ++oldIndex;
                        ++newIndex;
                        continue;
                    }
                    CompareResult c12 = this.looksEqual(comparator, oldChild1, newChild2);
                    if (c12 == CompareResult.EQUAL || c12 == CompareResult.DRILL_DOWN_NEEDED) {
                        consumer.nodeInserted(oldNode, newChild1, newIndex);
                        ++newIndex;
                        continue;
                    }
                    CompareResult c21 = this.looksEqual(comparator, oldChild2, newChild1);
                    if (c21 == CompareResult.EQUAL || c21 == CompareResult.DRILL_DOWN_NEEDED || c21 == CompareResult.TYPE_ONLY) {
                        consumer.nodeDeleted(oldNode, oldChild1);
                        ++oldIndex;
                        continue;
                    }
                    if (c12 == CompareResult.TYPE_ONLY) {
                        consumer.nodeInserted(oldNode, newChild1, newIndex);
                        ++newIndex;
                        continue;
                    }
                    if (oldChild1 == null) {
                        consumer.nodeInserted(oldNode, newChild1, newIndex);
                        ++newIndex;
                        continue;
                    }
                    if (newChild1 == null) {
                        consumer.nodeDeleted(oldNode, oldChild1);
                        ++oldIndex;
                        continue;
                    }
                    if (oldChild3 != null || newChild3 != null) {
                        CompareResult c13 = this.looksEqual(comparator, oldChild1, newChild3);
                        if (c13 == CompareResult.EQUAL || c13 == CompareResult.DRILL_DOWN_NEEDED || c13 == CompareResult.TYPE_ONLY) {
                            consumer.nodeInserted(oldNode, newChild1, newIndex);
                            consumer.nodeInserted(oldNode, newChild2, ++newIndex);
                            ++newIndex;
                            continue;
                        }
                        CompareResult c31 = this.looksEqual(comparator, oldChild3, newChild1);
                        if (c31 == CompareResult.EQUAL || c31 == CompareResult.DRILL_DOWN_NEEDED || c31 == CompareResult.TYPE_ONLY) {
                            consumer.nodeDeleted(oldNode, oldChild1);
                            consumer.nodeDeleted(oldNode, oldChild2);
                            ++oldIndex;
                            ++oldIndex;
                            continue;
                        }
                    }
                    OT oldLastChild = oldIndex < oldChildrenSize - suffixLength ? (OT)oldChildren[oldChildrenSize - suffixLength - 1] : null;
                    NT newLastChild = newIndex < newChildrenSize - suffixLength ? (NT)newChildren[newChildrenSize - suffixLength - 1] : null;
                    CompareResult compareResult = c = oldLastChild == null || newLastChild == null ? CompareResult.NOT_EQUAL : this.looksEqual(comparator, oldLastChild, newLastChild);
                    if (c == CompareResult.EQUAL || c == CompareResult.TYPE_ONLY || c == CompareResult.DRILL_DOWN_NEEDED) {
                        if (c == CompareResult.DRILL_DOWN_NEEDED) {
                            this.build(oldLastChild, newLastChild, level + 1, consumer);
                        } else {
                            consumer.nodeReplaced(oldLastChild, newLastChild);
                        }
                        ++suffixLength;
                        continue;
                    }
                    consumer.nodeReplaced(oldChild1, newChild1);
                    ++oldIndex;
                    ++newIndex;
                }
                result = CompareResult.NOT_EQUAL;
            }
        }
        this.myOldTree.disposeChildren(oldChildren, oldChildrenSize);
        this.myNewTree.disposeChildren(newChildren, newChildrenSize);
        CompareResult compareResult = result;
        if (compareResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/diff/DiffTree", "build"));
        }
        return compareResult;
    }

    private int match(OT[] oldChildren, int oldIndex, NT[] newChildren, int newIndex, int level, int step, int maxLength) {
        int delta;
        for (delta = 0; delta != maxLength * step; delta += step) {
            OT oldChild = oldChildren[oldIndex + delta];
            NT newChild = newChildren[newIndex + delta];
            CompareResult c11 = this.looksEqual(this.myComparator, oldChild, newChild);
            if (c11 == CompareResult.DRILL_DOWN_NEEDED) {
                CompareResult compareResult = c11 = this.textMatch(oldChild, newChild) ? this.build(oldChild, newChild, level + 1, DiffTree.<OT, NT>emptyConsumer()) : CompareResult.NOT_EQUAL;
                assert (c11 != CompareResult.DRILL_DOWN_NEEDED);
            }
            if (c11 != CompareResult.EQUAL) break;
        }
        return delta * step;
    }

    private boolean textMatch(OT oldChild, NT newChild) {
        int oldStart = this.myOldTree.getStartOffset(oldChild) - this.myOldTreeStart;
        int oldEnd = this.myOldTree.getEndOffset(oldChild) - this.myOldTreeStart;
        int newStart = this.myNewTree.getStartOffset(newChild) - this.myNewTreeStart;
        int newEnd = this.myNewTree.getEndOffset(newChild) - this.myNewTreeStart;
        return CharArrayUtil.regionMatches(this.myOldText, oldStart, oldEnd, this.myNewText, newStart, newEnd);
    }

    @NotNull
    private CompareResult looksEqual(@NotNull ShallowNodeComparator<OT, NT> comparator, OT oldChild1, NT newChild1) {
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/diff/DiffTree", "looksEqual"));
        }
        if (oldChild1 == null || newChild1 == null) {
            CompareResult compareResult = oldChild1 == newChild1 ? CompareResult.EQUAL : CompareResult.NOT_EQUAL;
            if (compareResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/diff/DiffTree", "looksEqual"));
            }
            return compareResult;
        }
        if (!comparator.typesEqual(oldChild1, newChild1)) {
            CompareResult compareResult = CompareResult.NOT_EQUAL;
            if (compareResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/diff/DiffTree", "looksEqual"));
            }
            return compareResult;
        }
        ThreeState ret = comparator.deepEqual(oldChild1, newChild1);
        if (ret == ThreeState.YES) {
            CompareResult compareResult = CompareResult.EQUAL;
            if (compareResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/diff/DiffTree", "looksEqual"));
            }
            return compareResult;
        }
        if (ret == ThreeState.UNSURE) {
            CompareResult compareResult = CompareResult.DRILL_DOWN_NEEDED;
            if (compareResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/diff/DiffTree", "looksEqual"));
            }
            return compareResult;
        }
        CompareResult compareResult = CompareResult.TYPE_ONLY;
        if (compareResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/diff/DiffTree", "looksEqual"));
        }
        return compareResult;
    }

    private static enum CompareResult {
        EQUAL,
        DRILL_DOWN_NEEDED,
        TYPE_ONLY,
        NOT_EQUAL;

    }
}

