/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.compiled.ClsDocCommentImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class ClsDocTagImpl
extends ClsElementImpl
implements PsiDocTag {
    private final ClsDocCommentImpl myDocComment;
    private final PsiElement myNameElement;

    ClsDocTagImpl(ClsDocCommentImpl docComment, @NonNls String name) {
        this.myDocComment = docComment;
        this.myNameElement = new NameElement(this, name);
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/compiled/ClsDocTagImpl", "appendMirrorText"));
        }
        buffer.append(this.myNameElement.getText());
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/compiled/ClsDocTagImpl", "setMirror"));
        }
        this.setMirrorCheckingType(element, JavaDocElementType.DOC_TAG);
    }

    @Override
    public String getText() {
        return this.myNameElement.getText();
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        char[] cArray = this.myNameElement.textToCharArray();
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsDocTagImpl", "textToCharArray"));
        }
        return cArray;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getNameElement().getText().substring(1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsDocTagImpl", "getName"));
        }
        return string;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/compiled/ClsDocTagImpl", "textMatches"));
        }
        return this.myNameElement.textMatches(text2);
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/compiled/ClsDocTagImpl", "textMatches"));
        }
        return this.myNameElement.textMatches(element);
    }

    @Override
    public int getTextLength() {
        return this.myNameElement.getTextLength();
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = new PsiElement[]{this.myNameElement};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsDocTagImpl", "getChildren"));
        }
        return psiElementArray;
    }

    @Override
    public PsiElement getParent() {
        return this.getContainingComment();
    }

    @Override
    public PsiDocComment getContainingComment() {
        return this.myDocComment;
    }

    @Override
    public PsiElement getNameElement() {
        return this.myNameElement;
    }

    @Override
    @NotNull
    public PsiElement[] getDataElements() {
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsDocTagImpl", "getDataElements"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    public PsiDocTagValue getValueElement() {
        return null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/compiled/ClsDocTagImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitDocTag(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/compiled/ClsDocTagImpl", "setName"));
        }
        PsiImplUtil.setName(this.getNameElement(), name);
        return this;
    }

    private static class NameElement
    extends ClsElementImpl {
        private final ClsDocTagImpl myParent;
        private final String myText;

        public NameElement(ClsDocTagImpl parent, String text2) {
            this.myParent = parent;
            this.myText = text2;
        }

        @Override
        public String getText() {
            return this.myText;
        }

        @Override
        @NotNull
        public char[] textToCharArray() {
            char[] cArray = this.myText.toCharArray();
            if (cArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsDocTagImpl$NameElement", "textToCharArray"));
            }
            return cArray;
        }

        @Override
        @NotNull
        public PsiElement[] getChildren() {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsDocTagImpl$NameElement", "getChildren"));
            }
            return PsiElement.EMPTY_ARRAY;
        }

        @Override
        public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
            if (buffer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/compiled/ClsDocTagImpl$NameElement", "appendMirrorText"));
            }
        }

        @Override
        public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/compiled/ClsDocTagImpl$NameElement", "setMirror"));
            }
            this.setMirrorCheckingType(element, null);
        }

        @Override
        public PsiElement getParent() {
            return this.myParent;
        }

        @Override
        public void accept(@NotNull PsiElementVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/compiled/ClsDocTagImpl$NameElement", "accept"));
            }
            visitor.visitElement(this);
        }
    }
}

