/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ig.style.UnnecessarilyQualifiedStaticUsageInspection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnnecessarilyQualifiedStaticallyImportedElementInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessarily.qualified.statically.imported.element.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessarilyQualifiedStaticallyImportedElementInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiMember member = (PsiMember)infos[0];
        String string = InspectionGadgetsBundle.message("unnecessarily.qualified.statically.imported.element.problem.descriptor", member.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessarilyQualifiedStaticallyImportedElementInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessarilyQualifiedStaticallyImportedElementFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessarilyQualifiedStaticallyImportedElementVisitor();
    }

    private static class UnnecessarilyQualifiedStaticallyImportedElementVisitor
    extends BaseInspectionVisitor {
        private UnnecessarilyQualifiedStaticallyImportedElementVisitor() {
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.visitReferenceElement(expression);
        }

        @Override
        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            super.visitReferenceElement(reference);
            if (reference instanceof PsiMethodReferenceExpression) {
                return;
            }
            PsiElement qualifier = reference.getQualifier();
            if (!(qualifier instanceof PsiJavaCodeReferenceElement)) {
                return;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)reference, PsiImportStatementBase.class) != null) {
                return;
            }
            if (UnnecessarilyQualifiedStaticUsageInspection.isGenericReference(reference, (PsiJavaCodeReferenceElement)qualifier)) {
                return;
            }
            PsiElement target = reference.resolve();
            if (!(target instanceof PsiMember)) {
                return;
            }
            PsiMember member = (PsiMember)target;
            PsiJavaCodeReferenceElement referenceExpression = (PsiJavaCodeReferenceElement)qualifier;
            PsiElement qualifierTarget = referenceExpression.resolve();
            if (!(qualifierTarget instanceof PsiClass)) {
                return;
            }
            if (!ImportUtils.isStaticallyImported(member, reference)) {
                return;
            }
            if (!UnnecessarilyQualifiedStaticallyImportedElementVisitor.isReferenceCorrectWithoutQualifier(reference, member)) {
                return;
            }
            this.registerError(qualifier, ProblemHighlightType.LIKE_UNUSED_SYMBOL, member);
        }

        private static boolean isReferenceCorrectWithoutQualifier(PsiJavaCodeReferenceElement reference, PsiMember member) {
            PsiClass aClass;
            PsiVariable variable;
            String referenceName = reference.getReferenceName();
            if (referenceName == null) {
                return false;
            }
            Project project = reference.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
            PsiResolveHelper resolveHelper = psiFacade.getResolveHelper();
            if (member instanceof PsiMethod) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)reference.getParent().copy();
                PsiElement qualifier = methodCallExpression.getMethodExpression().getQualifier();
                assert (qualifier != null);
                qualifier.delete();
                if (!member.equals(methodCallExpression.resolveMethod())) {
                    return false;
                }
            } else if (member instanceof PsiField ? !member.equals(variable = resolveHelper.resolveAccessibleReferencedVariable(referenceName, reference)) : member instanceof PsiClass && !member.equals(aClass = resolveHelper.resolveReferencedClass(referenceName, reference))) {
                return false;
            }
            return true;
        }
    }

    private static class UnnecessarilyQualifiedStaticallyImportedElementFix
    extends InspectionGadgetsFix {
        private UnnecessarilyQualifiedStaticallyImportedElementFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessarily.qualified.statically.imported.element.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessarilyQualifiedStaticallyImportedElementInspection$UnnecessarilyQualifiedStaticallyImportedElementFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            element.delete();
        }
    }
}

