/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.google.common.collect.ConcurrentHashMultiset;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.NonCancelableSection;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.WrappedProgressIndicator;
import com.intellij.openapi.progress.impl.NonCancelableIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreProgressManager
extends ProgressManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.progress.impl.CoreProgressManager");
    static final int CHECK_CANCELED_DELAY_MILLIS = 10;
    final AtomicInteger myCurrentUnsafeProgressCount = new AtomicInteger(0);
    private final AtomicInteger myCurrentModalProgressCount = new AtomicInteger(0);
    private static final boolean ENABLED = !"disabled".equals(System.getProperty("idea.ProcessCanceledException"));
    private static CheckCanceledHook ourCheckCanceledHook;
    private ScheduledFuture<?> myCheckCancelledFuture;
    private static final Map<ProgressIndicator, Set<Thread>> threadsUnderIndicator;
    private static final ConcurrentLongObjectMap<ProgressIndicator> currentIndicators;
    private static final ConcurrentLongObjectMap<ProgressIndicator> threadTopLevelIndicators;
    static final Set<Thread> threadsUnderCanceledIndicator;
    private static volatile boolean shouldCheckCanceled;
    private static final Collection<ProgressIndicator> nonStandardIndicators;
    private static final ThreadLocal<Boolean> isInNonCancelableSection;

    private void startBackgroundNonStandardIndicatorsPing() {
        if (this.myCheckCancelledFuture == null) {
            this.myCheckCancelledFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> {
                for (ProgressIndicator indicator : nonStandardIndicators) {
                    try {
                        indicator.checkCanceled();
                    }
                    catch (ProcessCanceledException e) {
                        this.indicatorCanceled(indicator);
                    }
                }
            }, 0L, 10L, TimeUnit.MILLISECONDS);
        }
    }

    private void stopBackgroundNonStandardIndicatorsPing() {
        if (this.myCheckCancelledFuture != null) {
            this.myCheckCancelledFuture.cancel(true);
            this.myCheckCancelledFuture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Map<ProgressIndicator, Set<Thread>> map = threadsUnderIndicator;
        synchronized (map) {
            this.stopBackgroundNonStandardIndicatorsPing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isThreadUnderIndicator(@NotNull ProgressIndicator indicator, @NotNull Thread thread) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager", "isThreadUnderIndicator"));
        }
        if (thread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "com/intellij/openapi/progress/impl/CoreProgressManager", "isThreadUnderIndicator"));
        }
        Map<ProgressIndicator, Set<Thread>> map = threadsUnderIndicator;
        synchronized (map) {
            Set<Thread> threads = threadsUnderIndicator.get(indicator);
            return threads != null && threads.contains(thread);
        }
    }

    public static boolean runCheckCanceledHooks(@Nullable ProgressIndicator indicator) {
        CheckCanceledHook hook = ourCheckCanceledHook;
        return hook != null && hook.runHook(indicator);
    }

    @Override
    protected void doCheckCanceled() throws ProcessCanceledException {
        if (!shouldCheckCanceled) {
            return;
        }
        ProgressIndicator progress = this.getProgressIndicator();
        if (progress != null && ENABLED) {
            progress.checkCanceled();
        } else {
            CoreProgressManager.runCheckCanceledHooks(progress);
        }
    }

    @Override
    public boolean hasProgressIndicator() {
        return this.getProgressIndicator() != null;
    }

    @Override
    public boolean hasUnsafeProgressIndicator() {
        return this.myCurrentUnsafeProgressCount.get() > 0;
    }

    @Override
    public boolean hasModalProgressIndicator() {
        return this.myCurrentModalProgressCount.get() > 0;
    }

    @Override
    public void runProcess(@NotNull Runnable process, ProgressIndicator progress) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcess"));
        }
        this.executeProcessUnderProgress(() -> {
            if (process == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/progress/impl/CoreProgressManager", "lambda$runProcess$1"));
            }
            try {
                try {
                    if (progress != null && !progress.isRunning()) {
                        progress.start();
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                process.run();
            }
            finally {
                if (progress != null && progress.isRunning()) {
                    progress.stop();
                    if (progress instanceof ProgressIndicatorEx) {
                        ((ProgressIndicatorEx)progress).processFinish();
                    }
                }
            }
        }, progress);
    }

    @Override
    public <T> T runProcess(@NotNull Computable<T> process, ProgressIndicator progress) throws ProcessCanceledException {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcess"));
        }
        Ref ref = new Ref();
        this.runProcess(() -> {
            if (process == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/progress/impl/CoreProgressManager", "lambda$runProcess$2"));
            }
            ref.set(process.compute());
        }, progress);
        return ref.get();
    }

    @Override
    public void executeNonCancelableSection(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/progress/impl/CoreProgressManager", "executeNonCancelableSection"));
        }
        if (this.isInNonCancelableSection()) {
            runnable.run();
        } else {
            try {
                isInNonCancelableSection.set(Boolean.TRUE);
                this.executeProcessUnderProgress(runnable, NonCancelableIndicator.INSTANCE);
            }
            finally {
                isInNonCancelableSection.remove();
            }
        }
    }

    @Override
    public void setCancelButtonText(String cancelButtonText) {
    }

    @Override
    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process, @NotNull @Nls String progressTitle, boolean canBeCanceled, @Nullable Project project) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressSynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressSynchronously"));
        }
        return this.runProcessWithProgressSynchronously(process, progressTitle, canBeCanceled, project, null);
    }

    @Override
    public <T, E extends Exception> T runProcessWithProgressSynchronously(final @NotNull ThrowableComputable<T, E> process, @NotNull @Nls String progressTitle, boolean canBeCanceled, @Nullable Project project) throws E {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressSynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressSynchronously"));
        }
        final AtomicReference result = new AtomicReference();
        final AtomicReference exception = new AtomicReference();
        this.runProcessWithProgressSynchronously(new Task.Modal(project, progressTitle, canBeCanceled){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$1", "run"));
                }
                try {
                    Object compute = process.compute();
                    result.set(compute);
                }
                catch (Throwable t) {
                    exception.set(t);
                }
            }
        }, null);
        Throwable t = (Throwable)exception.get();
        if (t != null) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            Exception e = (Exception)t;
            throw e;
        }
        return (T)result.get();
    }

    @Override
    public boolean runProcessWithProgressSynchronously(final @NotNull Runnable process, @NotNull @Nls String progressTitle, boolean canBeCanceled, @Nullable Project project, @Nullable JComponent parentComponent) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressSynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressSynchronously"));
        }
        Task.Modal task = new Task.Modal(project, progressTitle, canBeCanceled){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$2", "run"));
                }
                process.run();
            }
        };
        return this.runProcessWithProgressSynchronously(task, parentComponent);
    }

    @Override
    public void runProcessWithProgressAsynchronously(@NotNull Project project, @NotNull @Nls String progressTitle, @NotNull Runnable process, @Nullable Runnable successRunnable, @Nullable Runnable canceledRunnable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        this.runProcessWithProgressAsynchronously(project, progressTitle, process, successRunnable, canceledRunnable, PerformInBackgroundOption.DEAF);
    }

    @Override
    public void runProcessWithProgressAsynchronously(@NotNull Project project, @NotNull @Nls String progressTitle, final @NotNull Runnable process, final @Nullable Runnable successRunnable, final @Nullable Runnable canceledRunnable, @NotNull PerformInBackgroundOption option) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        this.runProcessWithProgressAsynchronously(new Task.Backgroundable(project, progressTitle, true, option){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$3", "run"));
                }
                process.run();
            }

            @Override
            public void onCancel() {
                if (canceledRunnable != null) {
                    canceledRunnable.run();
                }
            }

            @Override
            public void onSuccess() {
                if (successRunnable != null) {
                    successRunnable.run();
                }
            }
        });
    }

    @Override
    public void run(@NotNull Task task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager", "run"));
        }
        if (task.isHeadless()) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                this.runProcessWithProgressSynchronously(task, null);
            } else {
                this.runProcessWithProgressInCurrentThread(task, new EmptyProgressIndicator(), ModalityState.defaultModalityState());
            }
        } else if (task.isModal()) {
            this.runSynchronously(task.asModal());
        } else {
            Task.Backgroundable backgroundable = task.asBackgroundable();
            if (backgroundable.isConditionalModal() && !backgroundable.shouldStartInBackground()) {
                this.runSynchronously(task);
            } else {
                this.runAsynchronously(backgroundable);
            }
        }
    }

    private void runSynchronously(@NotNull Task task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager", "runSynchronously"));
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.runProcessWithProgressSynchronously(task, null);
        } else {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                if (task == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager", "lambda$runSynchronously$3"));
                }
                this.runProcessWithProgressSynchronously(task, null);
            });
        }
    }

    private void runAsynchronously(@NotNull Task.Backgroundable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager", "runAsynchronously"));
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.runProcessWithProgressAsynchronously(task);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (task == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager", "lambda$runAsynchronously$4"));
                }
                this.runProcessWithProgressAsynchronously(task);
            }, ModalityState.defaultModalityState());
        }
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        Future<?> future = this.runProcessWithProgressAsynchronously(task, new EmptyProgressIndicator(), null);
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        return future;
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task, @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        Future<?> future = this.runProcessWithProgressAsynchronously(task, progressIndicator, continuation, ModalityState.defaultModalityState());
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        return future;
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(final @NotNull Task.Backgroundable task, final @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation, final @NotNull ModalityState modalityState) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (progressIndicator instanceof Disposable) {
            Disposer.register(ApplicationManager.getApplication(), (Disposable)((Object)progressIndicator));
        }
        final TaskRunnable process = new TaskRunnable(task, progressIndicator, continuation);
        TaskContainer action = new TaskContainer(task){

            @Override
            public void run() {
                boolean processCanceled = false;
                Throwable exception = null;
                try {
                    CoreProgressManager.this.runProcess(process, progressIndicator);
                }
                catch (ProcessCanceledException e) {
                    processCanceled = true;
                }
                catch (Throwable e) {
                    exception = e;
                }
                boolean finalCanceled = processCanceled || progressIndicator.isCanceled();
                Throwable finalException = exception;
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (task == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager$4", "lambda$run$0"));
                    }
                    CoreProgressManager.finishTask(task, finalCanceled, finalException);
                }, modalityState);
            }
        };
        Future<?> future = ApplicationManager.getApplication().executeOnPooledThread(action);
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        return future;
    }

    public boolean runProcessWithProgressSynchronously(final @NotNull Task task, @Nullable JComponent parentComponent) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressSynchronously"));
        }
        final Ref exceptionRef = new Ref();
        TaskContainer taskContainer = new TaskContainer(task){

            @Override
            public void run() {
                try {
                    new TaskRunnable(task, CoreProgressManager.this.getProgressIndicator()).run();
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    exceptionRef.set(e);
                }
            }
        };
        ApplicationEx application = (ApplicationEx)ApplicationManager.getApplication();
        boolean result = application.runProcessWithProgressSynchronously(taskContainer, task.getTitle(), task.isCancellable(), task.getProject(), parentComponent, task.getCancelText());
        CoreProgressManager.finishTask(task, !result, (Throwable)exceptionRef.get());
        return result;
    }

    public void runProcessWithProgressInCurrentThread(@NotNull Task task, @NotNull ProgressIndicator progressIndicator, @NotNull ModalityState modalityState) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressInCurrentThread"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressInCurrentThread"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressInCurrentThread"));
        }
        if (progressIndicator instanceof Disposable) {
            Disposer.register(ApplicationManager.getApplication(), (Disposable)((Object)progressIndicator));
        }
        TaskRunnable process = new TaskRunnable(task, progressIndicator);
        boolean processCanceled = false;
        Throwable exception = null;
        try {
            this.runProcess(process, progressIndicator);
        }
        catch (ProcessCanceledException e) {
            processCanceled = true;
        }
        catch (Throwable e) {
            exception = e;
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            CoreProgressManager.finishTask(task, processCanceled || progressIndicator.isCanceled(), exception);
        } else {
            boolean finalCanceled = processCanceled;
            Throwable finalException = exception;
            ApplicationManager.getApplication().invokeAndWait(() -> {
                if (task == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager", "lambda$runProcessWithProgressInCurrentThread$5"));
                }
                if (progressIndicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/progress/impl/CoreProgressManager", "lambda$runProcessWithProgressInCurrentThread$5"));
                }
                CoreProgressManager.finishTask(task, finalCanceled || progressIndicator.isCanceled(), finalException);
            }, modalityState);
        }
    }

    static void finishTask(@NotNull Task task, boolean canceled, @Nullable Throwable error) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager", "finishTask"));
        }
        try {
            if (error != null) {
                task.onThrowable(error);
            } else if (canceled) {
                task.onCancel();
            } else {
                task.onSuccess();
            }
        }
        finally {
            task.onFinished();
        }
    }

    @Override
    public void runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task, @NotNull ProgressIndicator progressIndicator) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        this.runProcessWithProgressAsynchronously(task, progressIndicator, null);
    }

    @Override
    public ProgressIndicator getProgressIndicator() {
        return CoreProgressManager.getCurrentIndicator(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeProcessUnderProgress(@NotNull Runnable process, ProgressIndicator progress) throws ProcessCanceledException {
        block12: {
            boolean modal;
            if (process == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/progress/impl/CoreProgressManager", "executeProcessUnderProgress"));
            }
            boolean bl = modal = progress != null && progress.isModal();
            if (modal) {
                this.myCurrentModalProgressCount.incrementAndGet();
            }
            if (progress == null) {
                this.myCurrentUnsafeProgressCount.incrementAndGet();
            }
            try {
                boolean set;
                ProgressIndicator oldIndicator = null;
                boolean bl2 = set = progress != null && progress != (oldIndicator = this.getProgressIndicator());
                if (set) {
                    Thread currentThread = Thread.currentThread();
                    CoreProgressManager.setCurrentIndicator(currentThread, progress);
                    try {
                        this.registerIndicatorAndRun(progress, currentThread, oldIndicator, process);
                        break block12;
                    }
                    finally {
                        CoreProgressManager.setCurrentIndicator(currentThread, oldIndicator);
                    }
                }
                process.run();
            }
            finally {
                if (progress == null) {
                    this.myCurrentUnsafeProgressCount.decrementAndGet();
                }
                if (modal) {
                    this.myCurrentModalProgressCount.decrementAndGet();
                }
            }
        }
    }

    @Override
    public boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action, @Nullable ProgressIndicator indicator) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/impl/CoreProgressManager", "runInReadActionWithWriteActionPriority"));
        }
        ApplicationManager.getApplication().runReadAction(action);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerIndicatorAndRun(@NotNull ProgressIndicator indicator, @NotNull Thread currentThread, ProgressIndicator oldIndicator, @NotNull Runnable process) {
        ProgressIndicator thisIndicator;
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager", "registerIndicatorAndRun"));
        }
        if (currentThread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentThread", "com/intellij/openapi/progress/impl/CoreProgressManager", "registerIndicatorAndRun"));
        }
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/progress/impl/CoreProgressManager", "registerIndicatorAndRun"));
        }
        ArrayList<Set<Thread>> threadsUnderThisIndicator = new ArrayList<Set<Thread>>();
        Map<ProgressIndicator, Set<Thread>> map = threadsUnderIndicator;
        synchronized (map) {
            thisIndicator = indicator;
            while (thisIndicator != null) {
                Object underIndicator = threadsUnderIndicator.get(thisIndicator);
                if (underIndicator == null) {
                    underIndicator = new SmartHashSet();
                    threadsUnderIndicator.put(thisIndicator, (Set<Thread>)underIndicator);
                }
                boolean alreadyUnder = !underIndicator.add((Thread)currentThread);
                threadsUnderThisIndicator.add((Set<Thread>)(alreadyUnder ? null : underIndicator));
                boolean isStandard = thisIndicator instanceof StandardProgressIndicator;
                if (!isStandard) {
                    nonStandardIndicators.add(thisIndicator);
                    this.startBackgroundNonStandardIndicatorsPing();
                }
                if (thisIndicator.isCanceled()) {
                    threadsUnderCanceledIndicator.add(currentThread);
                } else {
                    threadsUnderCanceledIndicator.remove(currentThread);
                }
                thisIndicator = thisIndicator instanceof WrappedProgressIndicator ? ((WrappedProgressIndicator)thisIndicator).getOriginalProgressIndicator() : null;
            }
            this.updateShouldCheckCanceled();
        }
        try {
            process.run();
            map = threadsUnderIndicator;
        }
        catch (Throwable throwable) {
            Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
            synchronized (map2) {
                ProgressIndicator thisIndicator2 = null;
                for (int i = 0; i < threadsUnderThisIndicator.size(); ++i) {
                    boolean isStandard;
                    boolean removed;
                    thisIndicator2 = i == 0 ? indicator : ((WrappedProgressIndicator)thisIndicator2).getOriginalProgressIndicator();
                    Set underIndicator = (Set)threadsUnderThisIndicator.get(i);
                    boolean bl = removed = underIndicator != null && underIndicator.remove(currentThread);
                    if (removed && underIndicator.isEmpty()) {
                        threadsUnderIndicator.remove(thisIndicator2);
                    }
                    if (!(isStandard = thisIndicator2 instanceof StandardProgressIndicator)) {
                        nonStandardIndicators.remove(thisIndicator2);
                        if (nonStandardIndicators.isEmpty()) {
                            this.stopBackgroundNonStandardIndicatorsPing();
                        }
                    }
                    if (oldIndicator != null && oldIndicator.isCanceled()) {
                        threadsUnderCanceledIndicator.add(currentThread);
                        continue;
                    }
                    threadsUnderCanceledIndicator.remove(currentThread);
                }
                this.updateShouldCheckCanceled();
            }
            throw throwable;
        }
        synchronized (map) {
            thisIndicator = null;
            for (int i = 0; i < threadsUnderThisIndicator.size(); ++i) {
                boolean isStandard;
                boolean removed;
                thisIndicator = i == 0 ? indicator : ((WrappedProgressIndicator)thisIndicator).getOriginalProgressIndicator();
                Set underIndicator = (Set)threadsUnderThisIndicator.get(i);
                boolean bl = removed = underIndicator != null && underIndicator.remove(currentThread);
                if (removed && underIndicator.isEmpty()) {
                    threadsUnderIndicator.remove(thisIndicator);
                }
                if (!(isStandard = thisIndicator instanceof StandardProgressIndicator)) {
                    nonStandardIndicators.remove(thisIndicator);
                    if (nonStandardIndicators.isEmpty()) {
                        this.stopBackgroundNonStandardIndicatorsPing();
                    }
                }
                if (oldIndicator != null && oldIndicator.isCanceled()) {
                    threadsUnderCanceledIndicator.add(currentThread);
                    continue;
                }
                threadsUnderCanceledIndicator.remove(currentThread);
            }
            this.updateShouldCheckCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateShouldCheckCanceled() {
        ourCheckCanceledHook = this.createCheckCanceledHook();
        if (ourCheckCanceledHook != null) {
            shouldCheckCanceled = true;
            return;
        }
        Map<ProgressIndicator, Set<Thread>> map = threadsUnderIndicator;
        synchronized (map) {
            shouldCheckCanceled = !threadsUnderCanceledIndicator.isEmpty();
        }
    }

    @Nullable
    protected CheckCanceledHook createCheckCanceledHook() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void indicatorCanceled(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager", "indicatorCanceled"));
        }
        Map<ProgressIndicator, Set<Thread>> map = threadsUnderIndicator;
        synchronized (map) {
            Set<Thread> threads = threadsUnderIndicator.get(indicator);
            if (threads != null) {
                for (Thread thread : threads) {
                    boolean underCancelledIndicator = false;
                    ProgressIndicator currentIndicator = CoreProgressManager.getCurrentIndicator(thread);
                    while (currentIndicator != null) {
                        if (currentIndicator == indicator) {
                            underCancelledIndicator = true;
                            break;
                        }
                        currentIndicator = currentIndicator instanceof WrappedProgressIndicator ? ((WrappedProgressIndicator)currentIndicator).getOriginalProgressIndicator() : null;
                    }
                    if (!underCancelledIndicator) continue;
                    threadsUnderCanceledIndicator.add(thread);
                    shouldCheckCanceled = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCanceledThread(@NotNull Thread thread) {
        if (thread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "com/intellij/openapi/progress/impl/CoreProgressManager", "isCanceledThread"));
        }
        Map<ProgressIndicator, Set<Thread>> map = threadsUnderIndicator;
        synchronized (map) {
            return threadsUnderCanceledIndicator.contains(thread);
        }
    }

    @Override
    @NotNull
    public final NonCancelableSection startNonCancelableSection() {
        LOG.warn("Use executeNonCancelableSection() instead");
        if (this.isInNonCancelableSection()) {
            NonCancelableSection nonCancelableSection = NonCancelableSection.EMPTY;
            if (nonCancelableSection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/impl/CoreProgressManager", "startNonCancelableSection"));
            }
            return nonCancelableSection;
        }
        final ProgressIndicator myOld = this.getProgressIndicator();
        final Thread currentThread = Thread.currentThread();
        NonCancelableIndicator nonCancelor = new NonCancelableIndicator(){

            @Override
            public void done() {
                CoreProgressManager.setCurrentIndicator(currentThread, myOld);
                isInNonCancelableSection.remove();
            }
        };
        isInNonCancelableSection.set(Boolean.TRUE);
        CoreProgressManager.setCurrentIndicator(currentThread, nonCancelor);
        NonCancelableIndicator nonCancelableIndicator = nonCancelor;
        if (nonCancelableIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/impl/CoreProgressManager", "startNonCancelableSection"));
        }
        return nonCancelableIndicator;
    }

    @Override
    public boolean isInNonCancelableSection() {
        return isInNonCancelableSection.get() != null;
    }

    @NotNull
    public static ModalityState getCurrentThreadProgressModality() {
        ProgressIndicator indicator = threadTopLevelIndicators.get(Thread.currentThread().getId());
        ModalityState modality = indicator == null ? null : indicator.getModalityState();
        ModalityState modalityState = modality != null ? modality : ModalityState.NON_MODAL;
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/impl/CoreProgressManager", "getCurrentThreadProgressModality"));
        }
        return modalityState;
    }

    private static void setCurrentIndicator(@NotNull Thread currentThread, ProgressIndicator indicator) {
        if (currentThread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentThread", "com/intellij/openapi/progress/impl/CoreProgressManager", "setCurrentIndicator"));
        }
        long id = currentThread.getId();
        if (indicator == null) {
            currentIndicators.remove(id);
            threadTopLevelIndicators.remove(id);
        } else {
            currentIndicators.put(id, indicator);
            if (!threadTopLevelIndicators.containsKey(id)) {
                threadTopLevelIndicators.put(id, indicator);
            }
        }
    }

    private static ProgressIndicator getCurrentIndicator(@NotNull Thread thread) {
        if (thread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "com/intellij/openapi/progress/impl/CoreProgressManager", "getCurrentIndicator"));
        }
        return currentIndicators.get(thread.getId());
    }

    static {
        threadsUnderIndicator = new THashMap();
        currentIndicators = ContainerUtil.createConcurrentLongObjectMap();
        threadTopLevelIndicators = ContainerUtil.createConcurrentLongObjectMap();
        threadsUnderCanceledIndicator = new THashSet();
        nonStandardIndicators = ConcurrentHashMultiset.create();
        isInNonCancelableSection = new ThreadLocal();
    }

    @FunctionalInterface
    protected static interface CheckCanceledHook {
        public boolean runHook(@Nullable ProgressIndicator var1);
    }

    static class TaskRunnable
    extends TaskContainer {
        private final ProgressIndicator myIndicator;
        private final Runnable myContinuation;

        TaskRunnable(@NotNull Task task, @NotNull ProgressIndicator indicator) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager$TaskRunnable", "<init>"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$TaskRunnable", "<init>"));
            }
            this(task, indicator, null);
        }

        TaskRunnable(@NotNull Task task, @NotNull ProgressIndicator indicator, @Nullable Runnable continuation) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager$TaskRunnable", "<init>"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$TaskRunnable", "<init>"));
            }
            super(task);
            this.myIndicator = indicator;
            this.myContinuation = continuation;
        }

        @Override
        public void run() {
            try {
                this.getTask().run(this.myIndicator);
            }
            finally {
                try {
                    if (this.myIndicator instanceof ProgressIndicatorEx) {
                        ((ProgressIndicatorEx)this.myIndicator).finish(this.getTask());
                    }
                }
                finally {
                    if (this.myContinuation != null) {
                        this.myContinuation.run();
                    }
                }
            }
        }
    }

    protected static abstract class TaskContainer
    implements Runnable {
        private final Task myTask;

        protected TaskContainer(@NotNull Task task) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager$TaskContainer", "<init>"));
            }
            this.myTask = task;
        }

        @NotNull
        public Task getTask() {
            Task task = this.myTask;
            if (task == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/impl/CoreProgressManager$TaskContainer", "getTask"));
            }
            return task;
        }

        public String toString() {
            return this.myTask.toString();
        }
    }
}

