/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.NullnessUtil;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DfaVariableState {
    @NotNull
    final Set<DfaPsiType> myInstanceofValues;
    @NotNull
    final Set<DfaPsiType> myNotInstanceofValues;
    @NotNull
    final DfaFactMap myFactMap;
    private final int myHash;

    DfaVariableState(@NotNull DfaVariableValue dfaVar) {
        if (dfaVar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaVar", "com/intellij/codeInspection/dataFlow/DfaVariableState", "<init>"));
        }
        this(Collections.emptySet(), Collections.emptySet(), dfaVar.getInherentFacts());
    }

    public boolean isSuperStateOf(DfaVariableState that) {
        if (!this.myNotInstanceofValues.equals(that.myNotInstanceofValues)) {
            return false;
        }
        if (!this.myInstanceofValues.equals(that.myNotInstanceofValues)) {
            return false;
        }
        return this.myFactMap.isSuperStateOf(that.myFactMap);
    }

    DfaVariableState(@NotNull Set<DfaPsiType> instanceofValues, @NotNull Set<DfaPsiType> notInstanceofValues, @NotNull DfaFactMap factMap) {
        if (instanceofValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceofValues", "com/intellij/codeInspection/dataFlow/DfaVariableState", "<init>"));
        }
        if (notInstanceofValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notInstanceofValues", "com/intellij/codeInspection/dataFlow/DfaVariableState", "<init>"));
        }
        if (factMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factMap", "com/intellij/codeInspection/dataFlow/DfaVariableState", "<init>"));
        }
        this.myInstanceofValues = instanceofValues;
        this.myNotInstanceofValues = notInstanceofValues;
        this.myFactMap = factMap;
        this.myHash = Objects.hash(this.myInstanceofValues, this.myNotInstanceofValues, this.myFactMap);
    }

    private boolean checkInstanceofValue(@NotNull DfaPsiType dfaType) {
        if (dfaType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaType", "com/intellij/codeInspection/dataFlow/DfaVariableState", "checkInstanceofValue"));
        }
        if (this.myInstanceofValues.contains(dfaType)) {
            return true;
        }
        for (DfaPsiType dfaTypeValue : this.myNotInstanceofValues) {
            if (!dfaTypeValue.isAssignableFrom(dfaType)) continue;
            return false;
        }
        for (DfaPsiType dfaTypeValue : this.myInstanceofValues) {
            if (dfaType.isConvertibleFrom(dfaTypeValue)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    DfaVariableState withInstanceofValue(@NotNull DfaTypeValue dfaType) {
        if (dfaType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaType", "com/intellij/codeInspection/dataFlow/DfaVariableState", "withInstanceofValue"));
        }
        if (dfaType.getDfaType().getPsiType() instanceof PsiPrimitiveType) {
            return this;
        }
        if (this.checkInstanceofValue(dfaType.getDfaType())) {
            DfaVariableState result = dfaType.isNullable() ? this.withFact(DfaFactType.CAN_BE_NULL, true) : this;
            ArrayList moreGeneric = ContainerUtil.newArrayList();
            for (DfaPsiType alreadyInstanceof : this.myInstanceofValues) {
                if (dfaType.getDfaType().isAssignableFrom(alreadyInstanceof)) {
                    return result;
                }
                if (!alreadyInstanceof.isAssignableFrom(dfaType.getDfaType())) continue;
                moreGeneric.add(alreadyInstanceof);
            }
            HashSet<DfaPsiType> newInstanceof = ContainerUtil.newHashSet(this.myInstanceofValues);
            newInstanceof.removeAll(moreGeneric);
            newInstanceof.add(dfaType.getDfaType());
            result = this.createCopy(newInstanceof, this.myNotInstanceofValues, result.myFactMap);
            return result;
        }
        return null;
    }

    @Nullable
    DfaVariableState withNotInstanceofValue(@NotNull DfaTypeValue dfaType) {
        if (dfaType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaType", "com/intellij/codeInspection/dataFlow/DfaVariableState", "withNotInstanceofValue"));
        }
        if (this.myNotInstanceofValues.contains(dfaType.getDfaType())) {
            return this;
        }
        for (DfaPsiType dfaPsiType : this.myInstanceofValues) {
            if (!dfaType.getDfaType().isAssignableFrom(dfaPsiType)) continue;
            return null;
        }
        ArrayList moreSpecific = ContainerUtil.newArrayList();
        for (DfaPsiType alreadyNotInstanceof : this.myNotInstanceofValues) {
            if (alreadyNotInstanceof.isAssignableFrom(dfaType.getDfaType())) {
                return this;
            }
            if (!dfaType.getDfaType().isAssignableFrom(alreadyNotInstanceof)) continue;
            moreSpecific.add(alreadyNotInstanceof);
        }
        HashSet<DfaPsiType> hashSet = ContainerUtil.newHashSet(this.myNotInstanceofValues);
        hashSet.removeAll(moreSpecific);
        hashSet.add(dfaType.getDfaType());
        return this.createCopy(this.myInstanceofValues, hashSet, this.myFactMap);
    }

    @NotNull
    DfaVariableState withoutType(@NotNull DfaPsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInspection/dataFlow/DfaVariableState", "withoutType"));
        }
        if (this.myInstanceofValues.contains(type)) {
            HashSet<DfaPsiType> newInstanceof = ContainerUtil.newHashSet(this.myInstanceofValues);
            newInstanceof.remove(type);
            DfaVariableState dfaVariableState = this.createCopy(newInstanceof, this.myNotInstanceofValues, this.myFactMap);
            if (dfaVariableState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaVariableState", "withoutType"));
            }
            return dfaVariableState;
        }
        if (this.myNotInstanceofValues.contains(type)) {
            HashSet<DfaPsiType> newNotInstanceof = ContainerUtil.newHashSet(this.myNotInstanceofValues);
            newNotInstanceof.remove(type);
            DfaVariableState dfaVariableState = this.createCopy(this.myInstanceofValues, newNotInstanceof, this.myFactMap);
            if (dfaVariableState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaVariableState", "withoutType"));
            }
            return dfaVariableState;
        }
        DfaVariableState dfaVariableState = this;
        if (dfaVariableState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaVariableState", "withoutType"));
        }
        return dfaVariableState;
    }

    public int hashCode() {
        return this.myHash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DfaVariableState)) {
            return false;
        }
        DfaVariableState aState = (DfaVariableState)obj;
        return this.myHash == aState.myHash && this.myInstanceofValues.equals(aState.myInstanceofValues) && this.myNotInstanceofValues.equals(aState.myNotInstanceofValues) && Objects.equals(this.myFactMap, aState.myFactMap);
    }

    @NotNull
    protected DfaVariableState createCopy(@NotNull Set<DfaPsiType> instanceofValues, @NotNull Set<DfaPsiType> notInstanceofValues, @NotNull DfaFactMap factMap) {
        if (instanceofValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceofValues", "com/intellij/codeInspection/dataFlow/DfaVariableState", "createCopy"));
        }
        if (notInstanceofValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notInstanceofValues", "com/intellij/codeInspection/dataFlow/DfaVariableState", "createCopy"));
        }
        if (factMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factMap", "com/intellij/codeInspection/dataFlow/DfaVariableState", "createCopy"));
        }
        DfaVariableState dfaVariableState = new DfaVariableState(instanceofValues, notInstanceofValues, factMap);
        if (dfaVariableState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaVariableState", "createCopy"));
        }
        return dfaVariableState;
    }

    public String toString() {
        String factString;
        StringBuilder buf = new StringBuilder("State:");
        if (!this.myInstanceofValues.isEmpty()) {
            buf.append(" instanceof ").append(StringUtil.join(this.myInstanceofValues, ","));
        }
        if (!this.myNotInstanceofValues.isEmpty()) {
            buf.append(" not instanceof ").append(StringUtil.join(this.myNotInstanceofValues, ","));
        }
        if (!(factString = this.myFactMap.toString()).isEmpty()) {
            buf.append(" ").append(factString);
        }
        return buf.toString();
    }

    @NotNull
    Nullness getNullability() {
        Nullness nullness = NullnessUtil.fromBoolean(this.myFactMap.get(DfaFactType.CAN_BE_NULL));
        if (nullness == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaVariableState", "getNullability"));
        }
        return nullness;
    }

    public boolean isNotNull() {
        return this.getNullability() == Nullness.NOT_NULL;
    }

    @NotNull
    DfaVariableState withNotNull() {
        DfaVariableState dfaVariableState = this.getNullability() == Nullness.NOT_NULL ? this : this.withoutFact(DfaFactType.CAN_BE_NULL);
        if (dfaVariableState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaVariableState", "withNotNull"));
        }
        return dfaVariableState;
    }

    @NotNull
    <T> DfaVariableState withFact(DfaFactType<T> type, T value) {
        DfaFactMap factMap = this.myFactMap.with(type, value);
        DfaVariableState dfaVariableState = this.myFactMap.equals(factMap) ? this : this.createCopy(this.myInstanceofValues, this.myNotInstanceofValues, factMap);
        if (dfaVariableState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaVariableState", "withFact"));
        }
        return dfaVariableState;
    }

    <T> DfaVariableState withoutFact(DfaFactType<T> type) {
        return this.withFact(type, null);
    }

    @Nullable
    <T> DfaVariableState intersectFact(DfaFactType<T> type, T value) {
        DfaFactMap factMap = this.myFactMap.intersect(type, value);
        return factMap == null ? null : (this.myFactMap.equals(factMap) ? this : this.createCopy(this.myInstanceofValues, this.myNotInstanceofValues, factMap));
    }

    @NotNull
    public DfaVariableState withValue(DfaValue value) {
        DfaVariableState dfaVariableState = this;
        if (dfaVariableState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaVariableState", "withValue"));
        }
        return dfaVariableState;
    }

    @Nullable
    public DfaValue getValue() {
        return null;
    }

    @NotNull
    public Set<DfaPsiType> getInstanceofValues() {
        Set<DfaPsiType> set = this.myInstanceofValues;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaVariableState", "getInstanceofValues"));
        }
        return set;
    }

    @NotNull
    public Set<DfaPsiType> getNotInstanceofValues() {
        Set<DfaPsiType> set = this.myNotInstanceofValues;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaVariableState", "getNotInstanceofValues"));
        }
        return set;
    }

    @Nullable
    public <T> T getFact(@NotNull DfaFactType<T> factType) {
        if (factType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factType", "com/intellij/codeInspection/dataFlow/DfaVariableState", "getFact"));
        }
        return this.myFactMap.get(factType);
    }
}

