/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.miscGenerics.GenericsInspectionToolBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RedundantTypeArgsInspection
extends GenericsInspectionToolBase {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.miscGenerics.RedundantTypeArgsInspection");
    private static final LocalQuickFix ourQuickFixAction = new MyQuickFixAction();
    public static final String SHORT_NAME = "RedundantTypeArguments";

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.VERBOSE_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.redundant.type.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection", "getShortName"));
        }
        return SHORT_NAME;
    }

    @Override
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod psiMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection", "checkMethod"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection", "checkMethod"));
        }
        PsiCodeBlock body = psiMethod.getBody();
        if (body != null) {
            return this.getDescriptions(body, manager, isOnTheFly);
        }
        return null;
    }

    @Override
    public ProblemDescriptor[] getDescriptions(@NotNull PsiElement place, final @NotNull InspectionManager inspectionManager, boolean isOnTheFly) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection", "getDescriptions"));
        }
        if (inspectionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionManager", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection", "getDescriptions"));
        }
        final ArrayList problems = new ArrayList();
        place.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                super.visitMethodCallExpression(expression);
                PsiType[] typeArguments = expression.getTypeArguments();
                if (typeArguments.length > 0) {
                    RedundantTypeArgsInspection.checkCallExpression(expression.getMethodExpression(), typeArguments, expression, inspectionManager, problems);
                }
            }

            @Override
            public void visitNewExpression(PsiNewExpression expression) {
                PsiJavaCodeReferenceElement classReference;
                super.visitNewExpression(expression);
                PsiType[] typeArguments = expression.getTypeArguments();
                if (typeArguments.length > 0 && (classReference = expression.getClassReference()) != null) {
                    RedundantTypeArgsInspection.checkCallExpression(classReference, typeArguments, expression, inspectionManager, problems);
                }
            }

            @Override
            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
                super.visitMethodReferenceExpression(expression);
                RedundantTypeArgsInspection.checkMethodReference(expression, inspectionManager, problems);
            }
        });
        if (problems.isEmpty()) {
            return null;
        }
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    private static void checkCallExpression(PsiJavaCodeReferenceElement reference, PsiType[] typeArguments, PsiCallExpression expression, InspectionManager inspectionManager, List<ProblemDescriptor> problems) {
        PsiMethod method;
        PsiTypeParameter[] typeParameters;
        PsiExpressionList argumentList = expression.getArgumentList();
        if (argumentList == null) {
            return;
        }
        JavaResolveResult resolveResult = reference.advancedResolve(false);
        PsiElement element = resolveResult.getElement();
        if (element instanceof PsiMethod && resolveResult.isValidResult() && (typeParameters = (method = (PsiMethod)element).getTypeParameters()).length == typeArguments.length && PsiDiamondTypeUtil.areTypeArgumentsRedundant(typeArguments, expression, false, method, typeParameters)) {
            ProblemDescriptor descriptor = inspectionManager.createProblemDescriptor((PsiElement)expression.getTypeArgumentList(), InspectionsBundle.message("inspection.redundant.type.problem.descriptor", new Object[0]), ourQuickFixAction, ProblemHighlightType.LIKE_UNUSED_SYMBOL, false);
            problems.add(descriptor);
        }
    }

    private static void checkMethodReference(PsiMethodReferenceExpression expression, InspectionManager inspectionManager, List<ProblemDescriptor> problems) {
        PsiType psiType;
        PsiTypeElement qualifierTypeElement = expression.getQualifierType();
        if (qualifierTypeElement != null && (psiType = qualifierTypeElement.getType()) instanceof PsiClassType && !((PsiClassType)psiType).isRaw()) {
            PsiClass aClass = ((PsiClassType)psiType).resolve();
            if (aClass == null) {
                return;
            }
            JavaResolveResult result = expression.advancedResolve(false);
            PsiElement element = result.getElement();
            if (element instanceof PsiTypeParameterListOwner) {
                PsiMethod method;
                PsiMethod psiMethod = method = element instanceof PsiMethod ? (PsiMethod)element : null;
                if (PsiDiamondTypeUtil.areTypeArgumentsRedundant(((PsiClassType)psiType).getParameters(), expression, false, method, aClass.getTypeParameters())) {
                    PsiJavaCodeReferenceElement referenceElement = qualifierTypeElement.getInnermostComponentReferenceElement();
                    LOG.assertTrue(referenceElement != null, qualifierTypeElement);
                    PsiReferenceParameterList parameterList = referenceElement.getParameterList();
                    LOG.assertTrue(parameterList != null);
                    ProblemDescriptor descriptor = inspectionManager.createProblemDescriptor((PsiElement)parameterList, InspectionsBundle.message("inspection.redundant.type.problem.descriptor", new Object[0]), new MyMethodReferenceFixAction(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, false);
                    problems.add(descriptor);
                }
            }
        }
    }

    private static PsiMethodReferenceExpression createMethodReference(PsiMethodReferenceExpression expression, PsiTypeElement typeElement) {
        PsiType type = typeElement.getType();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(expression.getProject());
        PsiMethodReferenceExpression copy = (PsiMethodReferenceExpression)expression.copy();
        copy.getQualifierType().replace(elementFactory.createTypeElement(((PsiClassType)type).rawType()));
        return copy;
    }

    private static class MyMethodReferenceFixAction
    implements LocalQuickFix {
        private MyMethodReferenceFixAction() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message("inspection.redundant.type.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyMethodReferenceFixAction", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyMethodReferenceFixAction", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyMethodReferenceFixAction", "applyFix"));
            }
            PsiTypeElement typeElement = PsiTreeUtil.getParentOfType(descriptor.getPsiElement(), PsiTypeElement.class);
            PsiMethodReferenceExpression expression = PsiTreeUtil.getParentOfType((PsiElement)typeElement, PsiMethodReferenceExpression.class);
            if (expression != null) {
                expression.replace(RedundantTypeArgsInspection.createMethodReference(expression, typeElement));
            }
        }
    }

    private static class MyQuickFixAction
    implements LocalQuickFix {
        private MyQuickFixAction() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message("inspection.redundant.type.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyQuickFixAction", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyQuickFixAction", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyQuickFixAction", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiReferenceParameterList)) {
                return;
            }
            PsiReferenceParameterList typeArgumentList = (PsiReferenceParameterList)element;
            try {
                PsiMethodCallExpression expr = (PsiMethodCallExpression)JavaPsiFacade.getInstance(project).getElementFactory().createExpressionFromText("foo()", null);
                typeArgumentList.replace(expr.getTypeArgumentList());
            }
            catch (IncorrectOperationException e) {
                LOG.error(e);
            }
        }
    }
}

