/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.BaseDataReader;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public abstract class BinaryOutputReader
extends BaseDataReader {
    @NotNull
    private final InputStream myStream;
    @NotNull
    private final byte[] myBuffer;

    public BinaryOutputReader(@NotNull InputStream stream, @NotNull BaseDataReader.SleepingPolicy sleepingPolicy) {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/util/io/BinaryOutputReader", "<init>"));
        }
        if (sleepingPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sleepingPolicy", "com/intellij/util/io/BinaryOutputReader", "<init>"));
        }
        super(sleepingPolicy);
        this.myBuffer = new byte[8192];
        this.myStream = stream;
    }

    @Override
    protected boolean readAvailableNonBlocking() throws IOException {
        int n;
        byte[] buffer = this.myBuffer;
        boolean read2 = false;
        while (this.myStream.available() > 0 && (n = this.myStream.read(buffer)) >= 0) {
            if (n <= 0) continue;
            read2 = true;
            this.onBinaryAvailable(buffer, n);
        }
        return read2;
    }

    @Override
    protected final boolean readAvailableBlocking() throws IOException {
        int n;
        byte[] buffer = this.myBuffer;
        boolean read2 = false;
        while ((n = this.myStream.read(buffer)) >= 0) {
            if (n <= 0) continue;
            read2 = true;
            this.onBinaryAvailable(buffer, n);
        }
        return read2;
    }

    protected abstract void onBinaryAvailable(@NotNull byte[] var1, int var2);

    @Override
    protected void close() throws IOException {
        this.myStream.close();
    }
}

