/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.testFrameworks;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class AssertHint {
    private final int myArgIndex;
    private final boolean myMessageOnFirstPosition;
    private final PsiExpression myMessage;
    private final PsiMethod myMethod;

    private AssertHint(int index, boolean messageOnFirstPosition, PsiExpression message, PsiMethod method) {
        this.myArgIndex = index;
        this.myMessageOnFirstPosition = messageOnFirstPosition;
        this.myMessage = message;
        this.myMethod = method;
    }

    public boolean isMessageOnFirstPosition() {
        return this.myMessageOnFirstPosition;
    }

    public int getArgIndex() {
        return this.myArgIndex;
    }

    public PsiMethod getMethod() {
        return this.myMethod;
    }

    public PsiExpression getPosition(PsiExpression[] arguments) {
        return arguments[this.myArgIndex];
    }

    @Nullable
    public PsiExpression getMessage() {
        return this.myMessage;
    }

    public static AssertHint createAssertEqualsHint(PsiMethodCallExpression expression, boolean checkTestNG) {
        return AssertHint.create(expression, methodName -> "assertEquals".equals(methodName) ? Integer.valueOf(2) : null, checkTestNG);
    }

    public static AssertHint createAssertTrueFalseHint(PsiMethodCallExpression expression, boolean checkTestNG) {
        return AssertHint.create(expression, methodName -> "assertTrue".equals(methodName) || "assertFalse".equals(methodName) ? Integer.valueOf(1) : null, checkTestNG);
    }

    public static AssertHint create(PsiMethodCallExpression expression, Function<String, Integer> methodNameToParamCount, boolean checkTestNG) {
        int argumentIndex;
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        Integer minimumParamCount = methodNameToParamCount.apply(methodName);
        if (minimumParamCount == null) {
            return null;
        }
        JavaResolveResult resolveResult = expression.resolveMethodGenerics();
        PsiMethod method = (PsiMethod)resolveResult.getElement();
        if (method == null || method.hasModifierProperty("private") || !resolveResult.isValidResult()) {
            return null;
        }
        boolean messageOnLastPosition = AssertHint.isMessageOnLastPosition(method, checkTestNG);
        boolean messageOnFirstPosition = AssertHint.isMessageOnFirstPosition(method, checkTestNG);
        if (!messageOnFirstPosition && !messageOnLastPosition) {
            return null;
        }
        PsiParameterList parameterList = method.getParameterList();
        PsiParameter[] parameters = parameterList.getParameters();
        if (parameters.length < minimumParamCount) {
            return null;
        }
        PsiExpressionList argumentList = expression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        PsiExpression message = null;
        if (messageOnFirstPosition) {
            if (parameters.length > 0 && parameters[0].getType().equalsToText("java.lang.String") && parameters.length > minimumParamCount) {
                argumentIndex = 1;
                message = arguments[0];
            } else {
                argumentIndex = 0;
            }
        } else {
            int lastParameterIdx;
            argumentIndex = 0;
            if (parameters.length > minimumParamCount && minimumParamCount >= 0 && parameters[lastParameterIdx = parameters.length - 1].getType() instanceof PsiClassType) {
                message = arguments[lastParameterIdx];
            }
        }
        return new AssertHint(argumentIndex, messageOnFirstPosition, message, method);
    }

    public static boolean isMessageOnFirstPosition(PsiMethod method, boolean checkTestNG) {
        PsiClass containingClass = method.getContainingClass();
        String qualifiedName = containingClass.getQualifiedName();
        if (checkTestNG) {
            return "org.testng.AssertJUnit".equals(qualifiedName) || "org.testng.Assert".equals(qualifiedName) && "fail".equals(method.getName());
        }
        return "junit.framework.Assert".equals(qualifiedName) || "org.junit.Assert".equals(qualifiedName) || "junit.framework.TestCase".equals(qualifiedName) || "org.junit.Assume".equals(qualifiedName);
    }

    public static boolean isMessageOnLastPosition(PsiMethod method, boolean checkTestNG) {
        PsiClass containingClass = method.getContainingClass();
        String qualifiedName = containingClass.getQualifiedName();
        if (checkTestNG) {
            return "org.testng.Assert".equals(qualifiedName) && !"fail".equals(method.getName());
        }
        return "org.junit.jupiter.api.Assertions".equals(qualifiedName) || "org.junit.jupiter.api.Assumptions".equals(qualifiedName);
    }

    public static String areExpectedActualTypesCompatible(PsiMethodCallExpression expression, boolean checkTestNG) {
        int argIndex;
        AssertHint assertHint = AssertHint.createAssertEqualsHint(expression, checkTestNG);
        if (assertHint == null) {
            return null;
        }
        PsiExpression[] arguments = expression.getArgumentList().getExpressions();
        PsiType type1 = arguments[argIndex = assertHint.getArgIndex()].getType();
        if (type1 == null) {
            return null;
        }
        PsiType type2 = arguments[argIndex + 1].getType();
        if (type2 == null) {
            return null;
        }
        PsiParameter[] parameters = assertHint.getMethod().getParameterList().getParameters();
        PsiType parameterType1 = parameters[argIndex].getType();
        PsiType parameterType2 = parameters[argIndex + 1].getType();
        PsiClassType objectType = TypeUtils.getObjectType(expression);
        if (!objectType.equals(parameterType1) || !objectType.equals(parameterType2)) {
            return null;
        }
        if (TypeUtils.areConvertible(type1, type2)) {
            return null;
        }
        String comparedTypeText = type1.getPresentableText();
        String comparisonTypeText = type2.getPresentableText();
        return InspectionGadgetsBundle.message("assertequals.between.inconvertible.types.problem.descriptor", StringUtil.escapeXml(comparedTypeText), StringUtil.escapeXml(comparisonTypeText));
    }

    public static class JUnitCommonAssertNames {
        @NonNls
        public static final Map<String, Integer> COMMON_ASSERT_METHODS = new HashMap<String, Integer>(13);

        static {
            COMMON_ASSERT_METHODS.put("assertArrayEquals", 2);
            COMMON_ASSERT_METHODS.put("assertEquals", 2);
            COMMON_ASSERT_METHODS.put("assertNotEquals", 2);
            COMMON_ASSERT_METHODS.put("assertFalse", 1);
            COMMON_ASSERT_METHODS.put("assumeFalse", 1);
            COMMON_ASSERT_METHODS.put("assertNotNull", 1);
            COMMON_ASSERT_METHODS.put("assertNotSame", 2);
            COMMON_ASSERT_METHODS.put("assertNull", 1);
            COMMON_ASSERT_METHODS.put("assertSame", 2);
            COMMON_ASSERT_METHODS.put("assertThat", 2);
            COMMON_ASSERT_METHODS.put("assertTrue", 1);
            COMMON_ASSERT_METHODS.put("assumeTrue", 1);
            COMMON_ASSERT_METHODS.put("fail", 0);
        }
    }
}

