/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.library;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpsMavenRepositoryLibraryDescriptor {
    private final String myMavenId;
    private final String myGroupId;
    private final String myArtifactId;
    private final String myVersion;
    private final boolean myIncludeTransitiveDependencies;

    public JpsMavenRepositoryLibraryDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "org/jetbrains/jps/model/library/JpsMavenRepositoryLibraryDescriptor", "<init>"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "org/jetbrains/jps/model/library/JpsMavenRepositoryLibraryDescriptor", "<init>"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/jps/model/library/JpsMavenRepositoryLibraryDescriptor", "<init>"));
        }
        this(groupId, artifactId, version, true);
    }

    public JpsMavenRepositoryLibraryDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, boolean includeTransitiveDependencies) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "org/jetbrains/jps/model/library/JpsMavenRepositoryLibraryDescriptor", "<init>"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "org/jetbrains/jps/model/library/JpsMavenRepositoryLibraryDescriptor", "<init>"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/jps/model/library/JpsMavenRepositoryLibraryDescriptor", "<init>"));
        }
        this.myGroupId = groupId;
        this.myArtifactId = artifactId;
        this.myVersion = version;
        this.myIncludeTransitiveDependencies = includeTransitiveDependencies;
        this.myMavenId = groupId + ":" + artifactId + ":" + version;
    }

    public JpsMavenRepositoryLibraryDescriptor(@Nullable String mavenId) {
        this(mavenId, true);
    }

    public JpsMavenRepositoryLibraryDescriptor(@Nullable String mavenId, boolean includeTransitiveDependencies) {
        this.myMavenId = mavenId;
        this.myIncludeTransitiveDependencies = includeTransitiveDependencies;
        if (mavenId == null) {
            this.myVersion = null;
            this.myArtifactId = null;
            this.myGroupId = null;
        } else {
            String[] parts = mavenId.split(":");
            this.myGroupId = parts.length > 0 ? parts[0] : null;
            this.myArtifactId = parts.length > 1 ? parts[1] : null;
            this.myVersion = parts.length > 2 ? parts[2] : null;
        }
    }

    public String getMavenId() {
        return this.myMavenId;
    }

    public String getGroupId() {
        return this.myGroupId;
    }

    public String getArtifactId() {
        return this.myArtifactId;
    }

    public boolean isIncludeTransitiveDependencies() {
        return this.myIncludeTransitiveDependencies;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JpsMavenRepositoryLibraryDescriptor that = (JpsMavenRepositoryLibraryDescriptor)o;
        return Objects.equals(this.myMavenId, that.myMavenId) && this.myIncludeTransitiveDependencies == that.myIncludeTransitiveDependencies;
    }

    public int hashCode() {
        return Objects.hashCode(this.myMavenId) * 31 + (this.myIncludeTransitiveDependencies ? 1 : 0);
    }
}

