/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.Ref;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiParameterPattern;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaPsiUtil {
    public static boolean isFinalField(PsiVariable var) {
        return var.hasModifierProperty("final") && !var.hasModifierProperty("transient") && var instanceof PsiField;
    }

    static PsiElement getEnclosingCodeBlock(PsiVariable variable, PsiElement context) {
        PsiAnonymousClass anon;
        PsiElement codeBlock;
        if (variable instanceof PsiParameter) {
            codeBlock = ((PsiParameter)variable).getDeclarationScope();
            if (codeBlock instanceof PsiMethod) {
                codeBlock = ((PsiMethod)codeBlock).getBody();
            }
        } else {
            codeBlock = variable instanceof PsiLocalVariable ? PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class) : DfaPsiUtil.getTopmostBlockInSameClass(context);
        }
        while (codeBlock != null && (anon = PsiTreeUtil.getParentOfType(codeBlock, PsiAnonymousClass.class)) != null) {
            codeBlock = PsiTreeUtil.getParentOfType((PsiElement)anon, PsiCodeBlock.class);
        }
        return codeBlock;
    }

    @NotNull
    public static Nullness getElementNullability(@Nullable PsiType resultType, @Nullable PsiModifierListOwner owner) {
        if (owner == null) {
            Nullness nullness = DfaPsiUtil.getTypeNullability(resultType);
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getElementNullability"));
            }
            return nullness;
        }
        if (resultType instanceof PsiPrimitiveType) {
            Nullness nullness = Nullness.UNKNOWN;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getElementNullability"));
            }
            return nullness;
        }
        if (owner instanceof PsiEnumConstant || PsiUtil.isAnnotationMethod(owner)) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getElementNullability"));
            }
            return nullness;
        }
        if (owner instanceof PsiMethod && DfaPsiUtil.isEnumPredefinedMethod((PsiMethod)owner)) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getElementNullability"));
            }
            return nullness;
        }
        if (NullableNotNullManager.isNullable(owner)) {
            Nullness nullness = Nullness.NULLABLE;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getElementNullability"));
            }
            return nullness;
        }
        if (DfaPsiUtil.isNotNullLocally(owner)) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getElementNullability"));
            }
            return nullness;
        }
        Nullness fromType = DfaPsiUtil.getTypeNullability(resultType);
        if (fromType != Nullness.UNKNOWN) {
            Nullness nullness = fromType;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getElementNullability"));
            }
            return nullness;
        }
        if (((PsiParameterPattern)PsiJavaPatterns.psiParameter().withParents(PsiParameterList.class, PsiLambdaExpression.class)).accepts(owner)) {
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)owner.getParent().getParent();
            int index = lambda2.getParameterList().getParameterIndex((PsiParameter)owner);
            Nullness nullness = DfaPsiUtil.getFunctionalParameterNullability(lambda2, index);
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getElementNullability"));
            }
            return nullness;
        }
        Nullness nullness = Nullness.UNKNOWN;
        if (nullness == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getElementNullability"));
        }
        return nullness;
    }

    @NotNull
    public static Nullness getTypeNullability(@Nullable PsiType type) {
        if (type == null) {
            Nullness nullness = Nullness.UNKNOWN;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getTypeNullability"));
            }
            return nullness;
        }
        Ref<Nullness> result = Ref.create(Nullness.UNKNOWN);
        InheritanceUtil.processSuperTypes(type, true, eachType -> {
            result.set(DfaPsiUtil.getTypeOwnNullability(result, eachType));
            return result.get() == Nullness.UNKNOWN;
        });
        Nullness nullness = result.get();
        if (nullness == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getTypeNullability"));
        }
        return nullness;
    }

    @NotNull
    private static Nullness getTypeOwnNullability(Ref<Nullness> result, PsiType eachType) {
        for (PsiAnnotation annotation : eachType.getAnnotations()) {
            String qualifiedName = annotation.getQualifiedName();
            NullableNotNullManager nnn = NullableNotNullManager.getInstance(annotation.getProject());
            if (nnn.getNullables().contains(qualifiedName)) {
                Nullness nullness = Nullness.NULLABLE;
                if (nullness == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getTypeOwnNullability"));
                }
                return nullness;
            }
            if (!nnn.getNotNulls().contains(qualifiedName)) continue;
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getTypeOwnNullability"));
            }
            return nullness;
        }
        Nullness nullness = Nullness.UNKNOWN;
        if (nullness == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getTypeOwnNullability"));
        }
        return nullness;
    }

    @NotNull
    public static Nullness getFunctionalParameterNullability(PsiFunctionalExpression function, int index) {
        Nullness nullness = DfaPsiUtil.inferLambdaParameterNullness(function, index);
        if (nullness != Nullness.UNKNOWN) {
            Nullness nullness2 = nullness;
            if (nullness2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getFunctionalParameterNullability"));
            }
            return nullness2;
        }
        PsiClassType type = ObjectUtils.tryCast(function.getFunctionalInterfaceType(), PsiClassType.class);
        PsiMethod sam2 = LambdaUtil.getFunctionalInterfaceMethod(type);
        if (sam2 != null && index < sam2.getParameterList().getParametersCount()) {
            PsiParameter parameter = sam2.getParameterList().getParameters()[index];
            nullness = DfaPsiUtil.getElementNullability(null, parameter);
            if (nullness != Nullness.UNKNOWN) {
                Nullness nullness3 = nullness;
                if (nullness3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getFunctionalParameterNullability"));
                }
                return nullness3;
            }
            PsiType parameterType = type.resolveGenerics().getSubstitutor().substitute(parameter.getType());
            Nullness nullness4 = DfaPsiUtil.getTypeNullability(parameterType);
            if (nullness4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getFunctionalParameterNullability"));
            }
            return nullness4;
        }
        Nullness nullness5 = Nullness.UNKNOWN;
        if (nullness5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getFunctionalParameterNullability"));
        }
        return nullness5;
    }

    @NotNull
    private static Nullness inferLambdaParameterNullness(PsiFunctionalExpression lambda2, int parameterIndex) {
        PsiMethod method;
        PsiExpressionList list;
        PsiElement listParent;
        PsiElement expression = lambda2;
        PsiElement expressionParent = lambda2.getParent();
        while (expressionParent instanceof PsiConditionalExpression || expressionParent instanceof PsiParenthesizedExpression) {
            expression = expressionParent;
            expressionParent = expressionParent.getParent();
        }
        if (expressionParent instanceof PsiExpressionList && (listParent = (list = (PsiExpressionList)expressionParent).getParent()) instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)listParent).resolveMethod()) != null) {
            int expressionIndex = ArrayUtil.find(list.getExpressions(), expression);
            Nullness nullness = DfaPsiUtil.getLambdaParameterNullness(method, expressionIndex, parameterIndex);
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "inferLambdaParameterNullness"));
            }
            return nullness;
        }
        Nullness nullness = Nullness.UNKNOWN;
        if (nullness == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "inferLambdaParameterNullness"));
        }
        return nullness;
    }

    @NotNull
    private static Nullness getLambdaParameterNullness(@NotNull PsiMethod method, int parameterIndex, int lambdaParameterIndex) {
        String methodName;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getLambdaParameterNullness"));
        }
        PsiClass type = method.getContainingClass();
        if (type != null && "java.util.Optional".equals(type.getQualifiedName()) && ((methodName = method.getName()).equals("map") || methodName.equals("filter") || methodName.equals("ifPresent") || methodName.equals("flatMap")) && parameterIndex == 0 && lambdaParameterIndex == 0) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getLambdaParameterNullness"));
            }
            return nullness;
        }
        Nullness nullness = Nullness.UNKNOWN;
        if (nullness == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getLambdaParameterNullness"));
        }
        return nullness;
    }

    private static boolean isNotNullLocally(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "isNotNullLocally"));
        }
        NullableNotNullManager nnnm = NullableNotNullManager.getInstance(owner.getProject());
        PsiAnnotation notNullAnno = nnnm.getNotNullAnnotation(owner, true);
        if (notNullAnno == null) {
            return false;
        }
        if (!(owner instanceof PsiParameter)) {
            return true;
        }
        return DfaPsiUtil.isOwnAnnotation(owner, notNullAnno) || nnnm.isContainerAnnotation(notNullAnno);
    }

    private static boolean isOwnAnnotation(@NotNull PsiModifierListOwner owner, @NotNull PsiAnnotation anno) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "isOwnAnnotation"));
        }
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "isOwnAnnotation"));
        }
        return AnnotationUtil.findAnnotation(owner, anno.getQualifiedName()) == anno;
    }

    private static boolean isEnumPredefinedMethod(PsiMethod method) {
        PsiClass containingClass;
        String methodName = method.getName();
        if (("valueOf".equals(methodName) || "values".equals(methodName)) && method.hasModifierProperty("static") && (containingClass = method.getContainingClass()) != null && containingClass.isEnum()) {
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if ("values".equals(methodName)) {
                return parameters.length == 0;
            }
            return parameters.length == 1 && parameters[0].getType().equalsToText("java.lang.String");
        }
        return false;
    }

    public static boolean isInitializedNotNull(PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        PsiMethod[] constructors = containingClass.getConstructors();
        if (constructors.length == 0) {
            return false;
        }
        for (PsiMethod method : constructors) {
            if (DfaPsiUtil.getNotNullInitializedFields(method, containingClass).contains(field)) continue;
            return false;
        }
        return true;
    }

    private static Set<PsiField> getNotNullInitializedFields(final PsiMethod constructor, final PsiClass containingClass) {
        if (!constructor.getLanguage().isKindOf(JavaLanguage.INSTANCE)) {
            return Collections.emptySet();
        }
        PsiCodeBlock body = constructor.getBody();
        if (body == null) {
            return Collections.emptySet();
        }
        return CachedValuesManager.getCachedValue(constructor, new CachedValueProvider<Set<PsiField>>(){

            @Override
            @NotNull
            public CachedValueProvider.Result<Set<PsiField>> compute() {
                PsiCodeBlock body = constructor.getBody();
                final HashMap map = ContainerUtil.newHashMap();
                StandardDataFlowRunner dfaRunner = new StandardDataFlowRunner(false, false){

                    private boolean isCallExposingNonInitializedFields(Instruction instruction) {
                        PsiExpression qualifier;
                        if (!(instruction instanceof MethodCallInstruction) || ((MethodCallInstruction)instruction).getMethodType() != MethodCallInstruction.MethodType.REGULAR_METHOD_CALL) {
                            return false;
                        }
                        PsiCall call = ((MethodCallInstruction)instruction).getCallExpression();
                        if (call == null) {
                            return false;
                        }
                        if (call instanceof PsiNewExpression && this.canAccessFields((PsiExpression)((Object)call))) {
                            return true;
                        }
                        if (call instanceof PsiMethodCallExpression && ((qualifier = ((PsiMethodCallExpression)call).getMethodExpression().getQualifierExpression()) == null || this.canAccessFields(qualifier))) {
                            return true;
                        }
                        PsiExpressionList argumentList = call.getArgumentList();
                        if (argumentList != null) {
                            for (PsiExpression expression : argumentList.getExpressions()) {
                                if (!this.canAccessFields(expression)) continue;
                                return true;
                            }
                        }
                        return false;
                    }

                    private boolean canAccessFields(PsiExpression expression) {
                        PsiClass type = PsiUtil.resolveClassInClassTypeOnly(expression.getType());
                        JBIterable<PsiClass> typeContainers = JBIterable.generate(type, PsiClass::getContainingClass).takeWhile(c -> !c.hasModifierProperty("static"));
                        return typeContainers.contains(containingClass);
                    }

                    @Override
                    @NotNull
                    protected DfaInstructionState[] acceptInstruction(@NotNull InstructionVisitor visitor, @NotNull DfaInstructionState instructionState) {
                        if (visitor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/codeInspection/dataFlow/DfaPsiUtil$1$1", "acceptInstruction"));
                        }
                        if (instructionState == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instructionState", "com/intellij/codeInspection/dataFlow/DfaPsiUtil$1$1", "acceptInstruction"));
                        }
                        Instruction instruction = instructionState.getInstruction();
                        if (this.isCallExposingNonInitializedFields(instruction) || instruction instanceof ReturnInstruction && !((ReturnInstruction)instruction).isViaException()) {
                            for (PsiField field : containingClass.getFields()) {
                                if (!instructionState.getMemoryState().isNotNull(this.getFactory().getVarFactory().createVariableValue(field, false))) {
                                    map.put(field, false);
                                    continue;
                                }
                                if (map.containsKey(field)) continue;
                                map.put(field, true);
                            }
                            if (DfaInstructionState.EMPTY_ARRAY == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil$1$1", "acceptInstruction"));
                            }
                            return DfaInstructionState.EMPTY_ARRAY;
                        }
                        DfaInstructionState[] dfaInstructionStateArray = super.acceptInstruction(visitor, instructionState);
                        if (dfaInstructionStateArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil$1$1", "acceptInstruction"));
                        }
                        return dfaInstructionStateArray;
                    }
                };
                RunnerResult rc = dfaRunner.analyzeMethod(body, new StandardInstructionVisitor());
                HashSet notNullFields = ContainerUtil.newHashSet();
                if (rc == RunnerResult.OK) {
                    for (PsiField field : map.keySet()) {
                        if (!((Boolean)map.get(field)).booleanValue()) continue;
                        notNullFields.add(field);
                    }
                }
                CachedValueProvider.Result<Set<PsiField>> result = CachedValueProvider.Result.create(notNullFields, constructor, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil$1", "compute"));
                }
                return result;
            }
        });
    }

    public static List<PsiExpression> findAllConstructorInitializers(PsiField field) {
        List<PsiExpression> result = ContainerUtil.createLockFreeCopyOnWriteList();
        ContainerUtil.addIfNotNull(result, field.getInitializer());
        PsiClass containingClass = field.getContainingClass();
        if (containingClass != null && !(containingClass instanceof PsiCompiledElement)) {
            result.addAll(DfaPsiUtil.getAllConstructorFieldInitializers(containingClass).get(field));
        }
        return result;
    }

    private static MultiMap<PsiField, PsiExpression> getAllConstructorFieldInitializers(final PsiClass psiClass) {
        if (psiClass instanceof PsiCompiledElement) {
            return MultiMap.EMPTY;
        }
        return CachedValuesManager.getCachedValue(psiClass, new CachedValueProvider<MultiMap<PsiField, PsiExpression>>(){

            @Override
            @NotNull
            public CachedValueProvider.Result<MultiMap<PsiField, PsiExpression>> compute() {
                final HashSet fieldNames = ContainerUtil.newHashSet();
                for (PsiField field : psiClass.getFields()) {
                    ContainerUtil.addIfNotNull(fieldNames, field.getName());
                }
                final MultiMap result = new MultiMap();
                JavaRecursiveElementWalkingVisitor visitor = new JavaRecursiveElementWalkingVisitor(){

                    @Override
                    public void visitAssignmentExpression(PsiAssignmentExpression assignment) {
                        PsiElement target;
                        super.visitAssignmentExpression(assignment);
                        PsiExpression lExpression = assignment.getLExpression();
                        PsiExpression rExpression = assignment.getRExpression();
                        if (rExpression != null && lExpression instanceof PsiReferenceExpression && fieldNames.contains(((PsiReferenceExpression)lExpression).getReferenceName()) && (target = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiField && ((PsiField)target).getContainingClass() == psiClass) {
                            result.putValue((PsiField)target, rExpression);
                        }
                    }
                };
                for (PsiMethod constructor : psiClass.getConstructors()) {
                    if (!constructor.getLanguage().isKindOf(JavaLanguage.INSTANCE)) continue;
                    constructor.accept(visitor);
                }
                CachedValueProvider.Result<MultiMap<PsiField, PsiExpression>> result2 = CachedValueProvider.Result.create(result, psiClass);
                if (result2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil$2", "compute"));
                }
                return result2;
            }
        });
    }

    @Nullable
    public static PsiElement getTopmostBlockInSameClass(@NotNull PsiElement position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getTopmostBlockInSameClass"));
        }
        return JBIterable.generate(position, PsiElement::getParent).takeWhile(e -> !(e instanceof PsiMember) && !(e instanceof PsiFile) && !(e instanceof PsiLambdaExpression)).filter(e -> e instanceof PsiCodeBlock || e instanceof PsiExpression && e.getParent() instanceof PsiLambdaExpression).last();
    }

    @NotNull
    public static Collection<PsiExpression> getVariableAssignmentsInFile(@NotNull PsiVariable psiVariable, boolean literalsOnly, PsiElement place) {
        if (psiVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiVariable", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getVariableAssignmentsInFile"));
        }
        Ref<Boolean> modificationRef = Ref.create(Boolean.FALSE);
        PsiElement codeBlock = place == null ? null : DfaPsiUtil.getTopmostBlockInSameClass(place);
        int placeOffset = codeBlock != null ? place.getTextRange().getStartOffset() : 0;
        PsiFile containingFile = psiVariable.getContainingFile();
        LocalSearchScope scope = new LocalSearchScope(new PsiElement[]{containingFile}, null, true);
        Collection<PsiReference> references = ReferencesSearch.search(psiVariable, scope).findAll();
        List<PsiExpression> list = ContainerUtil.mapNotNull(references, psiReference -> {
            if (((Boolean)modificationRef.get()).booleanValue()) {
                return null;
            }
            PsiElement parent = psiReference.getElement().getParent();
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                IElementType operation = assignmentExpression.getOperationTokenType();
                if (assignmentExpression.getLExpression() == psiReference) {
                    if (JavaTokenType.EQ.equals(operation)) {
                        PsiExpression rValue = assignmentExpression.getRExpression();
                        if (!literalsOnly || DfaPsiUtil.allOperandsAreLiterals(rValue)) {
                            if (codeBlock != null && PsiTreeUtil.isAncestor(codeBlock, parent, true) && placeOffset < parent.getTextRange().getStartOffset()) {
                                return null;
                            }
                            return rValue;
                        }
                        modificationRef.set(Boolean.TRUE);
                    } else if (JavaTokenType.PLUSEQ.equals(operation)) {
                        modificationRef.set(Boolean.TRUE);
                    }
                }
            }
            return null;
        });
        if (modificationRef.get().booleanValue()) {
            List<PsiExpression> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getVariableAssignmentsInFile"));
            }
            return list2;
        }
        PsiExpression initializer = psiVariable.getInitializer();
        if (initializer != null && (!literalsOnly || DfaPsiUtil.allOperandsAreLiterals(initializer))) {
            list = ContainerUtil.concat(list, Collections.singletonList(initializer));
        }
        List<PsiExpression> list3 = list;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil", "getVariableAssignmentsInFile"));
        }
        return list3;
    }

    private static boolean allOperandsAreLiterals(@Nullable PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        if (expression instanceof PsiLiteralExpression) {
            return true;
        }
        if (expression instanceof PsiPolyadicExpression) {
            Stack<PsiExpression> stack = new Stack<PsiExpression>();
            stack.add(expression);
            while (!stack.isEmpty()) {
                PsiExpression psiExpression = (PsiExpression)stack.pop();
                if (psiExpression instanceof PsiPolyadicExpression) {
                    PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)psiExpression;
                    for (PsiExpression op : binaryExpression.getOperands()) {
                        stack.push(op);
                    }
                    continue;
                }
                if (psiExpression instanceof PsiLiteralExpression) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

