/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class HtmlMissingClosingTagInspection
extends HtmlLocalInspectionTool {
    @Override
    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInspection/htmlInspections/HtmlMissingClosingTagInspection", "checkTag"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/htmlInspections/HtmlMissingClosingTagInspection", "checkTag"));
        }
        if (!(tag instanceof HtmlTag) || !XmlHighlightVisitor.shouldBeValidated(tag)) {
            return;
        }
        PsiElement child = tag.getLastChild();
        if (child instanceof PsiErrorElement) {
            return;
        }
        XmlToken tagNameElement = XmlTagUtil.getStartTagNameElement(tag);
        if (tagNameElement == null) {
            return;
        }
        String tagName = tagNameElement.getText();
        if (HtmlUtil.isSingleHtmlTag(tagName) || XmlTagUtil.getEndTagNameElement(tag) != null) {
            return;
        }
        holder.registerProblem((PsiElement)tagNameElement, XmlErrorMessages.message("element.missing.end.tag", new Object[0]), new MissingClosingTagFix(tagName));
    }

    private static class MissingClosingTagFix
    implements LocalQuickFix {
        private final String myName;

        public MissingClosingTagFix(String name) {
            this.myName = name;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = XmlErrorMessages.message("add.named.closing.tag", this.myName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlMissingClosingTagInspection$MissingClosingTagFix", "getName"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = XmlErrorMessages.message("add.closing.tag", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlMissingClosingTagInspection$MissingClosingTagFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/htmlInspections/HtmlMissingClosingTagInspection$MissingClosingTagFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/htmlInspections/HtmlMissingClosingTagInspection$MissingClosingTagFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof XmlToken)) {
                return;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof XmlTag)) {
                return;
            }
            String text2 = parent.getText();
            if (text2.contains("\n")) {
                int cutoff = -1;
                for (int i2 = text2.length() - 1; i2 > 0; --i2) {
                    char c = text2.charAt(i2);
                    if (c == ' ' || c == '\t') continue;
                    if (c != '\n') break;
                    cutoff = i2;
                }
                if (cutoff > 0) {
                    text2 = text2.substring(0, cutoff);
                }
            }
            String replacementText = text2 + "</" + element.getText() + ">";
            XmlElementFactory factory = XmlElementFactory.getInstance(project);
            XmlTag newTag = factory.createHTMLTagFromText(replacementText);
            PsiElement child = parent.getLastChild().copy();
            CodeStyleManager.getInstance(project).performActionWithFormatterDisabled(() -> {
                PsiElement grandChild;
                PsiElement replacement = parent.replace(newTag);
                if (child instanceof XmlText && (grandChild = child.getLastChild()) instanceof PsiWhiteSpace) {
                    XmlTag dummyTag = factory.createHTMLTagFromText("<dummy>" + grandChild.getText() + "</dummy>");
                    XmlText whitespace = PsiTreeUtil.getChildOfType(dummyTag, XmlText.class);
                    assert (whitespace != null);
                    replacement.getParent().addAfter(whitespace, replacement);
                }
            });
        }
    }
}

