/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.ProjectRootListener;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.ex.ProjectRoot;
import com.intellij.openapi.projectRoots.impl.ProjectRootContainerImpl;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.RootProviderBaseImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectJdkImpl
extends UserDataHolderBase
implements Sdk,
SdkModificator {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.projectRoots.impl.ProjectJdkImpl");
    private final ProjectRootContainerImpl myRootContainer;
    private String myName;
    private String myVersionString;
    private boolean myVersionDefined;
    private String myHomePath = "";
    private final MyRootProvider myRootProvider = new MyRootProvider();
    private ProjectJdkImpl myOrigin;
    private SdkAdditionalData myAdditionalData;
    private SdkTypeId mySdkType;
    @NonNls
    public static final String ELEMENT_NAME = "name";
    @NonNls
    public static final String ATTRIBUTE_VALUE = "value";
    @NonNls
    public static final String ELEMENT_TYPE = "type";
    @NonNls
    private static final String ELEMENT_VERSION = "version";
    @NonNls
    private static final String ELEMENT_ROOTS = "roots";
    @NonNls
    private static final String ELEMENT_HOMEPATH = "homePath";
    @NonNls
    private static final String ELEMENT_ADDITIONAL = "additional";

    public ProjectJdkImpl(String name, SdkTypeId sdkType) {
        this.mySdkType = sdkType;
        this.myRootContainer = new ProjectRootContainerImpl(true);
        this.myName = name;
        this.myRootContainer.addProjectRootContainerListener(this.myRootProvider);
    }

    public ProjectJdkImpl(String name, SdkTypeId sdkType, String homePath, String version) {
        this(name, sdkType);
        this.myHomePath = homePath;
        this.myVersionString = version;
    }

    @Override
    @NotNull
    public SdkTypeId getSdkType() {
        if (this.mySdkType == null) {
            this.mySdkType = ProjectJdkTable.getInstance().getDefaultSdkType();
        }
        SdkTypeId sdkTypeId = this.mySdkType;
        if (sdkTypeId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl", "getSdkType"));
        }
        return sdkTypeId;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl", "getName"));
        }
        return string;
    }

    @Override
    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_NAME, "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl", "setName"));
        }
        this.myName = name;
    }

    @Override
    public final void setVersionString(@Nullable String versionString) {
        this.myVersionString = versionString == null || versionString.isEmpty() ? null : versionString;
        this.myVersionDefined = true;
    }

    @Override
    public String getVersionString() {
        String homePath;
        if (this.myVersionString == null && !this.myVersionDefined && (homePath = this.getHomePath()) != null && !homePath.isEmpty()) {
            this.setVersionString(this.getSdkType().getVersionString(this));
        }
        return this.myVersionString;
    }

    public final void resetVersionString() {
        this.myVersionDefined = false;
        this.myVersionString = null;
    }

    @Override
    public String getHomePath() {
        return this.myHomePath;
    }

    @Override
    public VirtualFile getHomeDirectory() {
        if (this.myHomePath == null) {
            return null;
        }
        return StandardFileSystems.local().findFileByPath(this.myHomePath);
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl", "readExternal"));
        }
        this.readExternal(element, null);
    }

    public void readExternal(@NotNull Element element, @Nullable ProjectJdkTable projectJdkTable) throws InvalidDataException {
        Element version;
        String sdkTypeName;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl", "readExternal"));
        }
        this.myName = element.getChild(ELEMENT_NAME).getAttributeValue(ATTRIBUTE_VALUE);
        Element typeChild = element.getChild(ELEMENT_TYPE);
        String string = sdkTypeName = typeChild != null ? typeChild.getAttributeValue(ATTRIBUTE_VALUE) : null;
        if (sdkTypeName != null) {
            if (projectJdkTable == null) {
                projectJdkTable = ProjectJdkTable.getInstance();
            }
            this.mySdkType = projectJdkTable.getSdkTypeByName(sdkTypeName);
        }
        if ((version = element.getChild(ELEMENT_VERSION)) != null) {
            this.setVersionString(version.getAttributeValue(ATTRIBUTE_VALUE));
        } else {
            this.myVersionDefined = false;
        }
        this.myRootContainer.changeRoots(() -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl", "lambda$readExternal$0"));
            }
            String versionValue = element.getAttributeValue(ELEMENT_VERSION, "");
            if (versionValue.isEmpty() || !"2".equals(versionValue)) {
                throw new InvalidDataException("Too old version is not supported: " + versionValue);
            }
            this.myHomePath = element.getChild(ELEMENT_HOMEPATH).getAttributeValue(ATTRIBUTE_VALUE);
            this.myRootContainer.readExternal(element.getChild(ELEMENT_ROOTS));
        });
        Element additional = element.getChild(ELEMENT_ADDITIONAL);
        if (additional != null) {
            LOG.assertTrue(this.mySdkType != null);
            this.myAdditionalData = this.mySdkType.loadAdditionalData(this, additional);
        } else {
            this.myAdditionalData = null;
        }
    }

    public void writeExternal(Element element) {
        element.setAttribute(ELEMENT_VERSION, "2");
        Element name = new Element(ELEMENT_NAME);
        name.setAttribute(ATTRIBUTE_VALUE, this.myName);
        element.addContent(name);
        if (this.mySdkType != null) {
            Element sdkType = new Element(ELEMENT_TYPE);
            sdkType.setAttribute(ATTRIBUTE_VALUE, this.mySdkType.getName());
            element.addContent(sdkType);
        }
        if (this.myVersionString != null) {
            Element version = new Element(ELEMENT_VERSION);
            version.setAttribute(ATTRIBUTE_VALUE, this.myVersionString);
            element.addContent(version);
        }
        Element home = new Element(ELEMENT_HOMEPATH);
        home.setAttribute(ATTRIBUTE_VALUE, this.myHomePath);
        element.addContent(home);
        Element roots = new Element(ELEMENT_ROOTS);
        this.myRootContainer.writeExternal(roots);
        element.addContent(roots);
        Element additional = new Element(ELEMENT_ADDITIONAL);
        if (this.myAdditionalData != null) {
            LOG.assertTrue(this.mySdkType != null);
            this.mySdkType.saveAdditionalData(this.myAdditionalData, additional);
        }
        element.addContent(additional);
    }

    @Override
    public void setHomePath(String path) {
        boolean changes = this.myHomePath == null ? path != null : !this.myHomePath.equals(path);
        this.myHomePath = path;
        if (changes) {
            this.resetVersionString();
        }
    }

    @Override
    @NotNull
    public ProjectJdkImpl clone() {
        ProjectJdkImpl newJdk = new ProjectJdkImpl("", this.mySdkType);
        this.copyTo(newJdk);
        ProjectJdkImpl projectJdkImpl = newJdk;
        if (projectJdkImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl", "clone"));
        }
        return projectJdkImpl;
    }

    @Override
    @NotNull
    public RootProvider getRootProvider() {
        MyRootProvider myRootProvider = this.myRootProvider;
        if (myRootProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl", "getRootProvider"));
        }
        return myRootProvider;
    }

    void copyTo(@NotNull ProjectJdkImpl dest) {
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl", "copyTo"));
        }
        String name = this.getName();
        dest.setName(name);
        dest.setHomePath(this.getHomePath());
        dest.myVersionDefined = this.myVersionDefined;
        dest.myVersionString = this.myVersionString;
        dest.setSdkAdditionalData(this.getSdkAdditionalData());
        dest.copyRootsFrom(this.myRootContainer);
    }

    void copyRootsFrom(@NotNull ProjectRootContainerImpl rootContainer) {
        if (rootContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootContainer", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl", "copyRootsFrom"));
        }
        this.myRootContainer.copyRootsFrom(rootContainer);
    }

    @Override
    @NotNull
    public SdkModificator getSdkModificator() {
        ProjectJdkImpl sdk = this.clone();
        sdk.myOrigin = this;
        sdk.myRootContainer.startChange();
        sdk.update();
        ProjectJdkImpl projectJdkImpl = sdk;
        if (projectJdkImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl", "getSdkModificator"));
        }
        return projectJdkImpl;
    }

    @Override
    public void commitChanges() {
        LOG.assertTrue(this.isWritable());
        this.copyTo(this.myOrigin);
        this.myOrigin = null;
    }

    @Override
    public SdkAdditionalData getSdkAdditionalData() {
        return this.myAdditionalData;
    }

    @Override
    public void setSdkAdditionalData(SdkAdditionalData data) {
        this.myAdditionalData = data;
    }

    @Override
    public VirtualFile[] getRoots(OrderRootType rootType) {
        ProjectRoot[] roots = this.myRootContainer.getRoots(rootType);
        ArrayList files = new ArrayList(roots.length);
        for (ProjectRoot root : roots) {
            ContainerUtil.addAll(files, root.getVirtualFiles());
        }
        return VfsUtilCore.toVirtualFileArray(files);
    }

    @Override
    public void addRoot(VirtualFile root, OrderRootType rootType) {
        this.myRootContainer.addRoot(root, rootType);
    }

    @Override
    public void removeRoot(VirtualFile root, OrderRootType rootType) {
        this.myRootContainer.removeRoot(root, rootType);
    }

    @Override
    public void removeRoots(OrderRootType rootType) {
        this.myRootContainer.removeAllRoots(rootType);
    }

    @Override
    public void removeAllRoots() {
        this.myRootContainer.removeAllRoots();
    }

    @Override
    public boolean isWritable() {
        return this.myOrigin != null;
    }

    public void update() {
        try {
            this.myRootContainer.update();
        }
        finally {
            this.resetVersionString();
        }
    }

    public String toString() {
        return this.myName + (this.myVersionDefined ? ": " + this.myVersionString : "") + " (" + this.myHomePath + ")";
    }

    private class MyRootProvider
    extends RootProviderBaseImpl
    implements ProjectRootListener {
        private final List<RootProvider.RootSetChangedListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

        private MyRootProvider() {
        }

        @Override
        @NotNull
        public String[] getUrls(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl$MyRootProvider", "getUrls"));
            }
            ProjectRoot[] rootFiles = ProjectJdkImpl.this.myRootContainer.getRoots(rootType);
            ArrayList<String> result = new ArrayList<String>();
            for (ProjectRoot rootFile : rootFiles) {
                ContainerUtil.addAll(result, rootFile.getUrls());
            }
            String[] stringArray = ArrayUtil.toStringArray(result);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl$MyRootProvider", "getUrls"));
            }
            return stringArray;
        }

        @Override
        @NotNull
        public VirtualFile[] getFiles(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl$MyRootProvider", "getFiles"));
            }
            VirtualFile[] virtualFileArray = ProjectJdkImpl.this.myRootContainer.getRootFiles(rootType);
            if (virtualFileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl$MyRootProvider", "getFiles"));
            }
            return virtualFileArray;
        }

        @Override
        public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl$MyRootProvider", "addRootSetChangedListener"));
            }
            if (!this.myListeners.contains(listener)) {
                this.myListeners.add(listener);
                super.addRootSetChangedListener(listener);
            }
        }

        @Override
        public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener, @NotNull Disposable parentDisposable) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl$MyRootProvider", "addRootSetChangedListener"));
            }
            if (parentDisposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl$MyRootProvider", "addRootSetChangedListener"));
            }
            super.addRootSetChangedListener(listener, parentDisposable);
            Disposer.register(parentDisposable, () -> {
                if (listener == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl$MyRootProvider", "lambda$addRootSetChangedListener$0"));
                }
                this.removeRootSetChangedListener(listener);
            });
        }

        @Override
        public void removeRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl$MyRootProvider", "removeRootSetChangedListener"));
            }
            super.removeRootSetChangedListener(listener);
            this.myListeners.remove(listener);
        }

        @Override
        public void rootsChanged() {
            if (this.myListeners.isEmpty()) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(this::fireRootSetChanged);
        }
    }
}

