/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.storage;

import com.intellij.openapi.module.Module;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClassPathStorageUtil {
    @NonNls
    public static final String DEFAULT_STORAGE = "default";

    @NotNull
    public static String getStorageType(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/impl/storage/ClassPathStorageUtil", "getStorageType"));
        }
        String id = module.getOptionValue("classpath");
        String string = id == null ? DEFAULT_STORAGE : id;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/storage/ClassPathStorageUtil", "getStorageType"));
        }
        return string;
    }

    public static boolean isClasspathStorage(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/impl/storage/ClassPathStorageUtil", "isClasspathStorage"));
        }
        return module.getOptionValue("classpath") != null;
    }
}

